/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.ConfigException;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectoryService;
import com.caucho.server.distcache.CacheData;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.HashManager;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.HashKey;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCacheBacking
implements CacheDataBacking {
    private static final Logger log = Logger.getLogger(DataCacheBacking.class.getName());
    private DataStore _dataStore;
    private MnodeStore _mnodeStore;

    public void setDataStore(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public void setMnodeStore(MnodeStore mnodeStore) {
        this._mnodeStore = mnodeStore;
    }

    @Override
    public DataStore getDataStore() {
        return this._dataStore;
    }

    @Override
    public MnodeStore getMnodeStore() {
        return this._mnodeStore;
    }

    @Override
    public MnodeValue loadLocalEntryValue(HashKey key) {
        return this._mnodeStore.load(key);
    }

    @Override
    public MnodeValue insertLocalValue(HashKey key, MnodeValue mnodeValue, MnodeValue oldEntryValue, long timeout) {
        if (oldEntryValue == null || oldEntryValue.isImplicitNull() || oldEntryValue == MnodeValue.NULL) {
            if (this._mnodeStore.insert(key, mnodeValue.getValueHashKey(), mnodeValue.getCacheHashKey(), mnodeValue.getFlags(), mnodeValue.getVersion(), mnodeValue.getExpireTimeout(), mnodeValue.getIdleTimeout(), mnodeValue.getLeaseTimeout(), mnodeValue.getLocalReadTimeout())) {
                return mnodeValue;
            }
            log.fine(this + " db insert failed due to timing conflict" + "(key=" + key + ")");
            return oldEntryValue;
        }
        if (this._mnodeStore.updateSave(key, mnodeValue.getValueHashKey(), mnodeValue.getVersion(), timeout)) {
            return mnodeValue;
        }
        if (this._mnodeStore.insert(key, mnodeValue.getValueHashKey(), mnodeValue.getCacheHashKey(), mnodeValue.getFlags(), mnodeValue.getVersion(), mnodeValue.getExpireTimeout(), mnodeValue.getIdleTimeout(), mnodeValue.getLeaseTimeout(), mnodeValue.getLocalReadTimeout())) {
            return mnodeValue;
        }
        log.fine(this + " db update failed due to timing conflict" + "(key=" + key + ")");
        return oldEntryValue;
    }

    @Override
    public MnodeValue putLocalValue(MnodeValue mnodeValue, HashKey key, MnodeValue oldEntryValue, long version, HashKey valueHash, Object value, HashKey cacheHash, int flags, long expireTimeout, long idleTimeout, long leaseTimeout, long localReadTimeout, int leaseOwner) {
        if (oldEntryValue == null || oldEntryValue.isImplicitNull() || oldEntryValue == MnodeValue.NULL) {
            if (this._mnodeStore.insert(key, valueHash, cacheHash, flags, version, expireTimeout, idleTimeout, leaseTimeout, localReadTimeout)) {
                return mnodeValue;
            }
            log.fine(this + " db insert failed due to timing conflict" + "(key=" + key + ", version=" + version + ")");
        } else {
            if (this._mnodeStore.updateSave(key, valueHash, version, idleTimeout)) {
                return mnodeValue;
            }
            if (this._mnodeStore.insert(key, valueHash, cacheHash, flags, version, expireTimeout, idleTimeout, leaseTimeout, localReadTimeout)) {
                return mnodeValue;
            }
            log.fine(this + " db update failed due to timing conflict" + "(key=" + key + ", version=" + version + ")");
        }
        return null;
    }

    @Override
    public MnodeValue saveLocalUpdateTime(HashKey keyHash, MnodeValue mnodeValue, MnodeValue oldMnodeValue) {
        if (this._mnodeStore.updateUpdateTime(keyHash, mnodeValue.getVersion(), mnodeValue.getIdleTimeout(), mnodeValue.getLastUpdateTime())) {
            return mnodeValue;
        }
        log.fine(this + " db updateTime failed due to timing conflict" + "(key=" + keyHash + ", version=" + mnodeValue.getVersion() + ")");
        return oldMnodeValue;
    }

    @Override
    public boolean loadData(HashKey valueHash, WriteStream os) throws IOException {
        return this._dataStore.load(valueHash, os);
    }

    @Override
    public boolean saveData(HashKey valueHash, StreamSource source, int length) throws IOException {
        return this._dataStore.save(valueHash, source, length);
    }

    @Override
    public boolean isDataAvailable(HashKey valueKey) {
        if (valueKey == null || valueKey == HashManager.NULL) {
            return false;
        }
        return this._dataStore.isDataAvailable(valueKey);
    }

    @Override
    public long getStartupLastUpdateTime() {
        return this._mnodeStore.getStartupLastUpdateTime();
    }

    @Override
    public ArrayList<CacheData> getUpdates(long accessTime, int offset) {
        return this._mnodeStore.getUpdates(accessTime, offset);
    }

    @Override
    public ArrayList<CacheData> getGlobalUpdates(long accessTime, int offset) {
        return this._mnodeStore.getGlobalUpdates(accessTime, offset);
    }

    public void start() {
        try {
            Path dataDirectory = RootDirectoryService.getCurrentDataDirectory();
            String serverId = ResinSystem.getCurrentId();
            if (serverId.isEmpty()) {
                serverId = "default";
            }
            this._mnodeStore = new MnodeStore(dataDirectory, serverId);
            this._dataStore = new DataStore(serverId, this._mnodeStore);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void close() {
        this._mnodeStore.close();
    }
}

