/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.cloud.topology.TriadOwner;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.HashKey;
import com.caucho.util.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DistCacheEntry
implements ExtCacheEntry {
    private final HashKey _keyHash;
    private final TriadOwner _owner;
    private Object _key;
    private final AtomicBoolean _isReadUpdate = new AtomicBoolean();
    private final AtomicReference<MnodeValue> _mnodeValue = new AtomicReference();

    public DistCacheEntry(Object key, HashKey keyHash, TriadOwner owner) {
        this._key = key;
        this._keyHash = keyHash;
        this._owner = owner;
    }

    public DistCacheEntry(Object key, HashKey keyHash, TriadOwner owner, CacheConfig config) {
        this._key = key;
        this._keyHash = keyHash;
        this._owner = owner;
    }

    public final Object getKey() {
        return this._key;
    }

    public final HashKey getKeyHash() {
        return this._keyHash;
    }

    public Object getValue() {
        return this.getMnodeValue().getValue();
    }

    public boolean isValueNull() {
        return this.getMnodeValue().isValueNull();
    }

    public final HashKey getCacheHash() {
        MnodeValue value = this.getMnodeValue();
        if (value != null) {
            return value.getCacheHashKey();
        }
        return null;
    }

    public final TriadOwner getOwner() {
        return this._owner;
    }

    public final MnodeValue getMnodeValue() {
        return this._mnodeValue.get();
    }

    public Object peek() {
        return this.getMnodeValue().getValue();
    }

    public abstract Object get(CacheConfig var1);

    public Object getLazy(CacheConfig config) {
        return this.get(config);
    }

    public abstract boolean getStream(OutputStream var1, CacheConfig var2) throws IOException;

    public MnodeValue getMnodeValue(CacheConfig config) {
        return this.getMnodeValue();
    }

    public abstract Object put(Object var1, CacheConfig var2);

    public abstract ExtCacheEntry put(InputStream var1, CacheConfig var2, long var3) throws IOException;

    public abstract boolean remove(CacheConfig var1);

    public final boolean startReadUpdate() {
        return this._isReadUpdate.compareAndSet(false, true);
    }

    public final void finishReadUpdate() {
        this._isReadUpdate.set(false);
    }

    public final boolean compareAndSet(MnodeValue oldMnodeValue, MnodeValue mnodeValue) {
        return this._mnodeValue.compareAndSet(oldMnodeValue, mnodeValue);
    }

    public HashKey getValueHashKey() {
        return this.getMnodeValue().getValueHashKey();
    }

    public byte[] getValueHashArray() {
        return this.getMnodeValue().getValueHash();
    }

    public long getIdleTimeout() {
        return this.getMnodeValue().getIdleTimeout();
    }

    public long getLeaseTimeout() {
        return this.getMnodeValue().getLeaseTimeout();
    }

    public int getLeaseOwner() {
        return this.getMnodeValue().getLeaseOwner();
    }

    public void clearLease() {
        MnodeValue mnodeValue = this.getMnodeValue();
        if (mnodeValue != null) {
            mnodeValue.clearLease();
        }
    }

    public long getCost() {
        return 0L;
    }

    public long getCreationTime() {
        return this.getMnodeValue().getCreationTime();
    }

    public long getExpirationTime() {
        return this.getMnodeValue().getExpirationTime();
    }

    public int getHits() {
        return this.getMnodeValue().getHits();
    }

    public long getLastAccessTime() {
        return this.getMnodeValue().getLastAccessTime();
    }

    public long getLastUpdateTime() {
        return this.getMnodeValue().getLastUpdateTime();
    }

    public long getVersion() {
        return this.getMnodeValue().getVersion();
    }

    public boolean isValid() {
        return this.getMnodeValue().isValid();
    }

    public Object setValue(Object value) {
        return this.getMnodeValue().setValue(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[key=" + this._key + ",keyHash=" + Hex.toHex(this._keyHash.getHash(), 0, 4) + ",owner=" + (Object)((Object)this._owner) + "]";
    }
}

