/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.CacheSerializer;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.util.HashKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;

public abstract class DistributedCacheManager {
    public void start() {
    }

    public abstract DistCacheEntry getCacheEntry(Object var1, CacheConfig var2);

    public void put(HashKey hashKey, Object value, CacheConfig config) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ExtCacheEntry put(HashKey hashKey, InputStream is, CacheConfig config, long idleTimeout) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract boolean remove(HashKey var1);

    public void close() {
    }

    protected HashKey createHashKey(Object key, CacheConfig config) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            NullDigestOutputStream dOut = new NullDigestOutputStream(digest);
            Object[] fullKey = new Object[]{config.getGuid(), key};
            config.getKeySerializer().serialize(fullKey, dOut);
            HashKey hashKey = new HashKey(dOut.digest());
            return hashKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HashKey createSelfHashKey(Object key, CacheSerializer keySerializer) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            NullDigestOutputStream dOut = new NullDigestOutputStream(digest);
            keySerializer.serialize(key, dOut);
            HashKey hashKey = new HashKey(dOut.digest());
            return hashKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class NullDigestOutputStream
    extends OutputStream {
        private MessageDigest _digest;

        NullDigestOutputStream(MessageDigest digest) {
            this._digest = digest;
        }

        public void write(int value) {
            this._digest.update((byte)value);
        }

        public void write(byte[] buffer, int offset, int length) {
            this._digest.update(buffer, offset, length);
        }

        public byte[] digest() {
            return this._digest.digest();
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

