/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.ExtCacheEntry;
import com.caucho.util.Alarm;
import com.caucho.util.HashKey;
import java.lang.ref.SoftReference;

public final class MnodeValue
implements ExtCacheEntry {
    public static final MnodeValue NULL = new MnodeValue(null, null, null, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, true);
    private final HashKey _valueHash;
    private final HashKey _cacheHash;
    private final int _flags;
    private final long _version;
    private final long _expireTimeout;
    private final long _idleTimeout;
    private final long _leaseTimeout;
    private final long _localReadTimeout;
    private final long _lastUpdateTime;
    private final boolean _isServerVersionValid;
    private final boolean _isImplicitNull;
    private volatile long _lastAccessTime;
    private int _leaseOwner = -1;
    private long _leaseExpireTime;
    private long _lastRemoteAccessTime;
    private int _hits = 0;
    private SoftReference<Object> _valueRef;

    public MnodeValue(HashKey valueHash, Object value, HashKey cacheHash, int flags, long version, long expireTimeout, long idleTimeout, long leaseTimeout, long localReadTimeout, long lastAccessTime, long lastUpdateTime, boolean isServerVersionValid, boolean isImplicitNull) {
        this._valueHash = valueHash;
        this._cacheHash = cacheHash;
        this._flags = flags;
        this._version = version;
        this._expireTimeout = expireTimeout;
        this._idleTimeout = idleTimeout;
        this._leaseTimeout = leaseTimeout;
        this._localReadTimeout = localReadTimeout;
        this._lastRemoteAccessTime = lastAccessTime;
        this._lastUpdateTime = lastUpdateTime;
        this._lastAccessTime = Alarm.getExactTime();
        this._isImplicitNull = isImplicitNull;
        this._isServerVersionValid = isServerVersionValid;
        if (value != null) {
            this._valueRef = new SoftReference<Object>(value);
        }
    }

    public MnodeValue(MnodeValue oldMnodeValue, long idleTimeout, long lastUpdateTime) {
        this._valueHash = oldMnodeValue.getValueHashKey();
        this._cacheHash = oldMnodeValue.getCacheHashKey();
        this._flags = oldMnodeValue.getFlags();
        this._version = oldMnodeValue.getVersion();
        this._expireTimeout = oldMnodeValue.getExpireTimeout();
        this._idleTimeout = idleTimeout;
        this._leaseTimeout = oldMnodeValue.getLeaseTimeout();
        this._localReadTimeout = oldMnodeValue.getLocalReadTimeout();
        this._lastRemoteAccessTime = lastUpdateTime;
        this._lastUpdateTime = lastUpdateTime;
        this._lastAccessTime = Alarm.getExactTime();
        this._leaseExpireTime = oldMnodeValue._leaseExpireTime;
        this._leaseOwner = oldMnodeValue._leaseOwner;
        this._isImplicitNull = oldMnodeValue.isImplicitNull();
        this._isServerVersionValid = oldMnodeValue.isServerVersionValid();
        Object value = oldMnodeValue.getValue();
        if (value != null) {
            this._valueRef = new SoftReference<Object>(value);
        }
    }

    public long getLastAccessTime() {
        return this._lastAccessTime;
    }

    public void setLastAccessTime(long accessTime) {
        this._lastAccessTime = accessTime;
    }

    public long getLastRemoteAccessTime() {
        return this._lastRemoteAccessTime;
    }

    public void setLastRemoteAccessTime(long accessTime) {
        this._lastRemoteAccessTime = accessTime;
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public final long getExpirationTime() {
        return this._lastUpdateTime + this._expireTimeout;
    }

    public final boolean isLocalReadValid(int serverIndex, long now) {
        if (!this._isServerVersionValid) {
            return false;
        }
        if (now <= this._lastAccessTime + this._localReadTimeout) {
            return true;
        }
        return this._leaseOwner == serverIndex && now <= this._leaseExpireTime;
    }

    public final boolean isLeaseExpired(long now) {
        return this._leaseExpireTime <= now;
    }

    public final boolean isEntryExpired(long now) {
        return this.isIdleExpired(now) || this.isValueExpired(now);
    }

    public final boolean isValueExpired(long now) {
        return this._lastUpdateTime + this._expireTimeout < now;
    }

    public final boolean isIdleExpired(long now) {
        return this._lastAccessTime + this._idleTimeout < now;
    }

    public final int getLeaseOwner() {
        return this._leaseOwner;
    }

    public final void setLeaseOwner(int leaseOwner, long now) {
        if (leaseOwner > 2) {
            this._leaseOwner = leaseOwner;
            this._leaseExpireTime = now + this._leaseTimeout;
        } else {
            this._leaseOwner = -1;
            this._leaseExpireTime = 0L;
        }
    }

    public final void clearLease() {
        this._leaseOwner = -1;
        this._leaseExpireTime = 0L;
    }

    public int getFlags() {
        return this._flags;
    }

    public long getExpireTimeout() {
        return this._expireTimeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public long getIdleWindow() {
        long window = this._idleTimeout / 4L;
        long windowMax = 900000L;
        if (window < windowMax) {
            return window;
        }
        return windowMax;
    }

    public long getLocalReadTimeout() {
        return this._localReadTimeout;
    }

    public long getLeaseTimeout() {
        return this._leaseTimeout;
    }

    public long getVersion() {
        return this._version;
    }

    public final void setObjectValue(Object value) {
        if (value != null && (this._valueRef == null || this._valueRef.get() == null)) {
            this._valueRef = new SoftReference<Object>(value);
        }
    }

    public boolean isValueNull() {
        return this._valueHash == null;
    }

    public final Object getValue() {
        SoftReference<Object> valueRef = this._valueRef;
        if (valueRef != null) {
            ++this._hits;
            return valueRef.get();
        }
        return null;
    }

    public byte[] getValueHash() {
        if (this._valueHash != null) {
            return this._valueHash.getHash();
        }
        return null;
    }

    public HashKey getValueHashKey() {
        return this._valueHash;
    }

    public byte[] getCacheHash() {
        if (this._cacheHash != null) {
            return this._cacheHash.getHash();
        }
        return null;
    }

    public HashKey getCacheHashKey() {
        return this._cacheHash;
    }

    public boolean isServerVersionValid() {
        return this._isServerVersionValid;
    }

    public boolean isImplicitNull() {
        return this._isImplicitNull;
    }

    public int compareTo(MnodeValue mnode) {
        if (this.getVersion() < mnode.getVersion()) {
            return -1;
        }
        if (mnode.getVersion() < this.getVersion()) {
            return 1;
        }
        if (this.getValueHashKey() == null) {
            return -1;
        }
        return this.getValueHashKey().compareTo(mnode.getValueHashKey());
    }

    public Object getKey() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object setValue(Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isValid() {
        return !this.isEntryExpired(Alarm.getCurrentTime());
    }

    public long getCost() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getHits() {
        return this._hits;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[value=" + this._valueHash + ",flags=0x" + Integer.toHexString(this._flags) + ",version=" + this._version + ",lease=" + this._leaseOwner + "]";
    }
}

