/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployMode;
import com.caucho.server.host.DomainName;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostConfig
extends DeployConfig {
    static final L10N L = new L10N(HostConfig.class);
    static final Logger log = Logger.getLogger(HostConfig.class.getName());
    private ArrayList<String> _hostAliases = new ArrayList();
    private ArrayList<Pattern> _hostAliasRegexps = new ArrayList();
    private String _hostName;
    private Pattern _regexp;

    public HostConfig() {
        super.setId(null);
    }

    public void setHostName(RawString name) throws ConfigException {
        String domainName;
        this._hostName = this.cleanHostName(name);
        if (this._hostName.indexOf("${") < 0) {
            for (int i = 0; i < this._hostName.length(); ++i) {
                char ch = this._hostName.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("Host name `{0}' must not contain multiple names.  Use <host-alias> to specify aliases for a host.", this._hostName));
            }
        }
        if (this._hostName.startsWith("xn--") && !this._hostAliases.contains(domainName = DomainName.fromAscii(this._hostName))) {
            this._hostAliases.add(domainName);
        }
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setId(RawString id) throws ConfigException {
        String cleanName = this.cleanHostName(id);
        this.setId(cleanName);
        if (!this._hostAliases.contains(cleanName)) {
            this._hostAliases.add(cleanName);
        }
    }

    @Override
    public void setId(String cleanName) {
        String name;
        super.setId(cleanName);
        if (this._hostName == null) {
            this._hostName = cleanName;
        }
        if (cleanName.startsWith("xn--") && !this._hostAliases.contains(name = DomainName.fromAscii(cleanName))) {
            this._hostAliases.add(name);
        }
    }

    private String cleanHostName(RawString name) throws ConfigException {
        String hostName = name.getValue();
        if (hostName.indexOf("${") < 0) {
            for (int i = 0; i < hostName.length(); ++i) {
                char ch = hostName.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("Host name `{0}' must not contain multiple names.  Use <host-alias> to specify aliases for a host.", hostName));
            }
        }
        return hostName;
    }

    public void addHostAlias(RawString rawName) throws ConfigException {
        String name = rawName.getValue().trim();
        if (name.indexOf("${") < 0) {
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != ',') continue;
                throw new ConfigException(L.l("<host-alias> `{0}' must not contain multiple names.  Use multiple <host-alias> tags to specify aliases for a host.", name));
            }
        }
        if (name.equals("*")) {
            name = "";
        }
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public void addHostAliasRegexp(String name) {
        Pattern pattern = Pattern.compile(name = name.trim(), 2);
        if (!this._hostAliasRegexps.contains(pattern)) {
            this._hostAliasRegexps.add(pattern);
        }
    }

    public ArrayList<Pattern> getHostAliasRegexps() {
        return this._hostAliasRegexps;
    }

    public void setRegexp(RawString regexp) {
        String value = regexp.getValue();
        if (!value.endsWith("$")) {
            value = value + "$";
        }
        this._regexp = Pattern.compile(value, 2);
    }

    public Pattern getRegexp() {
        return this._regexp;
    }

    public void setRootDir(RawString rootDir) {
        this.setRootDirectory(rootDir);
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        if (lazyInit) {
            this.setStartupMode(DeployMode.LAZY);
        } else {
            this.setStartupMode(DeployMode.AUTOMATIC);
        }
    }

    @PostConstruct
    public void init() {
        if (this._regexp != null && this.getHostName() == null) {
            log.config(L.l("<host regexp=\"{0}\"> should include a <host-name> tag.", this._regexp.pattern()));
        }
    }
}

