/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.make.AlwaysModified;
import com.caucho.server.cluster.Server;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationBuilder;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.DomainName;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostExpandDeployGenerator;
import com.caucho.server.host.HostRegexpDeployGenerator;
import com.caucho.server.host.HostSingleDeployGenerator;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.AccessLogFilterChain;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppFilterChain;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostContainer
implements InvocationBuilder {
    private static final Logger log = Logger.getLogger(HostContainer.class.getName());
    private final Server _server;
    private EnvironmentClassLoader _classLoader;
    private Host _errorHost;
    private String _url = "";
    private Path _rootDir;
    private RewriteDispatch _rewriteDispatch;
    private ArrayList<HostConfig> _hostDefaultList = new ArrayList();
    private DeployContainer<HostController> _hostDeploy = new DeployContainer<HostController>(HostController.class);
    private ConcurrentHashMap<String, HostController> _hostMap = new ConcurrentHashMap();
    private ArrayList<HostConfig> _hostRegexpList = new ArrayList();
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();
    private final Lifecycle _lifecycle = new Lifecycle();

    public HostContainer(Server server) {
        this._server = server;
        this._classLoader = server.getClassLoader();
        this._rootDir = Vfs.lookup();
    }

    public String getStageTag() {
        return "production";
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURL() {
        return this._url;
    }

    public Server getServer() {
        return this._server;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
    }

    public void setRootDir(Path path) {
        this.setRootDirectory(path);
    }

    public void addHostDefault(HostConfig init) {
        this._hostDefaultList.add(init);
    }

    public ArrayList<HostConfig> getHostDefaultList() {
        return this._hostDefaultList;
    }

    public HostExpandDeployGenerator createHostDeploy() {
        String id = this.getStageTag() + "/host";
        return new HostExpandDeployGenerator(id, this._hostDeploy, this);
    }

    public void addHostDeploy(HostExpandDeployGenerator hostDeploy) {
        this._hostDeploy.add(hostDeploy);
    }

    public void addHost(HostConfig hostConfig) {
        if (hostConfig.getRegexp() != null) {
            this._hostDeploy.add(new HostRegexpDeployGenerator(this._hostDeploy, this, hostConfig));
            return;
        }
        HostSingleDeployGenerator deploy = new HostSingleDeployGenerator(this._hostDeploy, this, hostConfig);
        this._hostDeploy.add(deploy);
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public void addEarDefault(EarConfig init) {
        this._earDefaultList.add(init);
    }

    public ArrayList<EarConfig> getEarDefaultList() {
        return this._earDefaultList;
    }

    public RewriteDispatch createRewriteDispatch() {
        if (this._rewriteDispatch == null) {
            this._rewriteDispatch = new RewriteDispatch(this.getErrorWebApp());
        }
        return this._rewriteDispatch;
    }

    public void clearCache() {
        this._hostMap.clear();
        this.getServer().clearCache();
    }

    @Override
    public Invocation buildInvocation(Invocation invocation) {
        FilterChain chain;
        String queryString;
        String url;
        FilterChain rewriteChain;
        boolean isAlwaysModified;
        String rawHost = invocation.getHost();
        int rawPort = invocation.getPort();
        String hostName = rawHost == null ? "" : DomainName.fromAscii(rawHost);
        invocation.setHostName(hostName);
        Host host = this.getHost(hostName, rawPort);
        if (host != null) {
            invocation = host.buildInvocation(invocation);
            isAlwaysModified = false;
        } else {
            ErrorFilterChain chain2 = new ErrorFilterChain(404);
            invocation.setFilterChain(chain2);
            invocation.setWebApp(this.getErrorWebApp());
            isAlwaysModified = true;
        }
        if (this._rewriteDispatch != null && (rewriteChain = this._rewriteDispatch.map(DispatcherType.REQUEST, url = invocation.isSecure() ? "https://" + hostName + invocation.getURI() : "http://" + hostName + invocation.getURI(), queryString = invocation.getQueryString(), chain = invocation.getFilterChain())) != chain) {
            Server server = this.getServer();
            WebApp webApp = server.getDefaultWebApp();
            invocation.setWebApp(webApp);
            if (webApp != null) {
                rewriteChain = new WebAppFilterChain(rewriteChain, webApp);
                if (webApp.getAccessLog() != null) {
                    rewriteChain = new AccessLogFilterChain(rewriteChain, webApp);
                }
            }
            invocation.setFilterChain(rewriteChain);
            isAlwaysModified = false;
        }
        if (isAlwaysModified) {
            invocation.setDependency(AlwaysModified.create());
        }
        return invocation;
    }

    public HostController[] getHostList() {
        return (HostController[])this._hostDeploy.getControllers();
    }

    public Host getHost(String hostName, int port) {
        try {
            HostController controller = this.findHost(hostName, port);
            if (controller != null) {
                return (Host)controller.request();
            }
            return null;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public HostController getHostController(String hostName, int port) {
        try {
            return this.findHost(hostName, port);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    private HostController findHost(String rawHost, int rawPort) throws Exception {
        if (rawHost == null) {
            rawHost = "";
        }
        int p = rawHost.lastIndexOf(58);
        int q = rawHost.lastIndexOf(93);
        String shortHost = rawHost;
        if (p > 0 && q < p) {
            shortHost = rawHost.substring(0, p);
        }
        String fullHost = shortHost + ':' + rawPort;
        HostController hostController = null;
        hostController = this._hostMap.get(fullHost);
        if (hostController != null && !hostController.getState().isDestroyed()) {
            return hostController;
        }
        if (hostController == null || hostController.getState().isDestroyed()) {
            hostController = this._hostMap.get(shortHost);
        }
        if (hostController == null || hostController.getState().isDestroyed()) {
            hostController = this.findHostController(fullHost);
        }
        if (hostController == null || hostController.getState().isDestroyed()) {
            hostController = this.findHostController(shortHost);
        }
        if (hostController == null || hostController.getState().isDestroyed()) {
            hostController = this.findHostController("");
        }
        if (hostController != null) {
            if (!hostController.getState().isDestroyed()) {
                this._hostMap.put(fullHost, hostController);
            } else {
                hostController = null;
                this._hostMap.remove(fullHost);
            }
        }
        return hostController;
    }

    private HostController findHostController(String hostName) throws Exception {
        HostController controller = this._hostDeploy.findController(hostName);
        return controller;
    }

    public WebApp getErrorWebApp() {
        Host errorHost = this.getErrorHost();
        if (errorHost != null) {
            return errorHost.getWebAppContainer().getErrorWebApp();
        }
        return null;
    }

    private Host createErrorHost() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            Host host;
            thread.setContextClassLoader(this._classLoader);
            Path rootDirectory = Vfs.lookup("memory:/error");
            HostController controller = new HostController("error/host/error", rootDirectory, "error", null, this, null);
            controller.init();
            controller.startOnInit();
            controller.start();
            Host host2 = host = (Host)controller.request();
            return host2;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    private Host getErrorHost() {
        if (!this._lifecycle.isActive()) {
            return null;
        }
        Host defaultHost = this.getHost("", 0);
        if (defaultHost != null) {
            return defaultHost;
        }
        if (this._errorHost == null) {
            this._errorHost = this.createErrorHost();
        }
        return this._errorHost;
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._lifecycle.toActive();
        this._hostDeploy.start();
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        this._hostDeploy.stop();
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._hostDeploy.destroy();
        this._classLoader.destroy();
    }
}

