/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.config.types.PathBuilder;
import com.caucho.el.EL;
import com.caucho.env.deploy.DeployControllerAdmin;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.DeployControllerType;
import com.caucho.env.deploy.EnvironmentDeployController;
import com.caucho.management.server.HostMXBean;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostAdmin;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostRegexpVar;
import com.caucho.server.host.HostVar;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostController
extends EnvironmentDeployController<Host, HostConfig> {
    private static final Logger log = Logger.getLogger(HostController.class.getName());
    private HostContainer _container;
    private final String _idKey;
    private final String _hostName;
    private String _regexpName;
    private Pattern _regexp;
    private String _rootDirectoryPattern;
    private ArrayList<String> _entryHostAliases = new ArrayList();
    private ArrayList<Pattern> _entryHostAliasRegexps = new ArrayList();
    private ArrayList<String> _hostAliases = new ArrayList();
    private ArrayList<Pattern> _hostAliasRegexps = new ArrayList();
    private final HostVar _hostVar = new HostVar(this);
    private HostAdmin _admin;
    private ArrayList<Dependency> _dependList = new ArrayList();

    HostController(String id, Path rootDirectory, String hostName, HostConfig config, HostContainer container, Map<String, Object> varMap) {
        super(id, rootDirectory, config);
        this._hostName = hostName;
        if (varMap != null) {
            this.getVariableMap().putAll(varMap);
        }
        this.getVariableMap().put("host", this._hostVar);
        this.setContainer(container);
        int p = id.lastIndexOf(47);
        this._idKey = id.substring(p + 1);
        if (config != null) {
            this._regexp = config.getRegexp();
            this._entryHostAliases.addAll(config.getHostAliases());
            this._hostAliases.addAll(config.getHostAliases());
            this._entryHostAliasRegexps.addAll(config.getHostAliasRegexps());
            this._hostAliasRegexps.addAll(config.getHostAliasRegexps());
        }
        if (!this.isErrorHost()) {
            this._admin = new HostAdmin(this);
        }
    }

    public HostController(String id, Path rootDirectory, String hostName, HostContainer container) {
        this(id, rootDirectory, hostName, null, container, null);
    }

    private boolean isErrorHost() {
        return this.getId().startsWith("error/");
    }

    public void setContainer(HostContainer container) {
        this._container = container;
        if (this._container != null && !this.isErrorHost()) {
            for (HostConfig defaultConfig : this._container.getHostDefaultList()) {
                this.addConfigDefault(defaultConfig);
            }
        }
    }

    public String getName() {
        return this._idKey;
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setRegexpName(String name) {
        this._regexpName = name.toLowerCase();
    }

    public void addHostAlias(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.equals("*")) {
            name = "";
        }
        if (!this._entryHostAliases.contains(name = name.toLowerCase())) {
            this._entryHostAliases.add(name);
        }
        this.addExtHostAlias(name);
    }

    public void addExtHostAlias(String name) {
        if (!this._hostAliases.contains(name)) {
            this._hostAliases.add(name);
        }
    }

    public ArrayList<String> getHostAliases() {
        return this._hostAliases;
    }

    public void addExtHostAliasRegexp(Pattern name) {
        if (!this._hostAliasRegexps.contains(name)) {
            this._hostAliasRegexps.add(name);
        }
    }

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    @Override
    public DeployControllerType getControllerType() {
        if (this._regexp != null) {
            return DeployControllerType.DYNAMIC;
        }
        return super.getControllerType();
    }

    public void setRootDirectoryPattern(String rootDirectoryPattern) {
        this._rootDirectoryPattern = rootDirectoryPattern;
    }

    public void addDepend(Path depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(new Depend(depend));
        }
    }

    public HostMXBean getAdmin() {
        return this._admin;
    }

    @Override
    protected DeployControllerAdmin getDeployAdmin() {
        return this._admin;
    }

    @Override
    protected void initBegin() {
        try {
            ArrayList<String> aliases = null;
            if (this.getConfig() != null) {
                aliases = ((HostConfig)this.getConfig()).getHostAliases();
                this._entryHostAliasRegexps.addAll(((HostConfig)this.getConfig()).getHostAliasRegexps());
                this._hostAliasRegexps.addAll(((HostConfig)this.getConfig()).getHostAliasRegexps());
            }
            for (int i = 0; aliases != null && i < aliases.size(); ++i) {
                String alias = aliases.get(i);
                alias = EL.evalString(alias, EL.getEnvironment());
                this.addHostAlias(alias);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        super.initBegin();
    }

    @Override
    protected String getMBeanId() {
        String name = this.getName();
        if (name == null) {
            name = "";
        } else if (name.indexOf(58) >= 0) {
            name = name.replace(':', '-');
        }
        if (name.equals("")) {
            return "default";
        }
        return name;
    }

    @Override
    public boolean isNameMatch(String name) {
        Matcher matcher;
        Object alias;
        int i;
        if (this._hostName.equalsIgnoreCase(name)) {
            return true;
        }
        for (i = this._hostAliases.size() - 1; i >= 0; --i) {
            alias = this._hostAliases.get(i);
            if (!name.equalsIgnoreCase((String)alias)) continue;
            return true;
        }
        for (i = this._hostAliasRegexps.size() - 1; i >= 0; --i) {
            alias = this._hostAliasRegexps.get(i);
            if (!((Pattern)alias).matcher(name).find()) continue;
            return true;
        }
        if (this._regexp != null && (matcher = this._regexp.matcher(name)).matches()) {
            Path rootDirectory = this.calculateRoot(matcher);
            if (this.getRootDirectory().equals(rootDirectory)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path calculateRoot(Matcher matcher) {
        ClassLoader oldLoader;
        Thread thread;
        block6: {
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getParentClassLoader());
            if (this._rootDirectoryPattern != null) break block6;
            Path path = Vfs.lookup();
            Object var10_7 = null;
            thread.setContextClassLoader(oldLoader);
            return path;
        }
        try {
            Path path;
            int length = matcher.end() - matcher.start();
            ArrayList<String> vars = new ArrayList<String>();
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (int j = 0; j <= matcher.groupCount(); ++j) {
                vars.add(matcher.group(j));
                varMap.put("host" + j, matcher.group(j));
            }
            varMap.put("regexp", vars);
            varMap.put("host", new HostRegexpVar(matcher.group(0), vars));
            Path path2 = path = PathBuilder.lookupPath(this._rootDirectoryPattern, varMap);
            Object var10_8 = null;
            thread.setContextClassLoader(oldLoader);
            return path2;
        }
        catch (Exception e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                Path path = Vfs.lookup(this._rootDirectoryPattern);
                Object var10_9 = null;
                thread.setContextClassLoader(oldLoader);
                return path;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    @Override
    public void merge(DeployControllerApi<Host> newControllerV) {
        super.merge(newControllerV);
        HostController newController = (HostController)newControllerV;
        this._entryHostAliases.addAll(newController._entryHostAliases);
        if (!newController.getHostName().equals("")) {
            this._entryHostAliases.add(newController.getHostName());
        }
        this._entryHostAliasRegexps.addAll(newController._entryHostAliasRegexps);
        this._hostAliases.addAll(newController._hostAliases);
        this._hostAliasRegexps.addAll(newController._hostAliasRegexps);
    }

    @Override
    protected Host instantiateDeployInstance() {
        return new Host(this._container, this, this._hostName);
    }

    @Override
    protected void configureInstance(Host host) throws Exception {
        this._hostAliases.clear();
        this._hostAliases.addAll(this._entryHostAliases);
        Config.setProperty("host", this._hostVar);
        for (Map.Entry<String, Object> entry : this.getVariableMap().entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            Config.setProperty(entry.getKey(), value);
        }
        if (this._container != null) {
            for (EarConfig earConfig : this._container.getEarDefaultList()) {
                host.getWebAppContainer().addEarDefault(earConfig);
            }
            for (WebAppConfig webAppConfig : this._container.getWebAppDefaultList()) {
                host.getWebAppContainer().addWebAppDefault(webAppConfig);
            }
        }
        super.configureInstance(host);
    }

    @Override
    protected void extendJMXContext(Map<String, String> context) {
        context.put("Host", this.getMBeanId());
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HostController)) {
            return false;
        }
        HostController entry = (HostController)o;
        return this._hostName.equals(entry._hostName);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }
}

