/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostRegexpVar;
import com.caucho.server.host.HostSingleDeployGenerator;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostRegexpDeployGenerator
extends DeployGenerator<HostController> {
    private static final Logger log = Logger.getLogger(HostSingleDeployGenerator.class.getName());
    private HostContainer _container;
    private HostConfig _config;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private ArrayList<HostController> _entries = new ArrayList();

    public HostRegexpDeployGenerator(DeployContainer<HostController> container) {
        super(container);
    }

    public HostRegexpDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer, HostConfig config) {
        super(container);
        this.setContainer(hostContainer);
        this._config = config;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setContainer(HostContainer container) {
        this._container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateController(String name, ArrayList<HostController> list) {
        Pattern regexp = this._config.getRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.find() || matcher.start() != 0) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            int length = matcher.end() - matcher.start();
            String hostName = matcher.group();
            ArrayList<String> vars = new ArrayList<String>();
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (int j = 0; j <= matcher.groupCount(); ++j) {
                vars.add(matcher.group(j));
                varMap.put("host" + j, matcher.group(j));
            }
            varMap.put("regexp", vars);
            varMap.put("host", new HostRegexpVar(hostName, vars));
            if (this._config.getHostName() != null) {
                try {
                    hostName = Config.evalString(this._config.getHostName(), varMap);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            String id = this._container.getServer().getStage() + "/host/" + name;
            Path rootDirectory = this._config.calculateRootDirectory(varMap);
            HostController controller = new HostController(id, rootDirectory, name, this._config, this._container, varMap);
            controller.setRegexpName(name);
            controller.setRegexp(regexp);
            controller.setRootDirectoryPattern(this._config.getRootDirectory());
            for (int i = 0; i < this._hostDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._hostDefaults.get(i));
            }
            controller.init();
            Path rootDir = controller.getRootDirectory();
            if (rootDir == null || !rootDir.isDirectory()) {
                controller.destroy();
                Object var20_18 = null;
                thread.setContextClassLoader(oldLoader);
                return;
            }
            ArrayList<HostController> arrayList = this._entries;
            synchronized (arrayList) {
                for (int i = 0; i < this._entries.size(); ++i) {
                    HostController oldController = this._entries.get(i);
                    if (!rootDir.equals(oldController.getRootDirectory())) continue;
                    list.add(oldController);
                }
                this._entries.add(controller);
            }
            list.add(controller);
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
        Object var20_19 = null;
        thread.setContextClassLoader(oldLoader);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._config + "]";
    }
}

