/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.server.host.Host;
import com.caucho.server.host.HostController;
import com.caucho.vfs.Path;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostVar {
    HostController _hostController;

    HostVar(HostController controller) {
        this._hostController = controller;
    }

    public String getName() {
        return this._hostController.getName();
    }

    public String getHostName() {
        return this._hostController.getHostName();
    }

    public String getUrl() {
        Host host = (Host)this._hostController.getDeployInstance();
        if (host != null) {
            return host.getURL();
        }
        String hostName = this._hostController.getHostName();
        if (hostName.equals("")) {
            return "";
        }
        if (hostName.startsWith("http:") || hostName.startsWith("https:")) {
            return hostName;
        }
        return "http://" + hostName;
    }

    public ArrayList<String> getRegexp() {
        return (ArrayList)this._hostController.getVariableMap().get("regexp");
    }

    public Path getRoot() {
        Host host = (Host)this._hostController.getDeployInstance();
        if (host != null) {
            return host.getWebAppContainer().getRootDirectory();
        }
        return this._hostController.getRootDirectory();
    }

    public Path getRootDir() {
        return this.getRoot();
    }

    public Path getRootDirectory() {
        return this.getRoot();
    }

    public Path getDocumentDirectory() {
        Host host = (Host)this._hostController.getDeployInstance();
        if (host != null) {
            return host.getWebAppContainer().getDocumentDirectory();
        }
        return null;
    }

    public Path getDocDir() {
        return this.getDocumentDirectory();
    }

    public Path getWarDirectory() {
        Host host = (Host)this._hostController.getDeployInstance();
        if (host != null) {
            return host.getWebAppContainer().getWarDir();
        }
        return null;
    }

    public Path getWarDir() {
        return this.getWarDirectory();
    }

    public Path getWarExpandDirectory() {
        Host host = (Host)this._hostController.getDeployInstance();
        if (host != null) {
            return host.getWebAppContainer().getWarExpandDir();
        }
        return null;
    }

    public Path getWarExpandDir() {
        return this.getWarExpandDirectory();
    }

    public String toString() {
        return "Host[" + this._hostController.getId() + "]";
    }
}

