/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.SocketLink;
import com.caucho.security.Authenticator;
import com.caucho.security.Login;
import com.caucho.security.RoleMapManager;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractCauchoRequest
implements CauchoRequest {
    private static final L10N L = new L10N(AbstractCauchoRequest.class);
    private static final Logger log = Logger.getLogger(AbstractCauchoRequest.class.getName());
    private int _sessionGroup = -1;
    private boolean _sessionIsLoaded;
    private SessionImpl _session;

    public abstract CauchoResponse getResponse();

    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getWebApp().getRequestDispatcher(path);
        }
        CharBuffer cb = new CharBuffer();
        WebApp webApp = this.getWebApp();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (webApp != null) {
            return webApp.getRequestDispatcher(cb.toString());
        }
        return null;
    }

    public String getRealPath(String uri) {
        WebApp webApp = this.getWebApp();
        return webApp.getRealPath(uri);
    }

    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        int port = this.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public boolean isTop() {
        return false;
    }

    public abstract boolean isSessionIdFromCookie();

    public abstract String getSessionId();

    public abstract void setSessionId(String var1);

    public HttpSession getMemorySession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null) {
            if (this._session.isValid()) {
                return this._session;
            }
        } else if (!create && this._sessionIsLoaded) {
            return null;
        }
        this._sessionIsLoaded = true;
        this._session = this.createSession(create);
        return this._session;
    }

    public HttpSession getLoadedSession() {
        if (this._session != null && this._session.isValid()) {
            return this._session;
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        String id = this.getRequestedSessionId();
        if (id == null) {
            return false;
        }
        SessionImpl session = this._session;
        if (session == null) {
            session = (SessionImpl)this.getSession(false);
        }
        return session != null && session.isValid() && session.getId().equals(id);
    }

    private SessionImpl createSession(boolean create) {
        long now;
        SessionManager manager = this.getSessionManager();
        if (manager == null) {
            return null;
        }
        String id = this.getSessionId();
        SessionImpl session = manager.createSession(create, this, id, now = Alarm.getCurrentTime(), this.isSessionIdFromCookie());
        if (session != null && (id == null || !session.getId().equals(id)) && manager.enableSessionCookies()) {
            this.setSessionId(session.getId());
        }
        return session;
    }

    protected final SessionManager getSessionManager() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getSessionManager();
        }
        return null;
    }

    protected final String getSessionCookie(SessionManager manager) {
        if (this.isSecure()) {
            return manager.getSSLCookieName();
        }
        return manager.getCookieName();
    }

    public int getSessionGroup() {
        return this._sessionGroup;
    }

    void saveSession() {
        SessionImpl session = this._session;
        if (session != null) {
            session.save();
        }
    }

    protected String getRunAs() {
        return null;
    }

    protected ServletInvocation getInvocation() {
        return null;
    }

    protected HttpServletRequest getRequest() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String username, String password) throws ServletException {
        WebApp webApp = this.getWebApp();
        Authenticator auth = webApp.getConfiguredAuthenticator();
        if (auth == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", this.getWebApp()));
        }
        Login login = webApp.getLogin();
        if (login == null) {
            throw new ServletException(L.l("No login mechanism is configured for '{0}'", this.getWebApp()));
        }
        if (!login.isPasswordBased()) {
            throw new ServletException(L.l("Authentication mechanism '{0}' does not support password authentication", login));
        }
        this.removeAttribute("caucho.user");
        this.removeAttribute("caucho.password");
        Principal principal = login.getUserPrincipal(this);
        if (principal != null) {
            throw new ServletException(L.l("UserPrincipal object has already been established"));
        }
        this.setAttribute("caucho.user", username);
        this.setAttribute("caucho.password", password);
        try {
            login.login(this, this.getResponse(), false);
        }
        finally {
            this.removeAttribute("caucho.user");
            this.removeAttribute("caucho.password");
        }
        principal = login.getUserPrincipal(this);
        if (principal == null) {
            throw new ServletException("can't authenticate a user");
        }
    }

    public boolean login(boolean isFail) {
        try {
            WebApp webApp = this.getWebApp();
            if (webApp == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.finer("authentication failed, no web-app found");
                }
                this.getResponse().sendError(403);
                return false;
            }
            if (webApp.isSecure() && !this.isSecure()) {
                if (log.isLoggable(Level.FINE)) {
                    log.finer("authentication failed, requires secure");
                }
                this.getResponse().sendError(403);
                return false;
            }
            Login login = webApp.getLogin();
            if (login != null) {
                Principal user = login.login(this, this.getResponse(), isFail);
                return user != null;
            }
            if (isFail) {
                if (log.isLoggable(Level.FINE)) {
                    log.finer("authentication failed, no login module found for " + webApp);
                }
                this.getResponse().sendError(403);
                return false;
            }
            return false;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public abstract boolean isLoginRequested();

    public abstract void requestLogin();

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", this.getWebApp()));
        }
        Authenticator auth = webApp.getConfiguredAuthenticator();
        if (auth == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", this.getWebApp()));
        }
        Login login = webApp.getLogin();
        if (login == null) {
            throw new ServletException(L.l("No authentication mechanism is configured for '{0}'", this.getWebApp()));
        }
        Principal principal = login.login(this, response, true);
        return principal != null;
    }

    public Principal getUserPrincipal() {
        this.requestLogin();
        Principal user = (Principal)this.getAttribute("caucho.login");
        if (user != null) {
            return user;
        }
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return null;
        }
        Login login = webApp.getLogin();
        if (login != null && (user = login.getUserPrincipal(this)) != null) {
            this.getResponse().setPrivateCache(true);
        }
        return user;
    }

    public boolean isUserInRole(String role) {
        boolean inRole;
        Boolean result;
        RoleMapManager roleManager;
        String runAs;
        String linkRole;
        ServletInvocation invocation = this.getInvocation();
        if (invocation == null) {
            if (this.getRequest() != null) {
                return this.getRequest().isUserInRole(role);
            }
            return false;
        }
        HashMap<String, String> roleMap = invocation.getSecurityRoleMap();
        if (roleMap != null && (linkRole = roleMap.get(role)) != null) {
            role = linkRole;
        }
        if ((runAs = this.getRunAs()) != null) {
            return runAs.equals(role);
        }
        WebApp webApp = this.getWebApp();
        Principal user = this.getUserPrincipal();
        if (user == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " no user for isUserInRole");
            }
            return false;
        }
        RoleMapManager roleMapManager = roleManager = webApp != null ? webApp.getRoleMapManager() : null;
        if (roleManager != null && (result = roleManager.isUserInRole(role, user)) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " userInRole(" + role + ")->" + result);
            }
            return result;
        }
        Login login = webApp == null ? null : webApp.getLogin();
        boolean bl = inRole = login != null && login.isUserInRole(user, role);
        if (log.isLoggable(Level.FINE)) {
            if (login == null) {
                log.fine(this + " no Login for isUserInRole");
            } else if (user == null) {
                log.fine(this + " no user for isUserInRole");
            } else if (inRole) {
                log.fine(this + " " + user + " is in role: " + role);
            } else {
                log.fine(this + " failed " + user + " in role: " + role);
            }
        }
        return inRole;
    }

    public SocketLink getSocketLink() {
        AbstractHttpRequest request = this.getAbstractHttpRequest();
        if (request != null) {
            return request.getConnection();
        }
        return null;
    }

    protected void finishRequest() throws IOException {
        SessionImpl session = this._session;
        if (session == null && this.getSessionId() != null) {
            session = (SessionImpl)this.getSession(false);
        }
        if (session != null) {
            session.finishRequest();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

