/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.ContentType;
import com.caucho.server.http.HttpBufferStore;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.server.session.CookieImpl;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CaseInsensitiveIntMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpResponse {
    protected static final Logger log = Logger.getLogger(AbstractHttpResponse.class.getName());
    static final L10N L = new L10N(AbstractHttpResponse.class);
    protected static final CaseInsensitiveIntMap _headerCodes;
    protected static final int HEADER_CACHE_CONTROL = 1;
    protected static final int HEADER_CONTENT_TYPE = 2;
    protected static final int HEADER_CONTENT_LENGTH = 3;
    protected static final int HEADER_DATE = 4;
    protected static final int HEADER_SERVER = 5;
    protected static final int HEADER_CONNECTION = 6;
    private static final ConcurrentHashMap<String, ContentType> _contentTypeMap;
    protected final AbstractHttpRequest _request;
    protected final ArrayList<String> _headerKeys = new ArrayList();
    protected final ArrayList<String> _headerValues = new ArrayList();
    protected final ArrayList<String> _footerKeys = new ArrayList();
    protected final ArrayList<String> _footerValues = new ArrayList();
    private final AbstractResponseStream _responseStream;
    private final ServletOutputStreamImpl _responseOutputStream = new ServletOutputStreamImpl();
    private final ResponseWriter _responsePrintWriter = new ResponseWriter();
    protected final QDate _calendar = new QDate(false);
    protected final CharBuffer _cb = new CharBuffer();
    protected final char[] _headerBuffer = new char[256];
    private HttpBufferStore _bufferStore;
    private boolean _isHeaderWritten;
    private boolean _isClientDisconnect;
    protected long _contentLength;
    private boolean _isClosed;

    protected AbstractHttpResponse(AbstractHttpRequest request) {
        this._request = request;
        this._responseStream = this.createResponseStream();
    }

    TempBuffer getBuffer() {
        return this._bufferStore.getTempBuffer();
    }

    protected final QDate getCalendar() {
        return this._calendar;
    }

    public boolean isIgnoreClientDisconnect() {
        return this._request.isIgnoreClientDisconnect();
    }

    public boolean isClientDisconnect() {
        return this._isClientDisconnect;
    }

    public void clientDisconnect() {
        this._request.clientDisconnect();
        this._isClientDisconnect = true;
    }

    public ServletResponse getResponse() {
        return null;
    }

    public AbstractHttpRequest getRequest() {
        return this._request;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void startRequest(HttpBufferStore bufferStore) throws IOException {
        this._bufferStore = bufferStore;
        this._headerKeys.clear();
        this._headerValues.clear();
        this._footerKeys.clear();
        this._footerValues.clear();
        this._responseStream.start();
        this._isHeaderWritten = false;
        this._isClientDisconnect = false;
        this._contentLength = -1L;
        this._isClosed = false;
    }

    public void startInvocation() {
    }

    protected abstract AbstractResponseStream createResponseStream();

    protected void setHead() {
        this._responseStream.setHead();
    }

    protected final boolean isHead() {
        return this._responseStream.isHead();
    }

    public boolean containsHeader(String name) {
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String oldKey = this._headerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return true;
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this._request.getResponseFacade().getContentType() != null;
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this._contentLength >= 0L;
        }
        return false;
    }

    public String getHeader(String name) {
        ArrayList<String> keys = this._headerKeys;
        int headerSize = keys.size();
        for (int i = 0; i < headerSize; ++i) {
            String oldKey = keys.get(i);
            if (!oldKey.equalsIgnoreCase(name)) continue;
            return this._headerValues.get(i);
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this._request.getResponseFacade().getContentType();
        }
        if (name.equalsIgnoreCase("content-length")) {
            return this._contentLength >= 0L ? String.valueOf(this._contentLength) : null;
        }
        return null;
    }

    public void setHeader(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.setSpecial(key, value)) {
            return;
        }
        if (this.isCommitted() && !this._isHeaderWritten) {
            return;
        }
        this.setHeaderImpl(key, value);
    }

    protected void setHeaderImpl(String key, String value) {
        int i = 0;
        boolean hasHeader = false;
        ArrayList<String> keys = this._headerKeys;
        ArrayList<String> values = this._headerValues;
        for (i = keys.size() - 1; i >= 0; --i) {
            String oldKey = keys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            if (hasHeader) {
                keys.remove(i);
                values.remove(i);
                continue;
            }
            hasHeader = true;
            values.set(i, value);
        }
        if (!hasHeader) {
            keys.add(key);
            values.add(value);
        }
    }

    public void addHeader(String key, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.addHeaderImpl(key, value);
    }

    public void addHeaderImpl(String key, String value) {
        if (this.setSpecial(key, value)) {
            return;
        }
        this._headerKeys.add(key);
        this._headerValues.add(value);
    }

    protected static ContentType parseContentType(String contentType) {
        ContentType item = _contentTypeMap.get(contentType);
        if (item == null) {
            item = new ContentType(contentType);
            _contentTypeMap.put(contentType, item);
        }
        return item;
    }

    protected boolean setSpecial(String key, String value) {
        int length = key.length();
        if (256 <= length) {
            return false;
        }
        key.getChars(0, length, this._headerBuffer, 0);
        switch (_headerCodes.get(this._headerBuffer, length)) {
            case 1: {
                if (!(value.startsWith("max-age") || value.startsWith("s-maxage") || value.equals("x-anonymous"))) {
                    this._request.getResponseFacade().setCacheControl(true);
                }
                return false;
            }
            case 6: {
                if ("close".equalsIgnoreCase(value)) {
                    this._request.killKeepalive();
                }
                return true;
            }
            case 2: {
                this._request.getResponseFacade().setContentType(value);
                return true;
            }
            case 3: {
                this._contentLength = Long.parseLong(value.trim());
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    public void removeHeader(String key) {
        ArrayList<String> keys = this._headerKeys;
        ArrayList<String> values = this._headerValues;
        for (int i = keys.size() - 1; i >= 0; --i) {
            String oldKey = keys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            keys.remove(i);
            values.remove(i);
            return;
        }
    }

    public void setIntHeader(String name, int value) {
        this._cb.clear();
        this._cb.append(value);
        this.setHeader(name, this._cb.toString());
    }

    public void addIntHeader(String key, int value) {
        this._cb.clear();
        this._cb.append(value);
        this.addHeader(key, this._cb.toString());
    }

    public void setDateHeader(String name, long value) {
        this._calendar.setGMTTime(value);
        this.setHeader(name, this._calendar.printDate());
    }

    public void addDateHeader(String key, long value) {
        this._calendar.setGMTTime(value);
        this.addHeader(key, this._calendar.printDate());
    }

    public ArrayList<String> getHeaderKeys() {
        return this._headerKeys;
    }

    public ArrayList<String> getHeaderValues() {
        return this._headerValues;
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < this._headerKeys.size(); ++i) {
            String key = this._headerKeys.get(i);
            if (!key.equals(name)) continue;
            headers.add(this._headerValues.get(i));
        }
        return headers;
    }

    public Collection<String> getHeaderNames() {
        return new HashSet<String>(this._headerKeys);
    }

    public ArrayList<String> getFooterKeys() {
        return this._footerKeys;
    }

    public ArrayList<String> getFooterValues() {
        return this._footerValues;
    }

    public void setContentLength(int length) {
        this._contentLength = length;
    }

    public long getContentLengthHeader() {
        return this._contentLength;
    }

    public void setFooter(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int i = 0;
        boolean hasFooter = false;
        for (i = this._footerKeys.size() - 1; i >= 0; --i) {
            String oldKey = this._footerKeys.get(i);
            if (!oldKey.equalsIgnoreCase(key)) continue;
            if (hasFooter) {
                this._footerKeys.remove(i);
                this._footerValues.remove(i);
                continue;
            }
            hasFooter = true;
            this._footerValues.set(i, value);
        }
        if (!hasFooter) {
            this._footerKeys.add(key);
            this._footerValues.add(value);
        }
    }

    public void addFooter(String key, String value) {
        if (this.setSpecial(key, value)) {
            return;
        }
        this._footerKeys.add(key);
        this._footerValues.add(value);
    }

    protected boolean hasFooter() {
        return this._footerKeys.size() > 0;
    }

    protected AbstractResponseStream getResponseStream() {
        return this._responseStream;
    }

    protected ServletOutputStreamImpl getResponseOutputStream() {
        return this._responseOutputStream;
    }

    protected ResponseWriter getResponsePrintWriter() {
        return this._responsePrintWriter;
    }

    public boolean isCommitted() {
        if (this._responseStream.isCommitted()) {
            return true;
        }
        return this._contentLength > 0L && this._contentLength <= (long)this._responseStream.getContentLength();
    }

    protected void reset() {
        this._headerKeys.clear();
        this._headerValues.clear();
        this._contentLength = -1L;
    }

    public int getContentLength() {
        return this._responseStream.getContentLength();
    }

    public boolean isHeaderWritten() {
        return this._isHeaderWritten;
    }

    public void setHeaderWritten(boolean isWritten) {
        this._isHeaderWritten = isWritten;
    }

    final void writeContinue() throws IOException {
        if (!this.isHeaderWritten()) {
            this.writeContinueInt();
        }
    }

    protected void writeContinueInt() throws IOException {
    }

    public final boolean writeHeaders(int length) throws IOException {
        if (this.isHeaderWritten()) {
            return false;
        }
        HttpServletRequestImpl req = this._request.getRequestFacade();
        HttpServletResponseImpl res = this._request.getResponseFacade();
        if (res == null) {
            return false;
        }
        this._isHeaderWritten = true;
        boolean isHead = false;
        if (this._request.getMethod().equals("HEAD")) {
            isHead = true;
            this._responseStream.setHead();
        }
        WebApp webApp = this._request.getWebApp();
        int statusCode = res.getStatus();
        int majorCode = statusCode / 100;
        if (webApp != null && majorCode == 5) {
            webApp.addStatus500();
        }
        if (req != null) {
            HttpSession session = req.getMemorySession();
            if (session instanceof SessionImpl) {
                ((SessionImpl)session).saveBeforeHeaders();
            }
            res.addServletCookie(webApp);
        }
        return this.writeHeadersInt(length, isHead);
    }

    protected abstract boolean writeHeadersInt(int var1, boolean var2) throws IOException;

    public boolean fillCookie(CharBuffer cb, Cookie cookie, long date, int version, boolean isCookie2) {
        WebApp app;
        String path;
        cb.clear();
        cb.append(cookie.getName());
        if (isCookie2) {
            cb.append("=\"");
            cb.append(cookie.getValue());
            cb.append("\"");
        } else {
            cb.append("=");
            cb.append(cookie.getValue());
        }
        String domain = cookie.getDomain();
        if (domain != null && !domain.equals("")) {
            if (isCookie2) {
                cb.append("; Domain=");
                cb.append('\"');
                cb.append(domain);
                cb.append('\"');
            } else {
                cb.append("; domain=");
                cb.append(domain);
            }
        }
        if ((path = cookie.getPath()) != null && !path.equals("")) {
            if (isCookie2) {
                cb.append("; Path=");
                cb.append('\"');
                cb.append(path);
                cb.append('\"');
            } else {
                if (version > 0) {
                    cb.append("; Path=");
                } else {
                    cb.append("; path=");
                }
                cb.append(path);
            }
        }
        if (cookie.getSecure()) {
            if (version > 0) {
                cb.append("; Secure");
            } else {
                cb.append("; secure");
            }
        }
        int maxAge = cookie.getMaxAge();
        if (version > 0) {
            CookieImpl extCookie;
            String port;
            if (maxAge >= 0) {
                cb.append("; Max-Age=");
                cb.append(maxAge);
            }
            cb.append("; Version=");
            cb.append(version);
            if (cookie.getComment() != null) {
                if (isCookie2) {
                    cb.append("; Comment=\"");
                    cb.append(cookie.getComment());
                    cb.append("\"");
                } else {
                    cb.append("; Comment=");
                    cb.append(cookie.getComment());
                }
            }
            if (cookie instanceof CookieImpl && (port = (extCookie = (CookieImpl)cookie).getPort()) != null && isCookie2) {
                cb.append("; Port=\"");
                cb.append(port);
                cb.append("\"");
            }
        }
        if (!isCookie2) {
            if (maxAge == 0) {
                cb.append("; expires=Thu, 01-Dec-1994 16:00:00 GMT");
            } else if (maxAge >= 0) {
                this._calendar.setGMTTime(date + 1000L * (long)maxAge);
                cb.append("; expires=");
                cb.append(this._calendar.format("%a, %d-%b-%Y %H:%M:%S GMT"));
            }
        }
        if ((app = this._request.getWebApp()).getCookieHttpOnly() || app.getSessionManager().isCookieHttpOnly()) {
            cb.append("; HttpOnly");
        }
        return true;
    }

    public void close() throws IOException {
        if (!this._request.isSuspend()) {
            this.finishInvocation(true);
        }
    }

    public void finishInvocation() throws IOException {
        boolean isClose = !this._request.isSuspend();
        this.finishInvocation(isClose);
    }

    public void finishRequest() throws IOException {
        this.finishRequest(false);
    }

    private void finishInvocation(boolean isClose) throws IOException {
        if (this._isClosed) {
            return;
        }
        try {
            HttpServletResponseImpl response = this._request.getResponseFacade();
            if (response != null && response.getStatus() == 304) {
                response.handleNotModified();
            }
            if (this._responseStream != null) {
                if (isClose) {
                    this._responseStream.close();
                    this.finishResponseStream(isClose);
                } else {
                    this._responseStream.flush();
                    this.finishResponseStream(isClose);
                }
            }
        }
        catch (ClientDisconnectException e) {
            this._request.killKeepalive();
            this._isClientDisconnect = true;
            if (this.isIgnoreClientDisconnect()) {
                log.fine(e.toString());
            }
            throw e;
        }
        catch (IOException e) {
            this._request.killKeepalive();
            this._isClientDisconnect = true;
            throw e;
        }
    }

    protected void finishResponseStream(boolean isClose) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRequest(boolean isClose) throws IOException {
        if (this._isClosed) {
            return;
        }
        try {
            this._bufferStore = null;
            AbstractHttpRequest request = this._request;
            try {
                request.skip();
            }
            catch (BadRequestException e) {
                log.warning(e.toString());
                log.log(Level.FINE, e.toString(), e);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._isClosed = true;
        }
        finally {
            this._isClosed = true;
        }
    }

    protected void free() {
    }

    static {
        _contentTypeMap = new ConcurrentHashMap();
        _headerCodes = new CaseInsensitiveIntMap();
        _headerCodes.put("cache-control", 1);
        _headerCodes.put("connection", 6);
        _headerCodes.put("content-type", 2);
        _headerCodes.put("content-length", 3);
        _headerCodes.put("date", 4);
        _headerCodes.put("server", 5);
    }
}

