/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractCauchoRequest;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CauchoRequestWrapper
extends AbstractCauchoRequest {
    private HttpServletRequest _request;
    private CauchoResponse _response;

    public CauchoRequestWrapper() {
    }

    public CauchoRequestWrapper(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        this._request = request;
    }

    public void setRequest(HttpServletRequest request) {
        if (request == null || request == this) {
            throw new IllegalArgumentException();
        }
        this._request = request;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this._request;
    }

    public void setResponse(CauchoResponse response) {
        this._response = response;
    }

    @Override
    public CauchoResponse getResponse() {
        return this._response;
    }

    public String getProtocol() {
        return this._request.getProtocol();
    }

    public String getScheme() {
        return this._request.getScheme();
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public String getRemoteAddr() {
        return this._request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this._request.getRemoteHost();
    }

    public int getRemotePort() {
        return this._request.getRemotePort();
    }

    public String getLocalAddr() {
        return this._request.getLocalAddr();
    }

    public String getLocalName() {
        return this._request.getLocalName();
    }

    public int getLocalPort() {
        return this._request.getLocalPort();
    }

    public String getParameter(String name) {
        return this._request.getParameter(name);
    }

    public Map getParameterMap() {
        return this._request.getParameterMap();
    }

    public String[] getParameterValues(String name) {
        return this._request.getParameterValues(name);
    }

    public Enumeration<String> getParameterNames() {
        return this._request.getParameterNames();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this._request.getInputStream();
    }

    public BufferedReader getReader() throws IOException, IllegalStateException {
        return this._request.getReader();
    }

    public String getCharacterEncoding() {
        return this._request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._request.setCharacterEncoding(encoding);
    }

    public int getContentLength() {
        return this._request.getContentLength();
    }

    public String getContentType() {
        return this._request.getContentType();
    }

    public Locale getLocale() {
        return this._request.getLocale();
    }

    public Enumeration getLocales() {
        return this._request.getLocales();
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this._request.setAttribute(name, o);
    }

    public Enumeration<String> getAttributeNames() {
        return this._request.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this._request.removeAttribute(name);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        int p;
        String pathInfo;
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            return this.getWebApp().getRequestDispatcher(path);
        }
        CharBuffer cb = new CharBuffer();
        WebApp webApp = this.getWebApp();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        cb.append(path);
        if (webApp != null) {
            return webApp.getRequestDispatcher(cb.toString());
        }
        return null;
    }

    public ServletContext getServletContext() {
        return this.getWebApp();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this._request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this._request.startAsync(servletRequest, servletResponse);
    }

    public AsyncContext getAsyncContext() {
        return this._request.getAsyncContext();
    }

    public boolean isAsyncStarted() {
        return this._request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._request.isAsyncSupported();
    }

    public boolean isWrapperFor(ServletRequest wrapped) {
        return this._request == wrapped;
    }

    public boolean isWrapperFor(Class<?> wrappedType) {
        return wrappedType.isAssignableFrom(this._request.getClass());
    }

    public DispatcherType getDispatcherType() {
        return this._request.getDispatcherType();
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public String getRequestURI() {
        return this._request.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        int port = this.getServerPort();
        if (port > 0 && port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    public String getContextPath() {
        return this._request.getContextPath();
    }

    public String getServletPath() {
        return this._request.getServletPath();
    }

    public String getPathInfo() {
        return this._request.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public String getQueryString() {
        return this._request.getQueryString();
    }

    public String getHeader(String name) {
        return this._request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this._request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this._request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this._request.getIntHeader(name);
    }

    public long getDateHeader(String name) {
        return this._request.getDateHeader(name);
    }

    public Cookie[] getCookies() {
        return this._request.getCookies();
    }

    public String getRequestedSessionId() {
        return this._request.getRequestedSessionId();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this._request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._request.isRequestedSessionIdFromURL();
    }

    @Override
    public void setSessionId(String sessionId) {
        CauchoRequest cRequest = this.getCauchoRequest();
        if (cRequest != null) {
            cRequest.setSessionId(sessionId);
        }
    }

    @Override
    public String getSessionId() {
        CauchoRequest cRequest = this.getCauchoRequest();
        if (cRequest != null) {
            return cRequest.getSessionId();
        }
        return null;
    }

    @Override
    public boolean isSessionIdFromCookie() {
        CauchoRequest cRequest = this.getCauchoRequest();
        if (cRequest != null) {
            return cRequest.isSessionIdFromCookie();
        }
        return !this._request.isRequestedSessionIdFromURL();
    }

    public String getAuthType() {
        return this._request.getAuthType();
    }

    public String getRemoteUser() {
        return this._request.getRemoteUser();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this._request.isRequestedSessionIdFromUrl();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this._request.getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this._request.getParts();
    }

    public void logout() throws ServletException {
        this._request.logout();
    }

    @Override
    public String getPageURI() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getPageURI();
    }

    @Override
    public String getPageContextPath() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getPageContextPath();
    }

    @Override
    public String getPageServletPath() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getPageServletPath();
    }

    @Override
    public String getPagePathInfo() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getPagePathInfo();
    }

    @Override
    public String getPageQueryString() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getPageQueryString();
    }

    @Override
    public WebApp getWebApp() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getWebApp();
    }

    @Override
    public ReadStream getStream() throws IOException {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getStream();
    }

    @Override
    public int getRequestDepth(int depth) {
        if (this._request instanceof CauchoRequest) {
            CauchoRequest cRequest = (CauchoRequest)this._request;
            return cRequest.getRequestDepth(depth + 1);
        }
        return 0;
    }

    @Override
    public void setHeader(String key, String value) {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        cRequest.setHeader(key, value);
    }

    @Override
    public boolean isSyntheticCacheHeader() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isSyntheticCacheHeader();
    }

    @Override
    public void setSyntheticCacheHeader(boolean isSynthetic) {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        cRequest.setSyntheticCacheHeader(isSynthetic);
    }

    @Override
    public boolean getVaryCookies() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getVaryCookies();
    }

    @Override
    public void setVaryCookie(String cookie) {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        cRequest.setVaryCookie(cookie);
    }

    @Override
    public boolean getHasCookie() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getHasCookie();
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public boolean hasRequest() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.hasRequest();
    }

    @Override
    public HttpSession getMemorySession() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getMemorySession();
    }

    @Override
    public Cookie getCookie(String name) {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getCookie(name);
    }

    @Override
    public void setHasCookie() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        cRequest.setHasCookie();
    }

    @Override
    public void killKeepalive() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        cRequest.killKeepalive();
    }

    @Override
    public boolean isSuspend() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isSuspend();
    }

    @Override
    public boolean isComet() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isComet();
    }

    @Override
    public boolean isDuplex() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isDuplex();
    }

    @Override
    public boolean isKeepaliveAllowed() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isKeepaliveAllowed();
    }

    @Override
    public boolean isClientDisconnect() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isClientDisconnect();
    }

    @Override
    public void clientDisconnect() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        cRequest.clientDisconnect();
    }

    @Override
    public boolean isLoginRequested() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.isLoginRequested();
    }

    @Override
    public void requestLogin() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        if (cRequest != null) {
            cRequest.requestLogin();
        }
    }

    @Override
    public ServletResponse getServletResponse() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getServletResponse();
    }

    @Override
    public AbstractHttpRequest getAbstractHttpRequest() {
        CauchoRequest cRequest = (CauchoRequest)this._request;
        return cRequest.getAbstractHttpRequest();
    }

    private CauchoRequest getCauchoRequest() {
        HttpServletRequest request = this._request;
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof CauchoRequest) {
                return (CauchoRequest)request;
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (request instanceof CauchoRequest) {
            return (CauchoRequest)request;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._request + "]";
    }
}

