/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.cluster.Server;
import com.caucho.util.CharSegment;
import com.caucho.util.FreeList;
import com.caucho.vfs.TempBuffer;

public final class HttpBufferStore {
    private static final FreeList<HttpBufferStore> _freeList = new FreeList(256);
    private final byte[] _logBuffer = null;
    private final byte[] _uri;
    private final char[] _headerBuffer;
    private final int _headerCapacity;
    private final CharSegment[] _headerKeys;
    private final CharSegment[] _headerValues;
    private final TempBuffer _tempBuffer = TempBuffer.allocate();

    private HttpBufferStore(Server server) {
        int urlLengthMax = server.getUrlLengthMax();
        this._uri = new byte[urlLengthMax];
        if (TempBuffer.isSmallmem()) {
            this._headerBuffer = new char[4096];
            this._headerCapacity = 64;
        } else {
            this._headerBuffer = new char[16384];
            this._headerCapacity = 256;
        }
        this._headerKeys = new CharSegment[this._headerCapacity];
        this._headerValues = new CharSegment[this._headerCapacity];
        for (int i = 0; i < this._headerCapacity; ++i) {
            this._headerKeys[i] = new CharSegment();
            this._headerValues[i] = new CharSegment();
        }
    }

    public static HttpBufferStore allocate(Server server) {
        HttpBufferStore buffer = _freeList.allocate();
        if (buffer == null) {
            buffer = new HttpBufferStore(server);
        }
        return buffer;
    }

    public static void free(HttpBufferStore buffer) {
        _freeList.free(buffer);
    }

    public final byte[] getUriBuffer() {
        return this._uri;
    }

    public final char[] getHeaderBuffer() {
        return this._headerBuffer;
    }

    public final int getHeaderCapacity() {
        return this._headerCapacity;
    }

    public final CharSegment[] getHeaderKeys() {
        return this._headerKeys;
    }

    public final CharSegment[] getHeaderValues() {
        return this._headerValues;
    }

    public final TempBuffer getTempBuffer() {
        return this._tempBuffer;
    }

    public final byte[] getLogBuffer() {
        return this._logBuffer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

