/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.env.meter.AverageMeter;
import com.caucho.env.meter.MeterService;
import com.caucho.env.meter.SampleCountMeter;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.cluster.Server;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.ChunkedInputStream;
import com.caucho.server.http.ContentLengthStream;
import com.caucho.server.http.HttpBufferStore;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.RawInputStream;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends AbstractHttpRequest
implements ProtocolConnection {
    private static final Logger log = Logger.getLogger(HttpRequest.class.getName());
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    static final CharBuffer _getCb = new CharBuffer("GET");
    static final CharBuffer _headCb = new CharBuffer("HEAD");
    static final CharBuffer _postCb = new CharBuffer("POST");
    static final char[] _hostCb = "Host".toCharArray();
    static final char[] _userAgentCb = "User-Agent".toCharArray();
    static final CharBuffer _http11Cb = new CharBuffer("HTTP/1.1");
    static final CharBuffer _http10Cb = new CharBuffer("HTTP/1.0");
    private static final String REQUEST_TIME_PROBE = "Resin|Http|Request";
    private static final String REQUEST_COUNT_PROBE = "Resin|Http|Request Count";
    private static final String REQUEST_BYTES_PROBE = "Resin|Http|Request Bytes";
    private final CharBuffer _method = new CharBuffer();
    private String _methodString;
    private final CharBuffer _uriHost = new CharBuffer();
    private final CharBuffer _hostBuffer = new CharBuffer();
    private CharSequence _host;
    private byte[] _uri;
    private int _uriLength;
    private final CharBuffer _protocol = new CharBuffer();
    private int _version;
    private final InvocationKey _invocationKey = new InvocationKey();
    private char[] _headerBuffer;
    private CharSegment[] _headerKeys;
    private CharSegment[] _headerValues;
    private int _headerSize;
    private ChunkedInputStream _chunkedInputStream = new ChunkedInputStream();
    private ContentLengthStream _contentLengthStream = new ContentLengthStream();
    private RawInputStream _rawInputStream = new RawInputStream();
    private ActiveTimeMeter _requestTimeProbe = MeterService.createActiveTimeMeter("Resin|Http|Request");
    private SampleCountMeter _requestCountProbe;
    private AverageMeter _requestBytesProbe = MeterService.createAverageMeter("Resin|Http|Request Bytes", "");

    public HttpRequest(Server server, SocketLink conn) {
        super(server, conn);
    }

    @Override
    public HttpResponse createResponse() {
        return new HttpResponse(this, this.getConnection().getWriteStream());
    }

    @Override
    public final boolean isWaitForRead() {
        return true;
    }

    @Override
    public boolean hasRequest() {
        return this.getRequestFacade() != null;
    }

    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals(_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals(_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals(_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    @Override
    protected CharSequence getHost() {
        if (this._host != null) {
            return this._host;
        }
        String virtualHost = this.getConnection().getVirtualHost();
        this._host = virtualHost != null ? virtualHost : (this._uriHost.length() > 0 ? this._uriHost : this._hostHeader);
        return this._host;
    }

    private CharSequence getInvocationHost() throws IOException {
        if (this._host != null) {
            return this._host;
        }
        String virtualHost = this.getConnection().getVirtualHost();
        if (virtualHost != null) {
            return virtualHost;
        }
        if (this._host == null) {
            if (this._uriHost.length() > 0) {
                this._host = this._uriHost;
            } else if (this._hostHeader != null) {
                this._host = this._hostHeader;
            } else if (257 <= this.getVersion()) {
                throw new BadRequestException("HTTP/1.1 requires a Host header (Remote IP=" + this.getRemoteHost() + ")");
            }
        }
        return this._host;
    }

    @Override
    public byte[] getUriBuffer() {
        return this._uri;
    }

    @Override
    public int getUriLength() {
        return this._uriLength;
    }

    @Override
    public String getProtocol() {
        switch (this._version) {
            case 257: {
                return "HTTP/1.1";
            }
            case 256: {
                return "HTTP/1.0";
            }
        }
        return "HTTP/0.9";
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    int getVersion() {
        char ch;
        if (this._version > 0) {
            return this._version;
        }
        CharSegment protocol = this.getProtocolBuffer();
        if (protocol.equals("HTTP/1.1")) {
            this._version = 257;
            return 257;
        }
        if (protocol.equals("HTTP/1.0")) {
            this._version = 256;
            return this._version;
        }
        if (protocol.equals("HTTP/0.9")) {
            this._version = 9;
            return 9;
        }
        if (protocol.length() < 8) {
            this._version = 9;
            return this._version;
        }
        int i = protocol.indexOf('/');
        int len = protocol.length();
        int major = 0;
        ++i;
        while (i < len) {
            char ch2 = protocol.charAt(i);
            if ('0' > ch2 || ch2 > '9') {
                if (ch2 == '.') break;
                this._version = 256;
                return this._version;
            }
            major = 10 * major + ch2 - 48;
            ++i;
        }
        int minor = 0;
        ++i;
        while (i < len && '0' <= (ch = protocol.charAt(i)) && ch <= '9') {
            minor = 10 * minor + ch - 48;
            ++i;
        }
        this._version = 256 * major + minor;
        return this._version;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    @Override
    public int getHeaderSize() {
        return this._headerSize;
    }

    @Override
    public CharSegment getHeaderKey(int index) {
        return this._headerKeys[index];
    }

    @Override
    public CharSegment getHeaderValue(int index) {
        return this._headerValues[index];
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        char[] keyBuf = this._headerBuffer;
        CharSegment[] headerKeys = this._headerKeys;
        for (int i = this._headerSize - 1; i >= 0; --i) {
            int j;
            CharSegment key = headerKeys[i];
            if (key.length() != length) continue;
            int offset = key.getOffset();
            for (j = length - 1; j >= 0; --j) {
                char a = testBuf[j];
                char b = keyBuf[offset + j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j >= 0) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i]);
        }
    }

    public Enumeration getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this._headerSize;
        int length = key.length();
        char[] keyBuf = this._headerBuffer;
        while (i < size) {
            CharSegment header = this._headerKeys[i];
            if (header.length() == length) {
                int j;
                int offset = header.getOffset();
                for (j = 0; j < length; ++j) {
                    char b;
                    char a = key.charAt(j);
                    if (a == (b = keyBuf[offset + j])) continue;
                    if (a >= 'A' && a <= 'Z') {
                        a = (char)(a + 32);
                    }
                    if (b >= 'A' && b <= 'Z') {
                        b = (char)(b + 32);
                    }
                    if (a != b) break;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this._headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public void setHeader(String key, String value) {
        int i;
        int tail = this._headerSize > 0 ? this._headerValues[this._headerSize - 1].getOffset() + this._headerValues[this._headerSize - 1].getLength() : 0;
        char[] headerBuffer = this._headerBuffer;
        for (i = key.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = key.charAt(i);
        }
        this._headerKeys[this._headerSize].init(headerBuffer, tail, key.length());
        tail += key.length();
        for (i = value.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = value.charAt(i);
        }
        this._headerValues[this._headerSize].init(headerBuffer, tail, value.length());
        ++this._headerSize;
    }

    @Override
    protected void initAttributes(HttpServletRequestImpl request) {
        SocketLink conn = this.getConnection();
        if (!(conn instanceof TcpSocketLink)) {
            return;
        }
        TcpSocketLink tcpConn = (TcpSocketLink)conn;
        if (!conn.isSecure()) {
            return;
        }
        QSocket socket = tcpConn.getSocket();
        String cipherSuite = socket.getCipherSuite();
        request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
        int keySize = socket.getCipherBits();
        if (keySize != 0) {
            request.setAttribute("javax.servlet.request.key_size", new Integer(keySize));
        }
        try {
            X509Certificate[] certs = socket.getClientCertificates();
            if (certs != null && certs.length > 0) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
                request.setAttribute("caucho.login", certs[0].getSubjectDN());
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    @Override
    public String findSessionIdFromConnection() {
        SocketLink link = this.getConnection();
        TcpSocketLink tcpConn = null;
        if (link instanceof TcpSocketLink) {
            tcpConn = (TcpSocketLink)this.getConnection();
        }
        if (tcpConn == null || !tcpConn.isSecure()) {
            return null;
        }
        return null;
    }

    @Override
    public boolean initStream(ReadStream readStream, ReadStream rawRead) throws IOException {
        String te;
        rawRead.setSibling(null);
        if (this.getConnection().isDuplex()) {
            this._rawInputStream.init(rawRead);
            readStream.init(this._rawInputStream, null);
            return true;
        }
        long contentLength = this.getLongContentLength();
        if (contentLength < 0L && 257 <= this.getVersion() && (te = this.getHeader("Transfer-Encoding")) != null) {
            this._chunkedInputStream.init(rawRead);
            readStream.init(this._chunkedInputStream, null);
            return true;
        }
        if (contentLength >= 0L) {
            this._contentLengthStream.init(rawRead, contentLength);
            readStream.init(this._contentLengthStream, null);
            return true;
        }
        if (this.getMethod().equals("POST")) {
            this._contentLengthStream.init(rawRead, 0L);
            readStream.init(this._contentLengthStream, null);
            throw new BadRequestException("POST requires content-length");
        }
        this._contentLengthStream.init(rawRead, 0L);
        readStream.init(this._contentLengthStream, null);
        return false;
    }

    @Override
    protected void skip() throws IOException {
        if (this.getMethod() == "GET") {
            return;
        }
        super.skip();
    }

    @Override
    public ReadStream getRawInput() {
        return this.getRawRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest() throws IOException {
        boolean isInvocation = false;
        Server server = this.getServer();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        long startTime = 0L;
        try {
            thread.setContextClassLoader(server.getClassLoader());
            this.startRequest(HttpBufferStore.allocate(server));
            if (!this.parseRequest()) {
                boolean bl = false;
                return bl;
            }
            CharSequence host = this.getInvocationHost();
            Invocation invocation = this.getInvocation(host, this._uri, this._uriLength);
            if (invocation == null) {
                boolean bl = false;
                return bl;
            }
            HttpServletRequestImpl requestFacade = this.getRequestFacade();
            requestFacade.setInvocation(invocation);
            isInvocation = true;
            startTime = this._requestTimeProbe.start();
            this.startInvocation();
            invocation.service((ServletRequest)requestFacade, (ServletResponse)this.getResponseFacade());
        }
        catch (ClientDisconnectException e) {
            this.getResponseFacade().killCache();
            this.killKeepalive();
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            this.getResponseFacade().killCache();
            this.killKeepalive();
            this.sendRequestError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (isInvocation) {
                this.finishInvocation();
            }
            if (!this.isSuspend()) {
                this.finishRequest();
            }
            if (startTime > 0L) {
                this._requestTimeProbe.end(startTime);
                this._requestBytesProbe.add(this.getResponse().getContentLength());
            }
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    private boolean parseRequest() throws IOException {
        try {
            ReadStream is = this.getRawRead();
            if (!this.readRequest(is)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "read timeout");
                }
                this.clearRequest();
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + this._method + " " + new String(this._uri, 0, this._uriLength) + " " + this._protocol);
                log.fine(this.dbgId() + "Remote-IP: " + this.getRemoteHost() + ":" + this.getRemotePort());
            }
            this.parseHeaders(is);
            return true;
        }
        catch (ClientDisconnectException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            throw new BadRequestException(String.valueOf(e), e);
        }
    }

    @Override
    protected void startRequest(HttpBufferStore httpBuffer) throws IOException {
        super.startRequest(httpBuffer);
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._uriLength = 0;
        this._uri = httpBuffer.getUriBuffer();
        this._uriHost.clear();
        this._host = null;
        this._headerSize = 0;
        this._headerBuffer = httpBuffer.getHeaderBuffer();
        this._headerKeys = httpBuffer.getHeaderKeys();
        this._headerValues = httpBuffer.getHeaderValues();
    }

    private boolean readRequest(ReadStream s) throws IOException {
        byte ch;
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        do {
            if (readLength > readOffset) continue;
            readLength = s.fillBuffer();
            if (readLength < 0) {
                return false;
            }
            readOffset = 0;
        } while ((ch = readBuffer[readOffset++]) == 32 || ch == 9 || ch == 13 || ch == 10);
        char[] buffer = this._method.getBuffer();
        int length = buffer.length;
        int offset = 0;
        while (true) {
            if (length > offset) {
                if (97 <= ch && ch <= 122) {
                    buffer[offset++] = (char)(ch + 65 - 97);
                } else {
                    if (ch <= 32) break;
                    buffer[offset++] = (char)ch;
                }
            }
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        this._method.setLength(offset);
        while (ch == 32 || ch == 9) {
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        byte[] uriBuffer = this._uri;
        int uriLength = 0;
        if (ch != 47) {
            byte ch1;
            while (ch > 32 && ch != 47) {
                if (readOffset >= readLength) {
                    readLength = s.fillBuffer();
                    if (readLength < 0) {
                        return false;
                    }
                    readOffset = 0;
                }
                ch = readBuffer[readOffset++];
            }
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    if (ch == 47) {
                        uriBuffer[uriLength++] = ch;
                        this._uriLength = uriLength;
                    }
                    return true;
                }
                readOffset = 0;
            }
            if ((ch1 = readBuffer[readOffset++]) != 47) {
                uriBuffer[uriLength++] = ch;
                ch = ch1;
            } else {
                block12: while (true) {
                    if (readLength <= readOffset) {
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            return true;
                        }
                        readOffset = 0;
                    }
                    ch = readBuffer[readOffset++];
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block12;
                        }
                        case 63: {
                            break block12;
                        }
                        case 47: {
                            break block12;
                        }
                        default: {
                            this._uriHost.append((char)ch);
                            continue block12;
                        }
                    }
                    break;
                }
            }
        }
        block13: while (true) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break block13;
                }
                default: {
                    uriBuffer[uriLength++] = ch;
                    if (readOffset >= readLength) {
                        readOffset = 0;
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            this._uriLength = uriLength;
                            return true;
                        }
                    }
                    ch = readBuffer[readOffset++];
                    continue block13;
                }
            }
            break;
        }
        this._uriLength = uriLength;
        while (ch == 32 || ch == 9) {
            if (readLength <= readOffset) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        buffer = this._protocol.getBuffer();
        length = buffer.length;
        offset = 0;
        while (ch != 32 && ch != 9 && ch != 13 && ch != 10) {
            if (length > offset) {
                buffer[offset++] = 97 <= ch && ch <= 122 ? (char)(ch + 65 - 97) : (char)ch;
            }
            if (readLength <= readOffset) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    this._protocol.setLength(offset);
                    return true;
                }
            }
            ch = readBuffer[readOffset++];
        }
        this._protocol.setLength(offset);
        if (offset != 8) {
            this._protocol.append("HTTP/0.9");
            this._version = 9;
        } else {
            this._version = buffer[7] == '1' ? 257 : (buffer[7] == '0' ? 256 : 9);
        }
        while (ch != 10) {
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        s.setOffset(readOffset);
        return true;
    }

    private void parseHeaders(ReadStream s) throws IOException {
        int version = this.getVersion();
        if (version < 256) {
            return;
        }
        if (version < 257) {
            this.killKeepalive();
        }
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        char[] headerBuffer = this._headerBuffer;
        int headerOffset = 1;
        int headerBufferSize = headerBuffer.length;
        headerBuffer[0] = 122;
        int headerSize = 0;
        this._headerSize = 0;
        CharSegment[] headerKeys = this._headerKeys;
        CharSegment[] headerValues = this._headerValues;
        boolean debug = log.isLoggable(Level.FINE);
        while (true) {
            int ch;
            int keyOffset = headerOffset;
            while (true) {
                if (readLength <= readOffset) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength <= 0) {
                        return;
                    }
                }
                if ((ch = readBuffer[readOffset++]) == 10) {
                    s.setOffset(readOffset);
                    return;
                }
                if (ch == 58) break;
                headerBuffer[headerOffset++] = (char)ch;
            }
            while (headerBuffer[headerOffset - 1] == ' ') {
                --headerOffset;
            }
            int keyLength = headerOffset - keyOffset;
            headerKeys[headerSize].init(headerBuffer, keyOffset, keyLength);
            do {
                if (readLength > readOffset) continue;
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength > 0) continue;
                return;
            } while ((ch = readBuffer[readOffset++]) == 32 || ch == 9);
            int valueOffset = headerOffset;
            while (true) {
                if (readLength <= readOffset) {
                    readOffset = 0;
                    readLength = s.fillBuffer();
                    if (readLength <= 0) break;
                }
                if (ch == 10) {
                    byte ch1 = readBuffer[readOffset];
                    if (ch1 != 32 && ch1 != 9) break;
                    ch = 32;
                    ++readOffset;
                    if (headerBuffer[headerOffset - 1] == '\r') {
                        // empty if block
                    }
                }
                int n = --headerOffset;
                ++headerOffset;
                headerBuffer[n] = (char)ch;
                ch = readBuffer[readOffset++];
            }
            while (headerBuffer[headerOffset - 1] <= ' ') {
                --headerOffset;
            }
            int valueLength = headerOffset - valueOffset;
            headerValues[headerSize].init(headerBuffer, valueOffset, valueLength);
            if (debug) {
                log.fine(this.dbgId() + headerKeys[headerSize] + ": " + headerValues[headerSize]);
            }
            if (this.addHeaderInt(headerBuffer, keyOffset, keyLength, headerValues[headerSize])) {
                // empty if block
            }
            this._headerSize = ++headerSize;
        }
    }

    @Override
    public SocketLinkDuplexController startDuplex(SocketLinkDuplexListener handler) {
        TcpSocketLink conn = (TcpSocketLink)this.getConnection();
        SocketLinkDuplexController context = conn.startDuplex(handler);
        this._rawInputStream.init(conn.getReadStream());
        this.getReadStream().setSource(this._rawInputStream);
        return context;
    }

    @Override
    public final void onCloseConnection() {
    }

    @Override
    public void finishRequest() throws IOException {
        super.finishRequest();
        this.skip();
    }

    @Override
    protected String dbgId() {
        String serverId = this.getServer().getServerId();
        int connId = this.getConnectionId();
        if ("".equals(serverId)) {
            return "Http[" + connId + "] ";
        }
        return "Http[" + serverId + ", " + connId + "] ";
    }

    public String toString() {
        String serverId = this.getServer().getServerId();
        int connId = this.getConnectionId();
        if ("".equals(serverId)) {
            return "HttpRequest[" + connId + "]";
        }
        return "HttpRequest[" + serverId + ", " + connId + "]";
    }
}

