/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.ResponseStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpResponseStream
extends ResponseStream {
    private static final Logger log = Logger.getLogger(HttpResponseStream.class.getName());
    private static final int _tailChunkedLength = 7;
    private static final byte[] _tailChunked = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private HttpResponse _response;
    private WriteStream _next;
    private boolean _isChunkedEncoding;
    private int _bufferStartOffset;

    HttpResponseStream(HttpResponse response, WriteStream next) {
        super(response);
        this._response = response;
        this._next = next;
    }

    public void start() {
        super.start();
        this._isChunkedEncoding = false;
        this._bufferStartOffset = 0;
    }

    protected void writeHeaders(int length) throws IOException {
        super.writeHeaders(length);
        this._isChunkedEncoding = this._response.isChunkedEncoding();
    }

    protected byte[] getNextBuffer() {
        return this._next.getBuffer();
    }

    protected int getNextStartOffset() {
        if (this._isChunkedEncoding && this._bufferStartOffset == 0) {
            this._bufferStartOffset = this._next.getBufferOffset() + 8;
            this._next.setBufferOffset(this._bufferStartOffset);
        }
        return this._bufferStartOffset;
    }

    protected int getNextBufferOffset() throws IOException {
        if (this._isChunkedEncoding && this._bufferStartOffset == 0) {
            this._bufferStartOffset = this._next.getBufferOffset() + 8;
            this._next.setBufferOffset(this._bufferStartOffset);
        }
        return this._next.getBufferOffset();
    }

    protected void setNextBufferOffset(int offset) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-set-offset(" + offset + ")");
        }
        this._next.setBufferOffset(offset);
    }

    protected byte[] writeNextBuffer(int offset) throws IOException {
        WriteStream next = this._next;
        int bufferStart = this._bufferStartOffset;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-next-buffer(" + (offset - bufferStart) + ")");
        }
        if (bufferStart > 0) {
            byte[] buffer = next.getBuffer();
            int len = offset - bufferStart;
            if (len > 0) {
                this.writeChunkHeader(buffer, bufferStart, offset - bufferStart);
            } else {
                offset = bufferStart - 8;
            }
            this._bufferStartOffset = 0;
        }
        return next.nextBuffer(offset);
    }

    public void flushNext() throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + "flush()");
        }
        if (this._bufferStartOffset > 0) {
            this._next.setBufferOffset(this._bufferStartOffset - 8);
        }
        this._next.flush();
        this._bufferStartOffset = 0;
    }

    protected void closeNext() throws IOException {
        this._bufferStartOffset = 0;
        AbstractHttpRequest req = this._response.getRequest();
        if (!req.isCometActive() && !req.isDuplex()) {
            if (!req.isKeepaliveAllowed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "close stream");
                }
                try {
                    this._next.close();
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + "finish/keepalive");
            }
        }
    }

    protected void writeTail(boolean isClose) throws IOException {
        ArrayList<String> footerKeys;
        if (!this._isChunkedEncoding) {
            this._next.flush();
            return;
        }
        int bufferStart = this._bufferStartOffset;
        int bufferOffset = this._next.getBufferOffset();
        if (bufferStart < bufferOffset && log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-tail(" + (bufferOffset - bufferStart) + ")");
        }
        if (bufferStart > 0) {
            byte[] buffer = this._next.getBuffer();
            int len = bufferOffset - bufferStart;
            if (len > 0) {
                this.writeChunkHeader(buffer, bufferStart, len);
            } else {
                bufferOffset = bufferStart - 8;
            }
            this._bufferStartOffset = 0;
        }
        if ((footerKeys = this._response.getFooterKeys()).size() == 0) {
            this._next.write(_tailChunked, 0, 7);
        } else {
            ArrayList<String> footerValues = this._response.getFooterValues();
            this._next.print("\r\n0\r\n");
            for (int i = 0; i < footerKeys.size(); ++i) {
                this._next.print(footerKeys.get(i));
                this._next.print(": ");
                this._next.print(footerValues.get(i));
                this._next.print("\r\n");
            }
            this._next.print("\r\n");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.dbgId() + "write-chunk-tail(" + 7 + ")");
        }
        this._next.flush();
    }

    private void writeChunkHeader(byte[] buffer, int start, int length) throws IOException {
        if (length == 0) {
            throw new IllegalStateException();
        }
        buffer[start - 8] = 13;
        buffer[start - 7] = 10;
        buffer[start - 6] = HttpResponseStream.hexDigit(length >> 12);
        buffer[start - 5] = HttpResponseStream.hexDigit(length >> 8);
        buffer[start - 4] = HttpResponseStream.hexDigit(length >> 4);
        buffer[start - 3] = HttpResponseStream.hexDigit(length);
        buffer[start - 2] = 13;
        buffer[start - 1] = 10;
    }

    private static byte hexDigit(int value) {
        if ((value &= 0xF) <= 9) {
            return (byte)(48 + value);
        }
        return (byte)(97 + value - 10);
    }
}

