/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.MultipartStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Part;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultipartForm {
    private static final Logger log = Logger.getLogger(MultipartForm.class.getName());
    static final L10N L = new L10N(MultipartForm.class);

    MultipartForm() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parsePostData(HashMapImpl<String, String[]> table, List<Part> parts, ReadStream rawIs, String boundary, HttpServletRequestImpl request, String javaEncoding, long uploadMax, long fileUploadMax) throws IOException {
        ReadStream is;
        MultipartStream ms = new MultipartStream(rawIs, boundary);
        ms.setEncoding(javaEncoding);
        while ((is = ms.openRead()) != null) {
            String attr = ms.getAttribute("content-disposition");
            if (attr == null || !attr.startsWith("form-data")) continue;
            String name = MultipartForm.getAttribute(attr, "name");
            String filename = MultipartForm.getAttribute(attr, "filename");
            if (name == null) continue;
            if (filename != null) {
                Object var24_26;
                String contentType = ms.getAttribute("content-type");
                Path tempDir = CauchoSystem.getWorkPath().lookup("form");
                try {
                    tempDir.mkdirs();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Path tempFile = tempDir.createTempFile("form", ".tmp");
                request.addCloseOnExit(tempFile);
                WriteStream os = tempFile.openWrite();
                TempBuffer tempBuffer = TempBuffer.allocate();
                byte[] buf = tempBuffer.getBuffer();
                int totalLength = 0;
                try {
                    int len;
                    while ((len = is.read(buf, 0, buf.length)) > 0) {
                        os.write(buf, 0, len);
                        totalLength += len;
                    }
                    var24_26 = null;
                }
                catch (Throwable throwable) {
                    var24_26 = null;
                    os.close();
                    TempBuffer.free(tempBuffer);
                    tempBuffer = null;
                    throw throwable;
                }
                os.close();
                TempBuffer.free(tempBuffer);
                tempBuffer = null;
                if (uploadMax > 0L && uploadMax < tempFile.getLength()) {
                    String msg = L.l("multipart form data '{0}' too large", "" + tempFile.getLength());
                    request.setAttribute("caucho.multipart.form.error", msg);
                    request.setAttribute("caucho.multipart.form.error.size", new Long(tempFile.getLength()));
                    tempFile.remove();
                    throw new IOException(msg);
                }
                if (fileUploadMax > 0L && fileUploadMax < tempFile.getLength()) {
                    String msg = L.l("multipart form data part '{0}':'{1}' is greater then the accepted value of '{2}'", name, "" + tempFile.getLength(), fileUploadMax);
                    tempFile.remove();
                    throw new IllegalStateException(msg);
                }
                if (tempFile.getLength() != (long)totalLength) {
                    String msg = L.l("multipart form upload failed (possibly due to full disk).");
                    request.setAttribute("caucho.multipart.form.error", msg);
                    request.setAttribute("caucho.multipart.form.error.size", new Long(tempFile.getLength()));
                    tempFile.remove();
                    throw new IOException(msg);
                }
                if (table.get(name + ".filename") == null) {
                    table.put(name, new String[]{tempFile.getNativePath()});
                    table.put(name + ".file", new String[]{tempFile.getNativePath()});
                    table.put(name + ".filename", new String[]{filename});
                    table.put(name + ".content-type", new String[]{contentType});
                } else {
                    MultipartForm.addTable(table, name, tempFile.getNativePath());
                    MultipartForm.addTable(table, name + ".file", tempFile.getNativePath());
                    MultipartForm.addTable(table, name + ".filename", filename);
                    MultipartForm.addTable(table, name + ".content-type", contentType);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("mp-file: " + name + "(filename:" + filename + ")");
                }
            } else {
                CharBuffer value = new CharBuffer();
                int ch = is.readChar();
                while (ch >= 0) {
                    value.append((char)ch);
                    ch = is.readChar();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("mp-form: " + name + "=" + value);
                }
                MultipartForm.addTable(table, name, value.toString());
            }
            parts.add(request.createPart(name, new HashMap<String, List<String>>(ms.getHeaders())));
        }
        if (!ms.isComplete()) {
            throw new IOException("Incomplete form");
        }
    }

    private static void addTable(HashMapImpl<String, String[]> table, String name, String value) {
        String[] oldArray = table.get(name);
        if (oldArray != null) {
            String[] newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
            table.put(name, newArray);
        } else {
            table.put(name, new String[]{value});
        }
    }

    private static String getAttribute(String attr, String name) {
        CharBuffer value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = attr.indexOf(name);
                    if (i < 0) {
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = CharBuffer.allocate();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.close();
    }
}

