/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.cache.AbstractCacheEntry;
import com.caucho.server.cache.AbstractCacheFilterChain;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.ToByteResponseStream;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResponseStream
extends ToByteResponseStream {
    private static final Logger log = Logger.getLogger(ResponseStream.class.getName());
    private static final L10N L = new L10N(ResponseStream.class);
    private final byte[] _singleByteBuffer = new byte[1];
    private AbstractHttpResponse _response;
    private AbstractCacheFilterChain _cacheInvocation;
    private AbstractCacheEntry _newCacheEntry;
    private OutputStream _cacheStream;
    private long _cacheMaxLength;
    private boolean _isDisableAutoFlush;
    private int _contentLength;
    private boolean _isAllowFlush = true;

    public ResponseStream() {
    }

    protected ResponseStream(AbstractHttpResponse response) {
        this.setResponse(response);
    }

    public void setResponse(AbstractHttpResponse response) {
        this._response = response;
    }

    protected AbstractHttpResponse getResponse() {
        return this._response;
    }

    public void start() {
        super.start();
        this._contentLength = 0;
        this._isAllowFlush = true;
        this._isDisableAutoFlush = false;
        this._cacheStream = null;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setByteCacheStream(OutputStream cacheStream) {
        this._cacheStream = cacheStream;
        if (cacheStream == null) {
            return;
        }
        AbstractHttpRequest req = this._response.getRequest();
        WebApp app = req.getWebApp();
        this._cacheMaxLength = app.getCacheMaxLength();
    }

    protected OutputStream getByteCacheStream() {
        return this._cacheStream;
    }

    public boolean canWrite() {
        return true;
    }

    protected boolean setFlush(boolean flush) {
        boolean isFlush = this._isAllowFlush;
        this._isAllowFlush = flush;
        return isFlush;
    }

    public void setAutoFlush(boolean isAutoFlush) {
        this.setDisableAutoFlush(!isAutoFlush);
    }

    void setDisableAutoFlush(boolean disable) {
        this._isDisableAutoFlush = disable;
    }

    protected boolean isDisableAutoFlush() {
        return this._isDisableAutoFlush;
    }

    public int getContentLength() {
        try {
            this.flushCharBuffer();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (this.isCommitted()) {
            return this._contentLength;
        }
        return super.getContentLength();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException(L.l("Buffer size cannot be set after commit"));
        }
        super.setBufferSize(size);
    }

    public boolean hasData() {
        return this.isCommitted() || this._contentLength > 0;
    }

    public boolean isCommitted() {
        if (super.isCommitted()) {
            return true;
        }
        try {
            if (this._contentLength > 0) {
                this.flushCharBuffer();
                int bufferOffset = this.getByteBufferOffset();
                if (this._contentLength <= bufferOffset) {
                    this.setCommitted();
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return false;
    }

    public void clear() throws IOException {
        this.clearBuffer();
        if (this.isCommitted()) {
            throw new IOException(L.l("can't clear response after writing headers"));
        }
    }

    public void clearBuffer() {
        super.clearBuffer();
        if (!this.isCommitted()) {
            this._response.setHeaderWritten(false);
        }
        this.clearNext();
    }

    public void clearClosed() {
    }

    protected void writeHeaders(int length) throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (!this.isClosing() || this.isCharFlushing()) {
            length = -1;
        }
        this.setCommitted();
        this.startCaching(true);
        this._response.writeHeaders(length);
    }

    public final void write(int ch) throws IOException {
        this._singleByteBuffer[0] = (byte)ch;
        this.write(this._singleByteBuffer, 0, 1);
    }

    public final byte[] getBuffer() throws IOException {
        if (this.isCommitted()) {
            this.flushBuffer();
            return this.getNextBuffer();
        }
        return super.getBuffer();
    }

    public final int getBufferOffset() throws IOException {
        if (!this.isCommitted()) {
            return super.getBufferOffset();
        }
        this.flushBuffer();
        return this.getNextBufferOffset();
    }

    public final void setBufferOffset(int offset) throws IOException {
        byte[] nextBuffer;
        if (this.isClosed()) {
            return;
        }
        if (!this.isCommitted()) {
            super.setBufferOffset(offset);
            return;
        }
        this.flushBuffer();
        int startOffset = this.getNextStartOffset();
        if (offset == startOffset) {
            return;
        }
        int oldOffset = this.getNextBufferOffset();
        int sublen = offset - oldOffset;
        long lengthHeader = this._response.getContentLengthHeader();
        if (lengthHeader > 0L && lengthHeader < (long)(this._contentLength + sublen)) {
            nextBuffer = this.getNextBuffer();
            this.lengthException(nextBuffer, oldOffset, sublen, lengthHeader);
            sublen = (int)(lengthHeader - (long)this._contentLength);
            offset = oldOffset + sublen;
        }
        this._contentLength += sublen;
        if (this._cacheStream != null) {
            nextBuffer = this.getNextBuffer();
            this.writeCache(nextBuffer, oldOffset, sublen);
        }
        if (!this.isHead()) {
            this.setNextBufferOffset(offset);
        }
    }

    public final byte[] nextBuffer(int offset) throws IOException {
        if (!this.isCommitted()) {
            return super.nextBuffer(offset);
        }
        if (this.isClosed()) {
            return this.getNextBuffer();
        }
        this.flushBuffer();
        byte[] nextBuffer = this.getNextBuffer();
        int startOffset = this.getNextStartOffset();
        int oldOffset = this.getNextBufferOffset();
        int sublen = offset - oldOffset;
        long lengthHeader = this._response.getContentLengthHeader();
        if (lengthHeader > 0L && lengthHeader < (long)(this._contentLength + sublen)) {
            this.lengthException(nextBuffer, startOffset, sublen, lengthHeader);
            sublen = (int)(lengthHeader - (long)this._contentLength);
        }
        this._contentLength += sublen;
        offset = oldOffset + sublen;
        try {
            if (this.isHead()) {
                return nextBuffer;
            }
            if (this._cacheStream != null) {
                this.writeCache(nextBuffer, oldOffset, sublen);
            }
            return this.writeNextBuffer(offset);
        }
        catch (ClientDisconnectException e) {
            this._response.clientDisconnect();
            if (this._response.isIgnoreClientDisconnect()) {
                return nextBuffer;
            }
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    protected void writeNext(byte[] buf, int offset, int length, boolean isFinished) throws IOException {
        block14: {
            try {
                if (this.isClosed()) {
                    return;
                }
                if (this._isDisableAutoFlush && !isFinished) {
                    throw new IOException(L.l("auto-flushing has been disabled"));
                }
                int bufferOffset = this.getNextBufferOffset();
                if (length == 0 && bufferOffset == 0) {
                    return;
                }
                int bufferStart = this.getNextStartOffset();
                if (length == 0 && bufferStart == bufferOffset) {
                    return;
                }
                long contentLengthHeader = this._response.getContentLengthHeader();
                if (0L < contentLengthHeader && contentLengthHeader < (long)(length + this._contentLength)) {
                    if (this.lengthException(buf, offset, length, contentLengthHeader)) {
                        return;
                    }
                    length = (int)(contentLengthHeader - (long)this._contentLength);
                }
                if (this.isHead()) {
                    return;
                }
                if (this._cacheStream != null) {
                    this.writeCache(buf, offset, length);
                }
                byte[] buffer = this.getNextBuffer();
                int writeLength = length;
                while (writeLength > 0) {
                    int sublen = buffer.length - bufferOffset;
                    if (writeLength < sublen) {
                        sublen = writeLength;
                    }
                    System.arraycopy(buf, offset, buffer, bufferOffset, sublen);
                    offset += sublen;
                    bufferOffset += sublen;
                    this._contentLength += sublen - bufferStart;
                    if ((writeLength -= sublen) <= 0) continue;
                    buffer = this.writeNextBuffer(bufferOffset);
                    bufferOffset = bufferStart = this.getNextStartOffset();
                }
                if (bufferOffset < buffer.length) {
                    this.setNextBufferOffset(bufferOffset);
                } else {
                    this.writeNextBuffer(bufferOffset);
                }
            }
            catch (ClientDisconnectException e) {
                this._response.clientDisconnect();
                if (this._response.isIgnoreClientDisconnect()) break block14;
                throw e;
            }
        }
    }

    private boolean lengthException(byte[] buf, int offset, int length, long contentLengthHeader) {
        if (!(this._response.isClientDisconnect() || this.isHead() || this.isClosed() || contentLengthHeader >= (long)this._contentLength)) {
            AbstractHttpRequest request = this._response.getRequest();
            String msg = L.l("{0}: Can't write {1} extra bytes beyond the content-length header {2}.  Check that the Content-Length header correctly matches the expected bytes, and ensure that any filter which modifies the content also suppresses the content-length (to use chunked encoding).", request.getRequestURL(), "" + (length + this._contentLength), "" + contentLengthHeader);
            log.fine(msg);
            return false;
        }
        for (int i = (int)((long)offset + contentLengthHeader - (long)this._contentLength); i < offset + length; ++i) {
            byte ch = buf[i];
            if (ch == 13 || ch == 10 || ch == 32 || ch == 9) continue;
            AbstractHttpRequest request = this._response.getRequest();
            String graph = "";
            if (Character.isLetterOrDigit((char)ch)) {
                graph = "'" + (char)ch + "', ";
            }
            String msg = L.l("{0}: tried to write {1} bytes with content-length {2} (At {3}char={4}).  Check that the Content-Length header correctly matches the expected bytes, and ensure that any filter which modifies the content also suppresses the content-length (to use chunked encoding).", request.getRequestURL(), "" + (length + this._contentLength), "" + contentLengthHeader, graph, "" + ch);
            log.fine(msg);
            break;
        }
        return (length = (int)(contentLengthHeader - (long)this._contentLength)) <= 0;
    }

    public void flush() throws IOException {
        block4: {
            try {
                this._isDisableAutoFlush = false;
                if (this._isAllowFlush && !this.isClosed()) {
                    int bufferStart;
                    this.flushBuffer();
                    int bufferOffset = this.getNextBufferOffset();
                    if (bufferOffset > 0 && (bufferStart = this.getNextStartOffset()) != bufferOffset) {
                        this.writeNextBuffer(bufferOffset);
                    }
                    this.flushNext();
                }
            }
            catch (ClientDisconnectException e) {
                this._response.clientDisconnect();
                if (this._response.isIgnoreClientDisconnect()) break block4;
                throw e;
            }
        }
    }

    public void flushByte() throws IOException {
        this.flush();
    }

    public void flushChar() throws IOException {
        this.flush();
    }

    protected void closeImpl() throws IOException {
        block3: {
            try {
                this._isDisableAutoFlush = false;
                this.flushCharBuffer();
                this._isAllowFlush = true;
                this.flushBuffer();
                if (!this._response.isHeaderWritten()) {
                    this.writeHeaders(-1);
                }
                this.writeTail(true);
                this.finishCache();
                this.closeNext();
            }
            catch (ClientDisconnectException e) {
                this._response.clientDisconnect();
                if (this._response.isIgnoreClientDisconnect()) break block3;
                throw e;
            }
        }
    }

    protected abstract byte[] getNextBuffer();

    protected int getNextStartOffset() {
        return 0;
    }

    protected abstract void setNextBufferOffset(int var1) throws IOException;

    protected abstract int getNextBufferOffset() throws IOException;

    protected abstract byte[] writeNextBuffer(int var1) throws IOException;

    public abstract void flushNext() throws IOException;

    protected abstract void closeNext() throws IOException;

    protected void clearNext() {
    }

    protected void writeTail(boolean isClosed) throws IOException {
    }

    protected void startCaching(boolean isByte) {
        int contentLength;
        String charEncoding;
        String contentType;
        ArrayList<String> values;
        ArrayList<String> keys;
        HttpServletResponseImpl res = this._response.getRequest().getResponseFacade();
        if (res == null || res.getStatus() != 200 || res.isDisableCache()) {
            return;
        }
        if (this._cacheInvocation != null) {
            return;
        }
        AbstractCacheFilterChain cacheInvocation = res.getCacheInvocation();
        if (cacheInvocation == null) {
            return;
        }
        this._cacheInvocation = cacheInvocation;
        HttpServletRequestImpl req = this._response.getRequest().getRequestFacade();
        AbstractCacheEntry newCacheEntry = cacheInvocation.startCaching(req, res, keys = res.getHeaderKeys(), values = res.getHeaderValues(), contentType = res.getContentTypeImpl(), charEncoding = res.getCharacterEncodingImpl(), contentLength = -1);
        if (newCacheEntry != null) {
            if (isByte) {
                this._newCacheEntry = newCacheEntry;
                this.setByteCacheStream(newCacheEntry.openOutputStream());
            } else {
                this._newCacheEntry = newCacheEntry;
                this.setCharCacheStream(newCacheEntry.openWriter());
            }
        }
    }

    private void writeCache(byte[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this._cacheMaxLength < (long)this._contentLength) {
            this._cacheStream = null;
        } else {
            this._cacheStream.write(buf, offset, length);
        }
    }

    public void killCaching() {
        AbstractCacheEntry cacheEntry = this._newCacheEntry;
        this._newCacheEntry = null;
        if (cacheEntry != null) {
            this._cacheInvocation.killCaching(cacheEntry);
            this.setByteCacheStream(null);
            this.setCharCacheStream(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCache() throws IOException {
        block8: {
            try {
                OutputStream cacheStream = this.getByteCacheStream();
                this.setByteCacheStream(null);
                Writer cacheWriter = this.getCharCacheStream();
                this.setCharCacheStream(null);
                if (cacheStream != null) {
                    cacheStream.close();
                }
                if (cacheWriter != null) {
                    cacheWriter.close();
                }
                if (this._newCacheEntry == null) break block8;
                HttpServletRequestImpl request = this._response.getRequest().getRequestFacade();
                if (request == null) {
                    Object var7_4 = null;
                    AbstractCacheFilterChain cache = this._cacheInvocation;
                    this._cacheInvocation = null;
                    AbstractCacheEntry cacheEntry = this._newCacheEntry;
                    this._newCacheEntry = null;
                    if (cache != null && cacheEntry != null) {
                        cache.killCaching(cacheEntry);
                    }
                    return;
                }
                WebApp webApp = request.getWebApp();
                if (webApp == null || !webApp.isActive()) break block8;
                AbstractCacheEntry cacheEntry = this._newCacheEntry;
                this._cacheInvocation.finishCaching(cacheEntry);
                this._newCacheEntry = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                AbstractCacheFilterChain cache = this._cacheInvocation;
                this._cacheInvocation = null;
                AbstractCacheEntry cacheEntry = this._newCacheEntry;
                this._newCacheEntry = null;
                if (cache != null && cacheEntry != null) {
                    cache.killCaching(cacheEntry);
                }
                throw throwable;
            }
        }
        Object var7_5 = null;
        AbstractCacheFilterChain cache = this._cacheInvocation;
        this._cacheInvocation = null;
        AbstractCacheEntry cacheEntry = this._newCacheEntry;
        this._newCacheEntry = null;
        if (cache != null && cacheEntry != null) {
            cache.killCaching(cacheEntry);
        }
    }

    protected String dbgId() {
        AbstractHttpRequest request = this._response.getRequest();
        if (request instanceof AbstractHttpRequest) {
            AbstractHttpRequest req = request;
            return req.dbgId();
        }
        return "inc ";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._response + "]";
    }
}

