/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.server.http.ToCharResponseStream;
import com.caucho.util.FreeList;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;

public class ToCharResponseAdapter
extends ResponseAdapter {
    private static final Logger log = Logger.getLogger(ToCharResponseAdapter.class.getName());
    private static final FreeList<ToCharResponseAdapter> _freeList = new FreeList(32);
    private ToCharResponseStreamWrapper _responseStream;

    private ToCharResponseAdapter(HttpServletResponse response) {
        super(response);
    }

    public static ToCharResponseAdapter create(HttpServletResponse response) {
        ToCharResponseAdapter resAdapt = _freeList.allocate();
        if (resAdapt == null) {
            resAdapt = new ToCharResponseAdapter(response);
        } else {
            resAdapt.setResponse(response);
        }
        resAdapt.init(response);
        return resAdapt;
    }

    protected AbstractResponseStream createWrapperResponseStream() {
        if (this._responseStream == null) {
            this._responseStream = new ToCharResponseStreamWrapper();
        }
        return this._responseStream;
    }

    public void init(HttpServletResponse response) {
        this._responseStream.start();
        super.init(response);
    }

    public void resetBuffer() {
        this._responseStream.clearBuffer();
        super.resetBuffer();
    }

    public static void free(ToCharResponseAdapter resAdapt) {
        resAdapt.free();
        _freeList.free(resAdapt);
    }

    class ToCharResponseStreamWrapper
    extends ToCharResponseStream {
        ToCharResponseStreamWrapper() {
        }

        public String getEncoding() {
            return ToCharResponseAdapter.this.getResponse().getCharacterEncoding();
        }

        public void flushChar() throws IOException {
            this.flushBuffer();
            ToCharResponseAdapter.this.getResponse().getWriter().flush();
        }

        protected void writeNext(char[] buffer, int offset, int length) throws IOException {
            ToCharResponseAdapter.this.getResponse().getWriter().write(buffer, offset, length);
        }
    }
}

