/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootPodConfig {
    private static final L10N L = new L10N(BootPodConfig.class);
    private BootClusterConfig _clusterConfig;
    private CloudCluster _cloudCluster;
    private CloudPod _cloudPod;
    private String _id;
    private ContainerProgram _serverDefaultProgram = new ContainerProgram();
    private ContainerProgram _podProgram = new ContainerProgram();
    private ArrayList<BootServerConfig> _servers = new ArrayList();

    public BootPodConfig(BootClusterConfig clusterConfig) {
        this._clusterConfig = clusterConfig;
    }

    public String getId() {
        return this._id;
    }

    @Configurable
    public void setId(String id) {
        this._id = id;
    }

    public BootClusterConfig getCluster() {
        return this._clusterConfig;
    }

    @Configurable
    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultProgram.addProgram(program);
    }

    public ContainerProgram getServerDefault() {
        return this._serverDefaultProgram;
    }

    @Configurable
    public BootServerConfig createServer() throws ConfigException {
        BootServerConfig server = new BootServerConfig(this);
        this._servers.add(server);
        return server;
    }

    @Configurable
    public void addServer(BootServerConfig server) {
        this._servers.add(server);
    }

    public ArrayList<BootServerConfig> getServerList() {
        return this._servers;
    }

    public void addContentProgram(ConfigProgram program) {
        this._podProgram.addProgram(program);
    }

    ConfigProgram getProgram() {
        return this._podProgram;
    }

    @PostConstruct
    public void init() {
        CloudPod pod = this.getCloudPod();
        pod.putData(new ClusterServerProgram(this._serverDefaultProgram));
        this.getCloudPod();
    }

    CloudPod getCloudPod() {
        if (this._cloudPod == null) {
            CloudCluster cluster = this._clusterConfig.getCloudCluster();
            this._cloudPod = cluster.createPod();
        }
        return this._cloudPod;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

