/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.topology.CloudSystem;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.DependencyBean;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.BootPodConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.server.resin.Resin;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootResinConfig
implements SchemaBean,
DependencyBean {
    private Resin _resin;
    private ContainerProgram _resinProgram = new ContainerProgram();
    private ArrayList<ConfigProgram> _clusterDefaults = new ArrayList();
    private ArrayList<BootClusterConfig> _clusters = new ArrayList();

    public BootResinConfig(Resin resin) {
        this._resin = resin;
    }

    public CloudSystem getCloudSystem() {
        return this._resin.getCloudSystem();
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/resin/resin.rnc";
    }

    public Path getRootDirectory() {
        return this._resin.getRootDirectory();
    }

    public void setRootDirectory(Path rootDirectory) {
        this._resin.setRootDirectory(rootDirectory);
        Vfs.setPwd(rootDirectory);
    }

    @Configurable
    public void addClusterDefault(ContainerProgram program) {
        this._clusterDefaults.add(program);
    }

    @Configurable
    public BootClusterConfig createCluster() throws ConfigException {
        BootClusterConfig cluster = new BootClusterConfig(this);
        this._clusters.add(cluster);
        for (int i = 0; i < this._clusterDefaults.size(); ++i) {
            this._clusterDefaults.get(i).configure(cluster);
        }
        return cluster;
    }

    public BootClusterConfig findCluster(String id) {
        for (BootClusterConfig cluster : this._clusters) {
            if (!id.equals(cluster.getId())) continue;
            return cluster;
        }
        return null;
    }

    public ArrayList<BootClusterConfig> getClusterList() {
        return this._clusters;
    }

    BootServerConfig findServer(String id) {
        for (BootClusterConfig cluster : this.getClusterList()) {
            for (BootPodConfig pod : cluster.getPodList()) {
                for (BootServerConfig server : pod.getServerList()) {
                    if (!id.equals(server.getId())) continue;
                    return server;
                }
            }
        }
        return null;
    }

    public void addContentProgram(ConfigProgram program) {
        this._resinProgram.addProgram(program);
    }

    public ConfigProgram getProgram() {
        return this._resinProgram;
    }

    @Override
    public void addDependency(PersistentDependency dependency) {
        this._resin.getClassLoader().addDependency(dependency);
    }

    void configureServers() {
    }
}

