/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.ConfigException;
import com.caucho.jmx.Jmx;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class MemoryAdmin
extends AbstractManagedObject
implements MemoryMXBean {
    private final MBeanServer _mbeanServer = Jmx.getGlobalMBeanServer();
    private final ObjectName _codeCacheName;
    private final ObjectName _edenName;
    private final ObjectName _permGenName;
    private final ObjectName _survivorName;
    private final ObjectName _tenuredName;

    private MemoryAdmin() {
        try {
            ObjectName query = new ObjectName("java.lang:type=MemoryPool,*");
            ObjectName codeCacheName = new ObjectName("java.lang:type=MemoryPool,name=Code Cache");
            ObjectName edenName = new ObjectName("java.lang:type=MemoryPool,name=Eden Space");
            ObjectName permGenName = new ObjectName("java.lang:type=MemoryPool,name=Perm Gen");
            ObjectName survivorName = new ObjectName("java.lang:type=MemoryPool,name=Survivor Space");
            ObjectName tenuredName = new ObjectName("java.lang:type=MemoryPool,name=Tenured Gen");
            for (ObjectName objName : this._mbeanServer.queryNames(query, null)) {
                String name = objName.getKeyProperty("name");
                if (name.toLowerCase().contains("code")) {
                    codeCacheName = objName;
                    continue;
                }
                if (name.toLowerCase().contains("eden")) {
                    edenName = objName;
                    continue;
                }
                if (name.toLowerCase().contains("perm")) {
                    permGenName = objName;
                    continue;
                }
                if (name.toLowerCase().contains("surv")) {
                    survivorName = objName;
                    continue;
                }
                if (name.toLowerCase().contains("tenured")) {
                    tenuredName = objName;
                    continue;
                }
                if (!name.toLowerCase().contains("old")) continue;
                tenuredName = objName;
            }
            this._codeCacheName = codeCacheName;
            this._edenName = edenName;
            this._permGenName = permGenName;
            this._survivorName = survivorName;
            this._tenuredName = tenuredName;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        this.registerSelf();
    }

    static MemoryAdmin create() {
        return new MemoryAdmin();
    }

    public String getName() {
        return null;
    }

    public long getCodeCacheCommitted() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._codeCacheName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getCommitted();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getCodeCacheMax() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._codeCacheName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getCodeCacheUsed() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._codeCacheName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getCodeCacheFree() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._codeCacheName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax() - usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getEdenCommitted() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._edenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getCommitted();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getEdenMax() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._edenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getEdenUsed() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._edenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getEdenFree() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._edenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax() - usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getPermGenCommitted() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._permGenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getCommitted();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getPermGenMax() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._permGenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getPermGenUsed() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._permGenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getPermGenFree() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._permGenName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax() - usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getSurvivorCommitted() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._survivorName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getCommitted();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getSurvivorMax() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._survivorName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getSurvivorUsed() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._survivorName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getSurvivorFree() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._survivorName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax() - usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getTenuredCommitted() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._tenuredName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getCommitted();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getTenuredMax() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._tenuredName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getTenuredUsed() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._tenuredName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getTenuredFree() {
        try {
            CompositeData data = (CompositeData)this._mbeanServer.getAttribute(this._tenuredName, "Usage");
            MemoryUsage usage = MemoryUsage.from(data);
            return usage.getMax() - usage.getUsed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

