/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.bam.Broker;
import com.caucho.cloud.bam.BamService;
import com.caucho.cloud.loadbalance.LoadBalanceFactory;
import com.caucho.cloud.loadbalance.LoadBalanceService;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.NetworkClusterService;
import com.caucho.cloud.network.NetworkListenService;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.functions.FmtFunctions;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.WebBeansAddLoaderListener;
import com.caucho.config.lib.ResinConfigLibrary;
import com.caucho.config.program.ConfigProgram;
import com.caucho.ejb.manager.EjbEnvironmentListener;
import com.caucho.env.distcache.DistCacheService;
import com.caucho.env.jpa.ListenerPersistenceEnvironment;
import com.caucho.env.lock.LockService;
import com.caucho.env.lock.SingleLockManager;
import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.LocalRepositoryService;
import com.caucho.env.repository.RepositoryService;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectoryService;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownService;
import com.caucho.java.WorkDir;
import com.caucho.license.LicenseCheck;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.naming.Jndi;
import com.caucho.server.admin.Management;
import com.caucho.server.cluster.ClusterPod;
import com.caucho.server.cluster.Server;
import com.caucho.server.cluster.ServerConfig;
import com.caucho.server.cluster.ServletContainerConfig;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.distcache.FileCacheManager;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.BootResinConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.server.resin.MemoryAdmin;
import com.caucho.server.resin.ResinAdmin;
import com.caucho.server.resin.ResinArgs;
import com.caucho.server.resin.ResinConfig;
import com.caucho.server.resin.ResinURLStreamHandlerFactory;
import com.caucho.server.resin.ResinWaitForExitService;
import com.caucho.server.resin.ThreadPoolAdmin;
import com.caucho.server.webbeans.ResinCdiProducer;
import com.caucho.util.Alarm;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.ObjectName;

public class Resin {
    private static Logger _log;
    private static L10N _L;
    public static final int EXIT_OK = 0;
    private static final EnvironmentLocal<Resin> _resinLocal;
    private final EnvironmentLocal<String> _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    private boolean _isEmbedded;
    private String _serverId = "default";
    private final boolean _isWatchdog;
    private ResinArgs _args;
    private Path _resinHome;
    private Path _rootDirectory;
    private Path _resinDataDirectory;
    private final ResinSystem _resinSystem;
    private long _shutdownWaitMax = 60000L;
    private Lifecycle _lifecycle;
    private BootResinConfig _bootResinConfig;
    private CloudServer _selfServer;
    private ServletContainerConfig _servletContainerConfig;
    private Server _servletContainer;
    private long _initialStartTime;
    private long _startTime = Alarm.getCurrentTime();
    private String _licenseErrorMessage;
    private Path _resinConf;
    private ClassLoader _systemClassLoader;
    private Thread _mainThread;
    protected Management _management;
    private ThreadPoolAdmin _threadPoolAdmin;
    private ObjectName _objectName;
    private ResinAdmin _resinAdmin;
    private InputStream _waitIn;
    private Socket _pingSocket;
    private ResinWaitForExitService _waitForExitService;
    private String _stage = null;

    protected Resin(ResinSystem system, boolean isWatchdog) {
        this(system, isWatchdog, null);
    }

    protected Resin(ResinSystem system, boolean isWatchdog, String licenseErrorMessage) {
        this._isWatchdog = isWatchdog;
        this._licenseErrorMessage = licenseErrorMessage;
        Environment.init();
        this._resinSystem = system;
        this.initEnvironment();
        try {
            URL.setURLStreamHandlerFactory(new ResinURLStreamHandlerFactory());
        }
        catch (Error e) {
            // empty catch block
        }
    }

    public static Resin create(String id) {
        ResinSystem system = new ResinSystem(id);
        return Resin.create(system, false);
    }

    public static Resin createWatchdog(ResinSystem system) {
        Resin resin = Resin.create(system, true);
        return resin;
    }

    public static Resin create(ResinSystem system, boolean isWatchdog) {
        Class<?> cl;
        String licenseErrorMessage = null;
        Resin resin = null;
        try {
            cl = Class.forName("com.caucho.server.resin.ProResin");
            Constructor<?> ctor = cl.getConstructor(ResinSystem.class, Boolean.TYPE);
            resin = (Resin)ctor.newInstance(system, isWatchdog);
        }
        catch (ConfigException e) {
            Resin.log().log(Level.FINER, e.toString(), e);
            licenseErrorMessage = e.getMessage();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Resin.log().log(Level.FINER, cause.toString(), cause);
            licenseErrorMessage = cause instanceof ConfigException ? cause.getMessage() : Resin.L().l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional,\n  including caching, clustering, JNI acceleration, and OpenSSL integration.\n\n  Exception=" + cause + "\n");
        }
        catch (Throwable e) {
            String msg;
            Resin.log().log(Level.FINER, e.toString(), e);
            String causeMsg = "";
            if (!(e instanceof ClassNotFoundException)) {
                causeMsg = "\n  Exception=" + e + "\n";
            }
            licenseErrorMessage = msg = Resin.L().l("  Using Resin(R) Open Source under the GNU Public License (GPL).\n\n  See http://www.caucho.com for information on Resin Professional,\n  including caching, clustering, JNI acceleration, and OpenSSL integration.\n" + causeMsg);
        }
        if (resin == null) {
            try {
                cl = Class.forName("com.caucho.license.LicenseCheckImpl");
                LicenseCheck license = (LicenseCheck)cl.newInstance();
                license.requirePersonal(1);
                licenseErrorMessage = license.doLogging();
            }
            catch (ConfigException e) {
                licenseErrorMessage = e.getMessage();
            }
            catch (Throwable e) {
                // empty catch block
            }
            resin = new Resin(system, isWatchdog, licenseErrorMessage);
        }
        _resinLocal.set(resin, system.getClassLoader());
        return resin;
    }

    public static Resin createOpenSource(String id) {
        ResinSystem system = new ResinSystem(id);
        return Resin.createOpenSource(system);
    }

    public static Resin createOpenSource(ResinSystem system) {
        return new Resin(system, false, null);
    }

    public static Resin getLocal() {
        return _resinLocal.get();
    }

    public static Resin getCurrent() {
        return Resin.getLocal();
    }

    public ResinSystem getResinSystem() {
        return this._resinSystem;
    }

    public CloudSystem getCloudSystem() {
        ResinSystem resinSystem = this._resinSystem;
        if (resinSystem != null) {
            return resinSystem.getService(TopologyService.class).getSystem();
        }
        return null;
    }

    public void setRootDirectory(Path path) {
        this._rootDirectory = path;
    }

    public void setPingSocket(Socket socket) {
        this._pingSocket = socket;
    }

    public void setStage(String stage) {
        this._stage = stage;
    }

    public void setEmbedded(boolean isEmbedded) {
        this._isEmbedded = isEmbedded;
    }

    private void initEnvironment() {
        String resinHome = System.getProperty("resin.home");
        this._resinHome = resinHome != null ? Vfs.lookup(resinHome) : Vfs.getPwd();
        this._rootDirectory = this._resinHome;
        String resinRoot = System.getProperty("server.root");
        if (resinRoot != null) {
            this._rootDirectory = Vfs.lookup(resinRoot);
        }
        if ((resinRoot = System.getProperty("resin.root")) != null) {
            this._rootDirectory = Vfs.lookup(resinRoot);
        }
    }

    public void preConfigureInit() {
        if (this._lifecycle != null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            _resinLocal.set(this, this.getClassLoader());
            this._lifecycle = new Lifecycle(Resin.log(), "Resin[]");
            if (this._args != null) {
                this.setServerId(this._args.getServerId());
                if (this._rootDirectory == null) {
                    this.setRootDirectory(this._args.getRootDirectory());
                }
                this._pingSocket = this._args.getPingSocket();
            }
            if (this.getRootDirectory() == null) {
                throw new NullPointerException();
            }
            this.addPreTopologyServices();
            this._bootResinConfig = new BootResinConfig(this);
            Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
            Environment.addChildLoaderListener(new WebBeansAddLoaderListener());
            Environment.addChildLoaderListener(new EjbEnvironmentListener());
            InjectManager cdiManager = InjectManager.create();
            Config.setProperty("resinHome", this.getResinHome());
            Config.setProperty("resin", new Var());
            Config.setProperty("server", new Var());
            Config.setProperty("java", new JavaVar());
            Config.setProperty("system", System.getProperties());
            Config.setProperty("getenv", System.getenv());
            if (cdiManager.getBeans((Type)((Object)ResinCdiProducer.class), new Annotation[0]).size() == 0) {
                Config.setProperty("fmt", new FmtFunctions());
                ResinConfigLibrary.configure(cdiManager);
                try {
                    Method method = Jndi.class.getMethod("lookup", String.class);
                    Config.setProperty("jndi", method);
                    Config.setProperty("jndi:lookup", method);
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
                cdiManager.addManagedBean(cdiManager.createManagedBean(ResinCdiProducer.class));
                Class<?> resinValidatorClass = ResinCdiProducer.createResinValidatorProducer();
                if (resinValidatorClass != null) {
                    cdiManager.addManagedBean(cdiManager.createManagedBean(resinValidatorClass));
                }
                cdiManager.update();
            }
            this._threadPoolAdmin = ThreadPoolAdmin.create();
            this._resinAdmin = new ResinAdmin(this);
            this._threadPoolAdmin.register();
            MemoryAdmin.create();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void addPreTopologyServices() {
        ShutdownService shutdown = new ShutdownService(this._resinSystem, this._isEmbedded);
        this._resinSystem.addService(shutdown);
        TopologyService topology = new TopologyService(this._resinSystem.getId());
        this._resinSystem.addService(topology);
        topology.getSystem();
        DistCacheService distCache = this.createDistCacheService();
        this._resinSystem.addService(DistCacheService.class, distCache);
    }

    protected void addServices() {
        LockService lockService = this.createLockService();
        this._resinSystem.addService(LockService.class, lockService);
    }

    protected DistCacheService createDistCacheService() {
        return new DistCacheService(new FileCacheManager(this.getResinSystem()));
    }

    protected LockService createLockService() {
        return new LockService(new SingleLockManager());
    }

    private void setArgs(ResinArgs args) {
        this._args = args;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._resinSystem.getClassLoader();
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public ResinMXBean getAdmin() {
        return this._resinAdmin;
    }

    public Broker getAdminBroker() {
        return this._management.getAdminBroker();
    }

    public ThreadPoolMXBean getThreadPoolAdmin() {
        return this._threadPoolAdmin;
    }

    protected String getLicenseMessage() {
        return null;
    }

    protected String getLicenseErrorMessage() {
        return this._licenseErrorMessage;
    }

    public void setServerId(String serverId) {
        if ("".equals(serverId)) {
            serverId = "default";
        }
        Config.setProperty("serverId", serverId);
        this._serverId = serverId;
        this._serverIdLocal.set(serverId);
    }

    public String getServerId() {
        return this._serverId;
    }

    public boolean isResinServer() {
        return !this._isWatchdog;
    }

    public boolean isWatchdog() {
        return this._isWatchdog;
    }

    public String getUniqueServerName() {
        String name = this._isWatchdog ? this._serverId + "_watchdog" : this._serverId;
        name = name.replace('-', '_');
        return name;
    }

    public static String getCurrentServerId() {
        Resin resin = Resin.getCurrent();
        if (resin != null) {
            return resin.getServerId();
        }
        return "";
    }

    public void setDynamicServer(String clusterId, String address, int port) {
        String id = address + ":" + port;
        if (this._serverId == null) {
            this.setServerId(id);
        }
    }

    public String getDisplayServerId() {
        if ("".equals(this._serverId)) {
            return "default";
        }
        return this._serverId;
    }

    public void setConfigFile(String configFile) {
    }

    public void setResinHome(Path home) {
        this._resinHome = home;
    }

    public Path getResinHome() {
        return this._resinHome;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public Path getResinDataDirectory() {
        Path path = this._resinDataDirectory != null ? this._resinDataDirectory : (this._isWatchdog ? this.getRootDirectory().lookup("watchdog-data") : this.getRootDirectory().lookup("resin-data"));
        if (path instanceof MemoryPath) {
            path = WorkDir.getTmpWorkDir().lookup("qa/resin-data");
        }
        return path;
    }

    public void setAdminPath(Path path) {
    }

    public Path getResinConf() {
        return this._resinConf;
    }

    protected String getResinName() {
        return "Resin";
    }

    public boolean isProfessional() {
        return false;
    }

    public long getShutdownWaitMax() {
        return this._shutdownWaitMax;
    }

    public void setShutdownWaitTime(long shutdownTime) {
        this._shutdownWaitMax = shutdownTime;
    }

    public ClusterMXBean[] getClusters() {
        throw new UnsupportedOperationException();
    }

    void setInitialStartTime(long now) {
        this._initialStartTime = now;
    }

    public Date getInitialStartTime() {
        return new Date(this._initialStartTime);
    }

    public Date getStartTime() {
        return new Date(this._startTime);
    }

    public LifecycleState getLifecycleState() {
        return this._lifecycle.getState();
    }

    @PostConstruct
    public void init() {
        this.preConfigureInit();
        this._lifecycle.toInit();
    }

    public Server getServer() {
        return this._servletContainer;
    }

    public Management getManagement() {
        return this._management;
    }

    public double getCpuLoad() {
        return 0.0;
    }

    public CloudServer getSelfServer() {
        return this._selfServer;
    }

    public Server createServer() {
        if (this._servletContainer == null) {
            this.configure();
        }
        return this._servletContainer;
    }

    protected ClusterServer loadDynamicServer(ClusterPod pod, String dynId, String dynAddress, int dynPort) {
        throw new ConfigException(Resin.L().l("dynamic-server requires Resin Professional"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.preConfigureInit();
        if (!this._lifecycle.toActive()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            System.gc();
            this._servletContainer = this.createServer();
            NetworkListenService listenService = this._resinSystem.getService(NetworkListenService.class);
            if (this._args != null) {
                for (ResinArgs.BoundPort port : this._args.getBoundPortList()) {
                    listenService.bind(port.getAddress(), port.getPort(), port.getServerSocket());
                }
            }
            this._resinSystem.start();
            Resin.log().severe(this + " started in " + (Alarm.getExactTime() - this._startTime) + "ms");
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void initRepository() {
        LocalRepositoryService localRepositoryService = new LocalRepositoryService();
        RepositorySpi localRepository = localRepositoryService.getRepositorySpi();
        this._resinSystem.addService(localRepositoryService);
        AbstractRepository repository = this.createRepository(localRepository);
        this._resinSystem.addService(new RepositoryService(repository));
    }

    protected AbstractRepository createRepository(RepositorySpi localRepository) {
        return (AbstractRepository)localRepository;
    }

    public void stop() {
        this._resinSystem.stop();
    }

    public void dumpThreads() {
    }

    public boolean isActive() {
        return this._resinSystem.isActive();
    }

    public boolean isClosing() {
        return this._lifecycle.isDestroying();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    public void destroy() {
        this._resinSystem.destroy();
    }

    public void initMain() throws Throwable {
        String licenseErrorMessage;
        this._mainThread = Thread.currentThread();
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        this.preConfigureInit();
        this.addRandom();
        System.out.println(VersionFactory.getFullVersion());
        System.out.println(VersionFactory.getCopyright());
        System.out.println();
        String licenseMessage = this.getLicenseMessage();
        if (licenseMessage != null) {
            Resin.log().warning(licenseMessage);
            System.out.println(licenseMessage);
        }
        if ((licenseErrorMessage = this.getLicenseErrorMessage()) != null) {
            Resin.log().warning(licenseErrorMessage);
            System.err.println(licenseErrorMessage);
        }
        System.out.println("Starting " + this.getResinName() + " on " + QDate.formatLocal(this._startTime));
        System.out.println();
        Environment.init();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(this._systemClassLoader);
        if (this._rootDirectory == null) {
            this._rootDirectory = this._resinHome;
        }
        this.configure();
        this.start();
    }

    private void configure() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            if (this._servletContainer == null) {
                BootResinConfig bootResin = this.configureBoot();
                this._rootDirectory = bootResin.getRootDirectory();
                this.configureRoot(bootResin);
                this.configureServer();
                if (!this.isWatchdog()) {
                    this.addServices();
                }
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private BootResinConfig configureBoot() {
        Vfs.setPwd(this._rootDirectory);
        Path resinConf = null;
        if (this._args != null) {
            resinConf = this._args.getResinConfPath();
        }
        this._resinConf = resinConf;
        Vfs.setPwd(this.getRootDirectory());
        if (resinConf != null) {
            this.configureFile(resinConf);
        }
        return this._bootResinConfig;
    }

    public void configureFile(Path resinConf) {
        BootResinConfig bootResin = this._bootResinConfig;
        Config config = new Config();
        config.configure((Object)bootResin, resinConf, bootResin.getSchema());
    }

    public void configureProgram(ConfigProgram program) {
        program.configure(this._bootResinConfig);
    }

    private void configureRoot(BootResinConfig bootConfig) throws IOException {
        Path dataDirectory = this.isWatchdog() ? this._rootDirectory.lookup("watchdog-data") : this._rootDirectory.lookup("resin-data");
        String serverName = this._serverId;
        if (serverName == null || serverName.isEmpty()) {
            serverName = "default";
        }
        dataDirectory = dataDirectory.lookup("./" + serverName);
        RootDirectoryService rootService = new RootDirectoryService(this._rootDirectory, dataDirectory);
        this._resinSystem.addService(rootService);
    }

    private void configureServer() throws IOException {
        if (this._servletContainer != null) {
            return;
        }
        BootResinConfig bootResin = this._bootResinConfig;
        bootResin.configureServers();
        BootServerConfig bootServer = bootResin.findServer(this._serverId);
        if (bootServer == null) {
            BootClusterConfig clusterConfig = bootResin.findCluster("");
            if (clusterConfig == null) {
                if (bootResin.getClusterList().size() == 0) {
                    clusterConfig = bootResin.createCluster();
                    clusterConfig.setId("");
                    clusterConfig.init();
                } else {
                    throw new ConfigException(Resin.L().l("'{0}' is an unknown server in the configuration file.", this._serverId));
                }
            }
            bootServer = clusterConfig.createServer();
            bootServer.setId("");
            bootServer.init();
            clusterConfig.addServer(bootServer);
        }
        this._selfServer = bootServer.getCloudServer();
        NetworkClusterService networkService = new NetworkClusterService(this._selfServer);
        this._resinSystem.addService(networkService);
        ClusterServer server = this._selfServer.getData(ClusterServer.class);
        LoadBalanceService loadBalanceService = new LoadBalanceService(this.createLoadBalanceFactory());
        this._resinSystem.addService(loadBalanceService);
        BamService bamService = new BamService(server.getBamAdminName());
        this._resinSystem.addService(bamService);
        this.initRepository();
        this._servletContainer = this.createServer(networkService);
        if (this._stage != null) {
            this._servletContainer.setStage(this._stage);
        }
        NetworkListenService listenService = new NetworkListenService(this._selfServer);
        this._resinSystem.addService(listenService);
        ServletService servletService = new ServletService(this._servletContainer);
        this._resinSystem.addService(servletService);
        ResinConfig resinConfig = new ResinConfig(this);
        bootResin.getProgram().configure(resinConfig);
        this._servletContainerConfig = new ServletContainerConfig(this._servletContainer);
        bootServer.getPod().getCluster().getProgram().configure(this._servletContainerConfig);
        ServerConfig config = new ServerConfig(this._servletContainerConfig);
        bootServer.getServerProgram().configure(config);
        this._servletContainerConfig.init();
        this._servletContainer.init();
    }

    protected ServletContainerConfig getServletContainerConfig() {
        return this._servletContainerConfig;
    }

    protected LoadBalanceFactory createLoadBalanceFactory() {
        return new LoadBalanceFactory();
    }

    protected Server createServer(NetworkClusterService clusterService) {
        return new Server(this, this._resinSystem, clusterService);
    }

    public Management createResinManagement() {
        return new Management(this);
    }

    private void addRandom() {
    }

    public void dumpHeapOnExit() {
    }

    public void waitForExit() throws IOException {
        this._waitForExitService = new ResinWaitForExitService(this, this._resinSystem, this._waitIn, this._pingSocket);
        this._waitForExitService.startResinActor();
        this._waitForExitService.waitForExit();
    }

    public void close() {
        Resin.log().info("Resin closed from the embedded server");
        this._resinSystem.destroy();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._serverId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            Environment.init();
            Resin.validateEnvironment();
            ResinArgs args = new ResinArgs(argv);
            ResinSystem system = new ResinSystem(args.getServerId());
            Resin resin = Resin.create(system, false);
            resin.setArgs(args);
            resin.initMain();
            resin.getServer();
            resin.waitForExit();
            ShutdownService.shutdownActive(ExitCode.OK, "Resin shutdown from watchdog exit");
        }
        catch (Throwable e) {
            Throwable cause;
            for (cause = e; cause != null && cause.getCause() != null && !(cause instanceof CompileException); cause = cause.getCause()) {
            }
            if (cause instanceof BindException) {
                System.err.println(e.getMessage());
                Resin.log().severe(e.toString());
                Resin.log().log(Level.FINE, e.toString(), e);
                System.exit(ExitCode.BIND.ordinal());
            } else if (e instanceof CompileException) {
                System.err.println(e.getMessage());
                Resin.log().log(Level.CONFIG, e.toString(), e);
            } else {
                e.printStackTrace(System.err);
            }
        }
        finally {
            System.exit(ExitCode.BAD_CONFIG.ordinal());
        }
    }

    private static void validateEnvironment() throws ConfigException {
        String loggingManager = System.getProperty("java.util.logging.manager");
        if (loggingManager == null || !loggingManager.equals("com.caucho.log.LogManagerImpl")) {
            Resin.log().warning(Resin.L().l("The following system property must be set:\n  -Djava.util.logging.manager=com.caucho.log.LogManagerImpl\nThe JDK 1.4 Logging manager must be set to Resin's log manager."));
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(Resin.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(Resin.class.getName());
        }
        return _log;
    }

    static {
        _resinLocal = new EnvironmentLocal();
    }

    public class JavaVar {
        public boolean isJava5() {
            return true;
        }

        public Properties getProperties() {
            return System.getProperties();
        }

        public String getUserName() {
            return System.getProperty("user.name");
        }

        public String getVersion() {
            return System.getProperty("java.version");
        }

        public Path getHome() {
            return Vfs.lookup(System.getProperty("java.home"));
        }
    }

    public class Var {
        public String getId() {
            return Resin.this._serverId;
        }

        public String getAddress() {
            try {
                if (Resin.this._selfServer != null) {
                    return Resin.this._selfServer.getAddress();
                }
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                Resin.log().log(Level.FINE, e.toString(), e);
                return "localhost";
            }
        }

        public int getPort() {
            if (Resin.this._selfServer != null) {
                return Resin.this._selfServer.getPort();
            }
            return 0;
        }

        public String getHttpAddress() {
            return this.getAddress();
        }

        public String getHttpsAddress() {
            return this.getAddress();
        }

        public int getHttpPort() {
            return 0;
        }

        public int getHttpsPort() {
            return 0;
        }

        public Path getConf() {
            if (Alarm.isTest()) {
                return Vfs.lookup("file:/home/resin/conf/resin.xml");
            }
            return Resin.this.getResinConf();
        }

        public Path getHome() {
            if (Alarm.isTest()) {
                return Vfs.lookup("file:/home/resin");
            }
            return Resin.this.getResinHome();
        }

        public Path getRoot() {
            return Resin.this.getRootDirectory();
        }

        public String getUserName() {
            return System.getProperty("user.name");
        }

        public String getVersion() {
            if (Alarm.isTest()) {
                return "3.1.test";
            }
            return VersionFactory.getVersion();
        }

        public String getVersionDate() {
            if (Alarm.isTest()) {
                return "19980508T0251";
            }
            return VersionFactory.getVersionDate();
        }

        public String getHostName() {
            try {
                if (Alarm.isTest()) {
                    return "localhost";
                }
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                Resin.log().log(Level.FINE, e.toString(), e);
                return "localhost";
            }
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public boolean isProfessional() {
            return Resin.this.isProfessional();
        }

        public String getServerId() {
            return Resin.this._serverId;
        }
    }
}

