/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.bam.ActorError;
import com.caucho.bam.QueryGet;
import com.caucho.bam.QuerySet;
import com.caucho.bam.SimpleActor;
import com.caucho.boot.PidQuery;
import com.caucho.boot.WatchdogStopQuery;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownService;
import com.caucho.jmx.Jmx;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.WarningMessage;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ResinActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(ResinActor.class.getName());
    private static final L10N L = new L10N(ResinActor.class);
    private Resin _resin;
    private ShutdownService _shutdown;

    ResinActor(Resin resin) {
        this._resin = resin;
        this.setJid("resin");
        this._shutdown = ShutdownService.getCurrent();
        if (this._shutdown == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}.", (Object)this, ShutdownService.class.getSimpleName()));
        }
    }

    public void sendWarning(String msg) {
        this.getLinkStream().message("watchdog", this.getJid(), new WarningMessage(msg));
    }

    @QueryGet
    public void queryPid(long id, String to, String from, PidQuery query) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " " + query);
        }
        try {
            MBeanServer server = Jmx.getGlobalMBeanServer();
            ObjectName objName = new ObjectName("java.lang:type=Runtime");
            String runtimeName = (String)server.getAttribute(objName, "Name");
            if (runtimeName == null) {
                this.getLinkStream().queryError(id, from, to, query, new ActorError("null runtime name"));
                return;
            }
            int p = runtimeName.indexOf(64);
            if (p > 0) {
                int pid = Integer.parseInt(runtimeName.substring(0, p));
                this.getLinkStream().queryResult(id, from, to, new PidQuery(pid));
                return;
            }
            this.getLinkStream().queryError(id, from, to, query, new ActorError("malformed name=" + runtimeName));
        }
        catch (Exception e) {
            this.getLinkStream().queryError(id, from, to, query, ActorError.create(e));
        }
    }

    @QuerySet
    public void stop(long id, String to, String from, WatchdogStopQuery query) {
        log.info(this._resin + " stop request from watchdog '" + from + "'");
        String msg = L.l("Resin shutdown from watchdog stop '" + from + "'");
        this.getLinkStream().queryResult(id, from, to, query);
        ShutdownService.shutdownActive(ExitCode.OK, msg);
    }

    public void destroy() {
        String msg = L.l("Resin shutdown from unexpected watchdog exit.");
        ShutdownService.shutdownActive(ExitCode.WATCHDOG_EXIT, msg);
    }
}

