/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.cloud.topology.TopologyService;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.server.cluster.Server;
import com.caucho.server.resin.Resin;
import com.caucho.server.util.CauchoSystem;

public class ResinAdmin
extends AbstractManagedObject
implements ResinMXBean {
    private final Resin _resin;

    public ResinAdmin(Resin resin) {
        this._resin = resin;
        this.registerSelf();
    }

    public String getName() {
        return null;
    }

    public ClusterMXBean[] getClusters() {
        CloudSystem system = TopologyService.getCurrentSystem();
        CloudCluster[] clusters = system.getClusterList();
        ClusterMXBean[] mxClusters = new ClusterMXBean[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            mxClusters[i] = clusters[i].getAdmin();
        }
        return mxClusters;
    }

    public String getConfigFile() {
        return this._resin.getResinConf().getNativePath();
    }

    public String getResinHome() {
        return this._resin.getResinHome().getNativePath();
    }

    public String getRootDirectory() {
        return this._resin.getRootDirectory().getNativePath();
    }

    public ServerMXBean getServer() {
        Server server = this._resin.getServer();
        if (server != null) {
            return server.getAdmin();
        }
        return null;
    }

    public String getVersion() {
        return VersionFactory.getFullVersion();
    }

    public boolean isProfessional() {
        return this._resin.isProfessional();
    }

    public String getLocalHost() {
        return CauchoSystem.getLocalHost();
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public String toString() {
        return "ResinAdmin[" + this.getObjectName() + "]";
    }
}

