/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.security.SecurityService;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectoryService;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentProperties;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.TransactionManager;
import com.caucho.server.cache.TempFileManager;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ThreadPoolConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResinConfig
implements EnvironmentBean {
    private static Logger log = Logger.getLogger(ResinConfig.class.getName());
    private static L10N L = new L10N(ResinConfig.class);
    private final Resin _resin;
    private final ResinSystem _system;
    private long _minFreeMemory = 0x200000L;
    private SecurityManager _securityManager;
    protected Management _management;
    private TempFileManager _tempFileManager;

    ResinConfig(Resin resin) {
        this._resin = resin;
        this._system = resin.getResinSystem();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._system.getClassLoader();
    }

    @Configurable
    public void setResinSystemAuthKey(String key) {
        SecurityService security = SecurityService.create();
        security.setSignatureSecret(key);
    }

    @Configurable
    public void setEnvironmentSystemProperties(boolean isEnable) {
        EnvironmentProperties.enableEnvironmentSystemProperties(isEnable);
    }

    @Configurable
    public ThreadPoolConfig createThreadPool() throws Exception {
        return new ThreadPoolConfig();
    }

    @Configurable
    public void setUserName(String userName) {
    }

    @Configurable
    public void setGroupName(String groupName) {
    }

    @Configurable
    public void setMinFreeMemory(Bytes minFreeMemory) {
        this._minFreeMemory = minFreeMemory.getBytes();
    }

    public long getMinFreeMemory() {
        return this._minFreeMemory;
    }

    @Configurable
    public void setShutdownWaitMax(Period shutdownWaitMax) {
        this._resin.setShutdownWaitTime(shutdownWaitMax.getPeriod());
    }

    @Configurable
    public void setGlobalSystemProperties(boolean isGlobal) {
    }

    @Configurable
    public SecurityManagerConfig createSecurityManager() {
        return new SecurityManagerConfig();
    }

    @Configurable
    public void setWatchdogManager(ConfigProgram program) {
    }

    @Deprecated
    public TransactionManager createTransactionManager() throws ConfigException {
        log.warning(L.l("<transaction-manager> tag belongs in <management>"));
        return new TransactionManager(this._resin);
    }

    public Object createModuleRepository() {
        return new Object();
    }

    public TempFileManager getTempFileManager() {
        if (this._tempFileManager == null) {
            Path path = RootDirectoryService.getCurrent().getDataDirectory();
            this._tempFileManager = new TempFileManager(path);
        }
        return this._tempFileManager;
    }

    public void addSecurityProvider(Class<?> providerClass) throws Exception {
        if (!Provider.class.isAssignableFrom(providerClass)) {
            throw new ConfigException(L.l("security-provider {0} must implement java.security.Provider", providerClass.getName()));
        }
        Security.addProvider((Provider)providerClass.newInstance());
    }

    public JspPropertyGroup createJsp() {
        return new JspPropertyGroup();
    }

    public void addBoot(ContainerProgram program) throws Exception {
    }

    @Configurable
    @Deprecated
    public void setAdminPath(Path path) {
    }

    @Configurable
    @Deprecated
    public void setResinDataDirectory(Path path) {
    }

    @Deprecated
    public Management createManagement() {
        return this.createResinManagement();
    }

    @Deprecated
    public Management createResinManagement() {
        return new Management();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    class SecurityManagerConfig {
        private boolean _isEnable = true;

        SecurityManagerConfig() {
            if (ResinConfig.this._securityManager == null) {
                ResinConfig.this._securityManager = new SecurityManager();
            }
        }

        public void setEnable(boolean enable) {
            this._isEnable = enable;
        }

        public void setValue(boolean enable) {
            this.setEnable(enable);
        }

        public void setPolicyFile(Path path) throws ConfigException {
            if (!path.canRead()) {
                throw new ConfigException(L.l("policy-file '{0}' must be readable.", path));
            }
        }

        @PostConstruct
        public void init() {
            if (this._isEnable) {
                System.setSecurityManager(ResinConfig.this._securityManager);
            }
        }
    }
}

