/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.RawString;
import com.caucho.server.rewrite.AuthTypeCondition;
import com.caucho.server.rewrite.Condition;
import com.caucho.server.rewrite.CookieCondition;
import com.caucho.server.rewrite.ExistsCondition;
import com.caucho.server.rewrite.ExprCondition;
import com.caucho.server.rewrite.HeaderCondition;
import com.caucho.server.rewrite.LocalPortCondition;
import com.caucho.server.rewrite.LocaleCondition;
import com.caucho.server.rewrite.MethodCondition;
import com.caucho.server.rewrite.QueryParamCondition;
import com.caucho.server.rewrite.RemoteAddrCondition;
import com.caucho.server.rewrite.RemoteUserCondition;
import com.caucho.server.rewrite.SecureCondition;
import com.caucho.server.rewrite.ServerNameCondition;
import com.caucho.server.rewrite.ServerPortCondition;
import com.caucho.server.rewrite.UserInRoleCondition;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import java.net.UnknownHostException;

public class ConditionConfig {
    private static final L10N L = new L10N(ConditionConfig.class);
    private Condition _condition;
    private ContainerProgram _builderProgram;

    private void setCondition(Condition condition) {
        if (this._condition != null) {
            throw new ConfigException(L.l("Condition '{0}' has already been set, cannot use '{1}' here", (Object)this._condition.getTagName(), condition.getTagName()));
        }
        this._condition = condition;
    }

    public void setAuthType(String authType) {
        this.setCondition(new AuthTypeCondition(authType));
    }

    public void setCookie(String cookie) {
        this.setCondition(new CookieCondition(cookie));
    }

    public void setExpr(RawString expr) {
        this.setCondition(new ExprCondition(expr.getValue()));
    }

    public void setExists(RawString expr) {
        this.setCondition(new ExistsCondition(expr.getValue()));
    }

    public void setHeader(String header) {
        this.setCondition(new HeaderCondition(header));
    }

    public void setLocale(String locale) {
        this.setCondition(new LocaleCondition(locale));
    }

    public void setLocalPort(int localPort) {
        this.setCondition(new LocalPortCondition(localPort));
    }

    public void setMethod(String method) {
        this.setCondition(new MethodCondition(method));
    }

    public void setQueryParam(String queryParam) {
        this.setCondition(new QueryParamCondition(queryParam));
    }

    public void setRemoteAddr(String addr) throws UnknownHostException {
        this.setCondition(new RemoteAddrCondition(InetNetwork.create(addr)));
    }

    public void setRemoteUser(String user) {
        this.setCondition(new RemoteUserCondition(user));
    }

    public void setSecure(boolean isSecure) {
        this.setCondition(new SecureCondition(isSecure));
    }

    public void setServerName(String serverName) {
        this.setCondition(new ServerNameCondition(serverName));
    }

    public void setServerPort(int serverPort) {
        this.setCondition(new ServerPortCondition(serverPort));
    }

    public void setUserInRole(String role) {
        this.setCondition(new UserInRoleCondition(role));
    }

    public void addBuilderProgram(ConfigProgram init) {
        if (this._builderProgram == null) {
            this._builderProgram = new ContainerProgram();
        }
        this._builderProgram.addProgram(init);
    }

    Condition getCondition() {
        if (this._condition == null) {
            throw new ConfigException(L.l("A condition is required"));
        }
        if (this._builderProgram != null) {
            this._builderProgram.configure(this._condition);
        }
        Config.init(this._condition);
        return this._condition;
    }
}

