/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.RewriteDispatchFilterChain;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import java.util.regex.Matcher;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;

public class DispatchRule
extends AbstractRuleWithConditions {
    private String _target;
    private String _absoluteTarget;
    private String _targetHost;
    private boolean _isAbsolute;

    protected DispatchRule(RewriteDispatch rewriteDispatch) {
        super(rewriteDispatch);
    }

    public String getTagName() {
        return "dispatch";
    }

    public void setAbsoluteTarget(String target) {
        this._target = target;
        this._isAbsolute = true;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void setTargetHost(String target) {
        this._targetHost = target;
    }

    public String getTarget() {
        return this._target;
    }

    public String rewrite(String uri, Matcher matcher) {
        if (this._target != null) {
            String rewrite = matcher.replaceAll(this._target);
            if (uri.equals("/") && rewrite.endsWith("/") && !this._target.endsWith("/")) {
                rewrite = rewrite.substring(0, rewrite.length() - 1);
            }
            return rewrite;
        }
        return uri;
    }

    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) {
        String uriArg = null;
        uriArg = queryString == null ? uri : (uri.indexOf(63) >= 0 ? uri + "&" + queryString : uri + "?" + queryString);
        if (this.getTarget() != null) {
            return new RewriteDispatchFilterChain(uriArg);
        }
        return accept;
    }

    @PostConstruct
    public void init() throws ConfigException {
        super.init();
    }
}

