/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.FormLogin;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.security.SecurityFilterChain;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;

public class ConstraintManager
extends FilterChainBuilder {
    private static L10N L = new L10N(ConstraintManager.class);
    private ArrayList<SecurityConstraint> _constraints = new ArrayList();

    public void addConstraint(SecurityConstraint constraint) {
        this._constraints.add(constraint);
    }

    public FilterChainBuilder getFilterBuilder() {
        return this;
    }

    public FilterChain build(FilterChain next, Invocation invocation) {
        String uri = invocation.getContextURI();
        WebApp app = invocation.getWebApp();
        if (app == null) {
            return next;
        }
        String lower = uri.toLowerCase();
        if (lower.startsWith("/web-inf") || lower.startsWith("/meta-inf")) {
            return new ErrorFilterChain(404);
        }
        ArrayList<AbstractConstraint> constraints = new ArrayList<AbstractConstraint>();
        HashMap<String, AbstractConstraint[]> methodMap = new HashMap<String, AbstractConstraint[]>();
        for (int i = 0; i < this._constraints.size(); ++i) {
            SecurityConstraint constraint = this._constraints.get(i);
            if (!constraint.isMatch(uri)) continue;
            AbstractConstraint absConstraint = constraint.getConstraint();
            if (absConstraint != null) {
                ArrayList<String> methods = constraint.getMethods(uri);
                for (int j = 0; methods != null && j < methods.size(); ++j) {
                    String method = methods.get(j);
                    AbstractConstraint[] methodList = methodMap.get(method);
                    if (methodList == null) {
                        methodList = absConstraint.toArray();
                    }
                    methodMap.put(method, methodList);
                }
                if (methods != null && methods.size() != 0) continue;
                AbstractConstraint[] constArray = absConstraint.toArray();
                for (int k = 0; k < constArray.length; ++k) {
                    constraints.add(constArray[k]);
                }
                if (constraint.isFallthrough()) continue;
                break;
            }
            if (!constraint.isFallthrough()) break;
        }
        if (uri.endsWith("/j_security_check") && app.getLogin() instanceof FormLogin) {
            RequestDispatcher disp = app.getNamedDispatcher("j_security_check");
            if (disp == null) {
                throw new IllegalStateException(L.l("j_security_check is an undefined servlet"));
            }
            next = new ForwardFilterChain(disp);
        }
        if (constraints.size() > 0 || methodMap.size() > 0) {
            SecurityFilterChain filterChain = new SecurityFilterChain(next);
            filterChain.setWebApp(invocation.getWebApp());
            if (methodMap.size() > 0) {
                filterChain.setMethodMap(methodMap);
            }
            filterChain.setConstraints(constraints);
            return filterChain;
        }
        return next;
    }

    public boolean hasConstraintForUrlPattern(String pattern) {
        for (SecurityConstraint constraint : this._constraints) {
            if (!constraint.isMatch(pattern)) continue;
            return true;
        }
        return false;
    }
}

