/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.distcache.ByteStreamCache;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.security.Login;
import com.caucho.server.session.SessionDeserializer;
import com.caucho.server.session.SessionManager;
import com.caucho.server.session.SessionSerializer;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.L10N;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements HttpSession,
CacheListener {
    private static final Logger log = Logger.getLogger(SessionImpl.class.getName());
    private static final L10N L = new L10N(SessionImpl.class);
    private String _id;
    protected SessionManager _manager;
    protected Map<String, Object> _values;
    private long _creationTime;
    private long _accessTime;
    private long _idleTimeout;
    private boolean _isIdleSet;
    private boolean _isNew = true;
    private boolean _isModified = false;
    private boolean _isValid = true;
    private boolean _isClosing = false;
    private boolean _isInvalidating = false;
    private ExtCacheEntry _cacheEntry;
    private final AtomicInteger _useCount = new AtomicInteger();

    public SessionImpl(SessionManager manager, String id, long creationTime) {
        this._manager = manager;
        this._creationTime = creationTime = Alarm.getExactTime();
        this._accessTime = creationTime;
        this._idleTimeout = manager.getSessionTimeout();
        this._id = id;
        this._values = this.createValueMap();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " new");
        }
    }

    protected Map<String, Object> createValueMap() {
        return new TreeMap<String, Object>();
    }

    public long getCreationTime() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call getCreationTime() when session is no longer valid.", this));
        }
        return this._creationTime;
    }

    public String getId() {
        return this._id;
    }

    public long getLastAccessedTime() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call getLastAccessedTime() when session is no longer valid.", this));
        }
        return this._accessTime;
    }

    public int getMaxInactiveInterval() {
        if (0x3FFFFFFFFFFFFFFFL <= this._idleTimeout) {
            return -1;
        }
        return (int)(this._idleTimeout / 1000L);
    }

    public void setMaxInactiveInterval(int value) {
        this._idleTimeout = value < 0 ? 0x3FFFFFFFFFFFFFFFL : (long)value * 1000L;
        this._isIdleSet = true;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public ServletContext getServletContext() {
        return this._manager.getWebApp();
    }

    public SessionManager getManager() {
        return this._manager;
    }

    public boolean isNew() {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0} can't call isNew() when session is no longer valid.", this));
        }
        return this._isNew;
    }

    public boolean isValid() {
        return this._isValid;
    }

    boolean isClosing() {
        return this._isClosing;
    }

    public boolean isEmpty() {
        return this._values == null || this._values.size() == 0;
    }

    public boolean inUse() {
        return this._useCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call getAttribute() when session is no longer valid.", this));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            Object value = this._values.get(name);
            return value;
        }
    }

    void setModified() {
        if (this._values.size() > 0) {
            this._isModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        ArrayList<HttpSessionAttributeListener> listeners;
        HttpSessionBindingListener listener;
        Object oldValue;
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call setAttribute(String, Object) when session is no longer valid.", this));
        }
        if (value != null && !(value instanceof Serializable) && log.isLoggable(Level.FINE)) {
            log.fine(L.l("{0} attribute '{1}' value is non-serializable type '{2}'", this, name, value.getClass().getName()));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = value != null ? this._values.put(name, value) : this._values.remove(name);
        }
        this._isModified = true;
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null && listeners.size() > 0) {
            HttpSessionBindingEvent event = oldValue != null ? new HttpSessionBindingEvent((HttpSession)this, name, oldValue) : new HttpSessionBindingEvent((HttpSession)this, name, value);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener2 = listeners.get(i);
                if (oldValue != null) {
                    listener2.attributeReplaced(event);
                    continue;
                }
                listener2.attributeAdded(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: can't call removeAttribute(String) when session is no longer valid.", this));
        }
        Map<String, Object> map = this._values;
        synchronized (map) {
            oldValue = this._values.remove(name);
        }
        if (oldValue != null) {
            this._isModified = true;
        }
        this.notifyValueUnbound(name, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("{0} can't call getAttributeNames() when session is no longer valid.", this));
            }
            return Collections.enumeration(this._values.keySet());
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this._values;
        synchronized (map) {
            if (!this._isValid) {
                throw new IllegalStateException(L.l("{0} can't call getValueNames() when session is no longer valid.", this));
            }
            if (this._values == null) {
                return new String[0];
            }
            String[] s = new String[this._values.size()];
            Enumeration e = this.getAttributeNames();
            int count = 0;
            while (e.hasMoreElements()) {
                s[count++] = (String)e.nextElement();
            }
            return s;
        }
    }

    void create(long now, boolean isCreate) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create session");
        }
        if (this._isValid) {
            this.unbind();
        }
        now = Alarm.getCurrentTime();
        this._isValid = true;
        this._isNew = true;
        this._accessTime = now;
        this._creationTime = now;
    }

    boolean addUse() {
        this._useCount.incrementAndGet();
        return true;
    }

    void endUse() {
        this._useCount.decrementAndGet();
    }

    void setAccess(long now) {
        if (this._useCount.get() > 1) {
            return;
        }
        this._isNew = false;
    }

    public void setAccessTime(long now) {
        this._accessTime = now;
    }

    public void finishRequest() {
        this._accessTime = Alarm.getCurrentTime();
        this._isNew = false;
        if (this._useCount.decrementAndGet() > 0) {
            return;
        }
        this.saveAfterRequest();
    }

    public boolean load(boolean isNew) {
        if (!this._isValid) {
            return false;
        }
        if (this._isIdleSet && this._accessTime + this._idleTimeout < Alarm.getCurrentTime()) {
            return false;
        }
        if (this._useCount.get() > 1) {
            return true;
        }
        try {
            ByteStreamCache cache = this._manager.getCache();
            if (cache == null) {
                return !isNew;
            }
            if (!isNew && this._manager.isSaveOnShutdown()) {
                return true;
            }
            ExtCacheEntry entry = cache.getExtCacheEntry(this._id);
            ExtCacheEntry cacheEntry = this._cacheEntry;
            if (entry != null && cacheEntry != null && cacheEntry.getValueHashKey() != null && cacheEntry.getValueHashKey().equals(entry.getValueHashKey())) {
                return true;
            }
            TempOutputStream os = new TempOutputStream();
            if (cache.get(this._id, os)) {
                InputStream is = os.getInputStream();
                SessionDeserializer in = this._manager.createSessionDeserializer(is);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " session load valueHash=" + (entry != null ? entry.getValueHashKey() : null));
                }
                this.load(in);
                in.close();
                is.close();
                this._cacheEntry = entry;
                return true;
            }
            this._cacheEntry = null;
            if (cacheEntry == null) {
                return true;
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(SessionDeserializer in) throws IOException {
        HttpSessionActivationListener listener;
        int i;
        HttpSessionEvent event = null;
        ArrayList<Object> listeners = null;
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            Map<String, Object> map = this._values;
            synchronized (map) {
                this._values.clear();
                try {
                    int size = in.readInt();
                    for (int i2 = 0; i2 < size; ++i2) {
                        String key = (String)in.readObject();
                        Object value = in.readObject();
                        if (value == null) continue;
                        this._values.put(key, value);
                        if (!(value instanceof HttpSessionActivationListener)) continue;
                        HttpSessionActivationListener listener2 = (HttpSessionActivationListener)value;
                        if (event == null) {
                            event = new HttpSessionEvent((HttpSession)this);
                        }
                        if (listeners == null) {
                            listeners = new ArrayList();
                        }
                        listeners.add(listener2);
                    }
                }
                catch (Exception e) {
                    throw IOExceptionWrapper.create(e);
                }
            }
        }
        for (i = 0; listeners != null && i < listeners.size(); ++i) {
            listener = listeners.get(i);
            if (event == null) {
                event = new HttpSessionEvent((HttpSession)this);
            }
            listener.sessionDidActivate(event);
        }
        listeners = this._manager.getActivationListeners();
        for (i = 0; listeners != null && i < listeners.size(); ++i) {
            listener = listeners.get(i);
            if (event == null) {
                event = new HttpSessionEvent((HttpSession)this);
            }
            listener.sessionDidActivate(event);
        }
    }

    void reset(long now) {
        if (log.isLoggable(Level.FINER)) {
            log.fine(this + " reset");
        }
        now = Alarm.getCurrentTime();
        this.unbind();
        this._isValid = true;
        this._isNew = true;
        this._accessTime = now;
        this._creationTime = now;
    }

    public final void saveBeforeFlush() {
        if (this._manager == null || !this._manager.isSaveBeforeFlush()) {
            return;
        }
        this.save();
    }

    public final void saveBeforeHeaders() {
        if (this._manager == null || !this._manager.isSaveBeforeHeaders()) {
            return;
        }
        this.save();
    }

    public final void saveAfterRequest() {
        if (this._manager == null || !this._manager.isSaveAfterRequest()) {
            return;
        }
        this.save();
    }

    public final void save() {
        if (!this.isValid()) {
            return;
        }
        try {
            if (!this._isModified && !this._manager.getAlwaysSaveSession()) {
                return;
            }
            if (!this._manager.isPersistenceEnabled()) {
                return;
            }
            this._isModified = false;
            TempOutputStream os = new TempOutputStream();
            SessionSerializer out = this._manager.createSessionSerializer(os);
            this.store(out);
            out.close();
            this._manager.addSessionSaveSample(os.getLength());
            this._cacheEntry = this._manager.getCache().put(this._id, os.getInputStream(), this._idleTimeout);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " session save valueHash=" + (this._cacheEntry != null ? this._cacheEntry.getValueHashKey() : null));
            }
            os.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, this + ": can't serialize session", e);
        }
    }

    void saveOnShutdown() {
        this.save();
    }

    public void passivate() {
        this.unbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(SessionSerializer out) throws IOException {
        Set<Map.Entry<String, Object>> set = null;
        HttpSessionEvent event = null;
        Object object = this._values;
        synchronized (object) {
            int size;
            set = this._values.entrySet();
            int n = size = set == null ? 0 : set.size();
            if (size == 0) {
                out.writeInt(0);
                return;
            }
            ArrayList<HttpSessionActivationListener> listeners = this._manager.getActivationListeners();
            if (listeners != null && listeners.size() > 0) {
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                for (int i = 0; i < listeners.size(); ++i) {
                    HttpSessionActivationListener listener = listeners.get(i);
                    listener.sessionWillPassivate(event);
                }
            }
            for (Map.Entry<String, Object> entry : set) {
                Object value = entry.getValue();
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                if (event == null) {
                    event = new HttpSessionEvent((HttpSession)this);
                }
                listener.sessionWillPassivate(event);
            }
        }
        object = this;
        synchronized (object) {
            Map<String, Object> map = this._values;
            synchronized (map) {
                set = this._values.entrySet();
                int size = set == null ? 0 : set.size();
                out.writeInt(size);
                if (size == 0) {
                    return;
                }
                boolean ignoreNonSerializable = this.getManager().getIgnoreSerializationErrors();
                for (Map.Entry<String, Object> entry : set) {
                    Object value = entry.getValue();
                    out.writeObject(entry.getKey());
                    if (ignoreNonSerializable && !(value instanceof Serializable)) {
                        out.writeObject(null);
                        continue;
                    }
                    try {
                        out.writeObject(value);
                    }
                    catch (NotSerializableException e) {
                        log.warning(L.l("{0}: failed storing persistent session attribute '{1}'.  Persistent session values must extend java.io.Serializable.\n{2}", this, entry.getKey(), String.valueOf(e)));
                        throw e;
                    }
                }
            }
        }
    }

    public void invalidate() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invalidate");
        }
        this._isInvalidating = true;
        this.invalidate(Logout.INVALIDATE);
    }

    boolean isIdle(long now) {
        long maxIdleTime = this._idleTimeout;
        if (this.inUse()) {
            return false;
        }
        return this._accessTime + maxIdleTime < now;
    }

    public void timeout() {
        if (!this.isValid()) {
            return;
        }
        if (!this._manager.isPersistenceEnabled()) {
            this.invalidateTimeout();
        } else {
            this.invalidateTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEvent() {
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this._isInvalidating || this._useCount.get() <= 0) {
                this._isClosing = true;
            }
        }
        if (!this._isClosing) {
            log.warning(L.l("{0} LRU while in use (use-count={1}).  Consider increasing session-count.", (Object)this, this._useCount));
        }
        boolean isValid = this._isValid;
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " remove");
        }
        long now = Alarm.getCurrentTime();
        if (this._isInvalidating || !this._manager.isPersistenceEnabled() || this._accessTime + (long)this.getMaxInactiveInterval() < now) {
            this.notifyDestroy();
        }
        this.invalidateLocal();
    }

    private void notifyDestroy() {
        ArrayList<HttpSessionListener> listeners = this._manager.getListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (int i = listeners.size() - 1; i >= 0; --i) {
                HttpSessionListener listener = listeners.get(i);
                listener.sessionDestroyed(event);
            }
        }
    }

    public void invalidateLogout() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " logout");
        }
        this._isInvalidating = true;
        this.invalidate(Logout.INVALIDATE);
    }

    void invalidateTimeout() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " timeout");
        }
        this._isInvalidating = this._manager.isOwner(this._id);
        this.invalidate(Logout.TIMEOUT);
    }

    void invalidateLru() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " lru");
        }
        this.invalidateImpl(Logout.LRU);
    }

    public void invalidateRemote() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " invalidate remote");
        }
        this._isInvalidating = true;
        this.invalidate(Logout.INVALIDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(Logout logout) {
        if (!this._isValid) {
            throw new IllegalStateException(L.l("{0}: Can't call invalidate() when session is no longer valid.", this));
        }
        try {
            Login login = this._manager.getWebApp().getLogin();
            if (login != null) {
                login.sessionInvalidate(this, logout == Logout.TIMEOUT);
            }
            this._manager.removeSession(this);
            this.invalidateImpl(logout);
        }
        finally {
            this._isValid = false;
        }
    }

    private void invalidateImpl(Logout logout) {
        boolean invalidateAfterListener = this._manager.isInvalidateAfterListener();
        if (!invalidateAfterListener) {
            this._isValid = false;
        }
        try {
            if (this._isInvalidating && this._manager.getSessionStore() != null) {
                boolean isRemove = false;
                if (logout == Logout.TIMEOUT) {
                    ExtCacheEntry entry = this._manager.getSessionStore().peekExtCacheEntry(this._id);
                    long now = Alarm.getCurrentTime();
                    if (entry == null || !entry.isValid()) {
                        isRemove = true;
                    }
                } else {
                    isRemove = true;
                }
                if (isRemove) {
                    this._manager.getSessionStore().remove(this._id);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.invalidateLocal();
    }

    private void invalidateLocal() {
        if (this._isValid && !this._isInvalidating && this._manager.isSaveOnlyOnShutdown()) {
            this.save();
        }
        this.unbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        if (this._values.size() == 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        Map<String, Object> map = this._values;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this._values.entrySet()) {
                names.add(entry.getKey());
                values.add(entry.getValue());
            }
            this._values.clear();
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            Object value = values.get(i);
            this.notifyValueUnbound(name, value);
        }
    }

    private void notifyValueUnbound(String name, Object oldValue) {
        ArrayList<HttpSessionAttributeListener> listeners;
        if (oldValue == null) {
            return;
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if ((listeners = this._manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener = listeners.get(i);
                listener.attributeRemoved(event);
            }
        }
    }

    public String toString() {
        WebApp webApp;
        String contextPath = "";
        SessionManager manager = this._manager;
        if (manager != null && (webApp = manager.getWebApp()) != null) {
            contextPath = "," + webApp.getContextPath();
        }
        return this.getClass().getSimpleName() + "[" + this.getId() + contextPath + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Logout {
        INVALIDATE,
        LRU,
        TIMEOUT;

    }
}

