/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp;

import com.caucho.jmx.Jmx;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.server.snmp.Oid;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.ObjectName;

public class SnmpAdmin
extends AbstractManagedObject {
    private String _host = "";
    private int _port;
    private String _sysContact = "";
    private String _sysLocation = "";
    private static int CAUCHO_PRIVATE_ENTERPRISE_NUMBER = 0;
    private HashMap<String, Oid> _mibMap = new HashMap();

    public SnmpAdmin(String host, int port) {
        this._host = host;
        this._port = port;
        this.init();
        this.registerSelf();
    }

    private void init() {
        String mbean = this.getObjectName().toString();
    }

    public void addAttribute(Oid attr) {
        this._mibMap.put(attr.getName(), attr);
    }

    public Oid getAttribute(String s) {
        return this._mibMap.get(s);
    }

    public String getName() {
        return this._host + ":" + this._port;
    }

    public String getSysDescr() {
        try {
            ObjectName name = new ObjectName("resin:type=Resin");
            return Jmx.getMBeanServer().getAttribute(name, "Version").toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String sysObjectID() {
        return "1.3.6.1.4.1." + CAUCHO_PRIVATE_ENTERPRISE_NUMBER;
    }

    public long getSysUpTime() {
        try {
            ObjectName name = new ObjectName("java.lang:type=Runtime");
            Object obj = Jmx.getMBeanServer().getAttribute(name, "Uptime");
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String getSysContact() {
        return this._sysContact;
    }

    public void setSysContact(String sysContact) {
        this._sysContact = sysContact;
    }

    public String getSysName() {
        try {
            ObjectName name = new ObjectName("resin:type=Host,name=default");
            Object obj = Jmx.getMBeanServer().getAttribute(name, "URL");
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getSysLocation() {
        return this._sysLocation;
    }

    public void setSysLocation(String sysLocation) {
        this._sysLocation = sysLocation;
    }

    public int getSysServices() {
        return 128;
    }

    static class Mbean {
        private String _name;
        private String _prefix = "";
        private ArrayList<Oid> _attrList = new ArrayList();

        Mbean() {
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setPrefix(String prefix) {
            this._prefix = prefix;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public void addAttribute(Oid attr) {
            this._attrList.add(attr);
        }

        public boolean equals(Object obj) {
            return obj instanceof Mbean && ((Mbean)obj).getPrefix().equals(this._prefix);
        }
    }
}

