/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.CauchoRequestWrapper;
import com.caucho.server.webapp.WebApp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class DispatchFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(DispatchFilterChain.class.getName());
    private FilterChain _next;
    private WebApp _webApp;
    private ClassLoader _classLoader;
    private ServletRequestListener[] _requestListeners;

    public DispatchFilterChain(FilterChain next, WebApp webApp) {
        this._next = next;
        this._webApp = webApp;
        this._classLoader = webApp.getClassLoader();
        this._requestListeners = webApp.getRequestListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ClassLoader oldLoader;
        Thread thread;
        block14: {
            ServletContext webApp;
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            if (request instanceof CauchoRequestWrapper) {
                CauchoRequestWrapper cReq = (CauchoRequestWrapper)request;
                webApp = cReq.getRequest().getServletContext();
            } else {
                webApp = request.getServletContext();
            }
            try {
                try {
                    thread.setContextClassLoader(this._classLoader);
                    if (webApp != this._webApp) {
                        for (int i = 0; i < this._requestListeners.length; ++i) {
                            ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                            this._requestListeners[i].requestInitialized(event);
                        }
                    }
                    this._next.doFilter(request, response);
                }
                catch (FileNotFoundException e) {
                    log.log(Level.FINER, e.toString(), e);
                    HttpServletResponse res = (HttpServletResponse)response;
                    res.sendError(404);
                    Object var9_12 = null;
                    if (webApp != this._webApp) {
                        for (int i = this._requestListeners.length - 1; i >= 0; --i) {
                            ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                            this._requestListeners[i].requestDestroyed(event);
                        }
                    }
                    thread.setContextClassLoader(oldLoader);
                    return;
                }
                Object var9_11 = null;
                if (webApp == this._webApp) break block14;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (webApp != this._webApp) {
                    for (int i = this._requestListeners.length - 1; i >= 0; --i) {
                        ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                        this._requestListeners[i].requestDestroyed(event);
                    }
                }
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            for (int i = this._requestListeners.length - 1; i >= 0; --i) {
                ServletRequestEvent event = new ServletRequestEvent((ServletContext)this._webApp, request);
                this._requestListeners[i].requestDestroyed(event);
            }
        }
        thread.setContextClassLoader(oldLoader);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._next + "]";
    }
}

