/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.inject.Module;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.CauchoRequestWrapper;
import com.caucho.server.http.Form;
import com.caucho.server.webapp.IncludeResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.HashMapImpl;
import com.caucho.util.IntMap;
import com.caucho.vfs.Encoding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class IncludeRequest
extends CauchoRequestWrapper {
    private static final IntMap _includeAttributeMap = new IntMap();
    private static Enumeration<String> _emptyEnum;
    private static final int REQUEST_URI_CODE = 1;
    private static final int CONTEXT_PATH_CODE = 2;
    private static final int SERVLET_PATH_CODE = 3;
    private static final int PATH_INFO_CODE = 4;
    private static final int QUERY_STRING_CODE = 5;
    private Invocation _invocation;
    private IncludeResponse _response;
    private HashMapImpl<String, String[]> _filledForm;
    private ArrayList<String> _headerNames;

    public IncludeRequest() {
        this._response = new IncludeResponse(this);
    }

    public IncludeRequest(HttpServletRequest request, HttpServletResponse response, Invocation invocation) {
        super(request);
        this._response = new IncludeResponse(this, response);
        this.setResponse(this._response);
        this._invocation = invocation;
    }

    @Override
    public IncludeResponse getResponse() {
        return this._response;
    }

    @Override
    public ServletContext getServletContext() {
        return this._invocation.getWebApp();
    }

    @Override
    public DispatcherType getDispatcherType() {
        return DispatcherType.INCLUDE;
    }

    @Override
    public String getPageURI() {
        return this._invocation.getURI();
    }

    @Override
    public String getContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getPageContextPath() {
        return this._invocation.getContextPath();
    }

    @Override
    public String getPageServletPath() {
        return this._invocation.getServletPath();
    }

    @Override
    public String getPagePathInfo() {
        return this._invocation.getPathInfo();
    }

    @Override
    public String getPageQueryString() {
        return this._invocation.getQueryString();
    }

    @Override
    public String getMethod() {
        String method = this.getRequest().getMethod();
        if ("POST".equalsIgnoreCase(method)) {
            return method;
        }
        return "GET";
    }

    @Override
    public WebApp getWebApp() {
        return this._invocation.getWebApp();
    }

    @Override
    public boolean isSyntheticCacheHeader() {
        return true;
    }

    @Override
    public void setHeader(String name, String value) {
    }

    @Override
    public String getHeader(String name) {
        if ("If-Modified-Since".equals(name) || "If-None-Match".equals(name)) {
            return null;
        }
        return super.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        if ("If-Modified-Since".equals(name) || "If-None-Match".equals(name)) {
            return _emptyEnum;
        }
        return super.getHeaders(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        if (this._headerNames == null) {
            this._headerNames = new ArrayList();
            Enumeration<String> names = super.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                if ("If-Modified-Since".equals(name) || "If-None-Match".equals(name)) continue;
                this._headerNames.add(name);
            }
        }
        return Collections.enumeration(this._headerNames);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.enumeration(this._filledForm.keySet());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this._filledForm);
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this._filledForm == null) {
            this._filledForm = this.parseQuery();
        }
        return this._filledForm.get(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private HashMapImpl<String, String[]> parseQuery() {
        String javaEncoding = Encoding.getJavaName(this.getCharacterEncoding());
        HashMapImpl<String, String[]> form = new HashMapImpl<String, String[]>();
        form.putAll(this.getRequest().getParameterMap());
        Form formParser = Form.allocate();
        try {
            String queryString = this._invocation.getQueryString();
            if (queryString != null) {
                formParser.parseQueryString(form, queryString, javaEncoding, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return form;
    }

    @Override
    public Object getAttribute(String name) {
        switch (_includeAttributeMap.get(name)) {
            case 1: {
                return this._invocation.getURI();
            }
            case 2: {
                return this._invocation.getContextPath();
            }
            case 3: {
                return this._invocation.getServletPath();
            }
            case 4: {
                return this._invocation.getPathInfo();
            }
            case 5: {
                return this._invocation.getQueryString();
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> e = super.getAttributeNames();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        if (!list.contains("javax.servlet.include.request_uri")) {
            list.add("javax.servlet.include.request_uri");
            list.add("javax.servlet.include.context_path");
            list.add("javax.servlet.include.servlet_path");
            list.add("javax.servlet.include.path_info");
            list.add("javax.servlet.include.query_string");
        }
        return Collections.enumeration(list);
    }

    void startRequest() {
        this._response.startRequest();
    }

    @Override
    protected void finishRequest() throws IOException {
        super.finishRequest();
        this._response.finishRequest();
    }

    static {
        _includeAttributeMap.put("javax.servlet.include.request_uri", 1);
        _includeAttributeMap.put("javax.servlet.include.context_path", 2);
        _includeAttributeMap.put("javax.servlet.include.servlet_path", 3);
        _includeAttributeMap.put("javax.servlet.include.path_info", 4);
        _includeAttributeMap.put("javax.servlet.include.query_string", 5);
        _emptyEnum = new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                throw new NoSuchElementException();
            }
        };
    }
}

