/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.cache.AbstractCacheFilterChain;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.CauchoResponseWrapper;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.server.webapp.IncludeRequest;
import com.caucho.server.webapp.IncludeResponseStream2;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IncludeResponse
extends CauchoResponseWrapper {
    private static final L10N L = new L10N(IncludeResponse.class);
    private final IncludeResponseStream2 _originalStream = new IncludeResponseStream2(this);
    private final ServletOutputStreamImpl _responseOutputStream = new ServletOutputStreamImpl();
    private final ResponseWriter _responsePrintWriter = new ResponseWriter();
    private IncludeRequest _request;
    private QDate _calendar = new QDate();
    private AbstractResponseStream _stream;
    private AbstractCacheFilterChain _cacheInvocation;
    private boolean _isForwardEnclosed;

    IncludeResponse(IncludeRequest request) {
        super(request);
    }

    IncludeResponse(IncludeRequest request, HttpServletResponse response) {
        super(request, response);
        this._request = request;
    }

    void startRequest() {
        this._originalStream.start();
        this._stream = this._originalStream;
        this._responseOutputStream.init(this._stream);
        this._responsePrintWriter.init(this._stream);
        this._cacheInvocation = null;
    }

    void finishRequest() throws IOException {
        this._stream.close();
    }

    @Override
    public IncludeRequest getRequest() {
        return this._request;
    }

    @Override
    public void setCacheInvocation(AbstractCacheFilterChain cacheInvocation) {
        assert (this._cacheInvocation == null || cacheInvocation == null);
        this._cacheInvocation = cacheInvocation;
    }

    public final AbstractCacheFilterChain getCacheInvocation() {
        return this._cacheInvocation;
    }

    @Override
    public void close() {
        try {
            this._stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void sendError(int code, String msg) {
    }

    @Override
    public void setHeader(String name, String value) {
        this._originalStream.addHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this._originalStream.addHeader(name, value);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        Collection<String> headers = super.getHeaders(name);
        List<String> headerKeys = this._originalStream.getHeaderKeys();
        List<String> headerValues = this._originalStream.getHeaderValues();
        for (int i = 0; i < headerKeys.size(); ++i) {
            String key = headerKeys.get(i);
            if (!key.equals(name)) continue;
            headers.add(headerValues.get(i));
        }
        return headers;
    }

    @Override
    public Collection<String> getHeaderNames() {
        Collection<String> responseHeaders = super.getHeaderNames();
        HashSet<String> headers = responseHeaders instanceof Set ? (HashSet<String>)responseHeaders : new HashSet<String>(responseHeaders);
        headers.addAll(this._originalStream.getHeaderKeys());
        return headers;
    }

    @Override
    public boolean containsHeader(String name) {
        return false;
    }

    @Override
    public void setDateHeader(String name, long date) {
        this._calendar.setGMTTime(date);
        this.setHeader(name, this._calendar.printDate());
    }

    @Override
    public void addDateHeader(String name, long date) {
        this._calendar.setGMTTime(date);
        this.addHeader(name, this._calendar.printDate());
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    @Override
    public void addCookie(Cookie cookie) {
    }

    @Override
    public void setContentType(String type) {
    }

    @Override
    public void setContentLength(int length) {
    }

    @Override
    public void setResponseStream(AbstractResponseStream responseStream) {
        this._stream = responseStream;
        this._responseOutputStream.init(this._stream);
        this._responsePrintWriter.init(this._stream);
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        return this._stream;
    }

    public AbstractResponseStream getOriginalStream() {
        return this._originalStream;
    }

    @Override
    public boolean isCauchoResponseStream() {
        return this._stream.isCauchoResponseStream();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this._responseOutputStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this._responsePrintWriter;
    }

    public PrintWriter getNextWriter() {
        return null;
    }

    @Override
    public void setBufferSize(int size) {
        this._stream.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this._stream.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        this._stream.flush();
    }

    public void flushHeader() throws IOException {
        this._stream.flushBuffer();
    }

    public void setDisableAutoFlush(boolean disable) {
    }

    @Override
    public void reset() {
        this.resetBuffer();
    }

    @Override
    public void resetBuffer() {
        this._stream.clearBuffer();
    }

    void reset(boolean force) {
        if (!force && this._originalStream.isCommitted()) {
            throw new IllegalStateException(L.l("response cannot be reset() after committed"));
        }
        this._stream.clearBuffer();
    }

    public void clearBuffer() {
        this._stream.clearBuffer();
    }

    @Override
    public void setForwardEnclosed(boolean isForwardEnclosed) {
        this._isForwardEnclosed = isForwardEnclosed;
    }

    @Override
    public boolean isForwardEnclosed() {
        if (this._isForwardEnclosed) {
            return true;
        }
        if (this.getResponse() instanceof CauchoResponse) {
            return ((CauchoResponse)this.getResponse()).isForwardEnclosed();
        }
        return false;
    }
}

