/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.core.ResinImport;
import com.caucho.config.el.CandiElResolver;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.SingletonBindingHandle;
import com.caucho.config.j2ee.PersistenceContextRefConfig;
import com.caucho.config.types.EjbLocalRef;
import com.caucho.config.types.EjbRef;
import com.caucho.config.types.Icon;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.PathBuilder;
import com.caucho.config.types.Period;
import com.caucho.config.types.ResourceRef;
import com.caucho.config.types.Validator;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.manager.EjbModule;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.env.deploy.DeployMode;
import com.caucho.env.deploy.EnvironmentDeployInstance;
import com.caucho.env.deploy.RepositoryDependency;
import com.caucho.i18n.CharacterEncoding;
import com.caucho.java.WorkDir;
import com.caucho.jsf.cfg.JsfPropertyGroup;
import com.caucho.jsp.JspServlet;
import com.caucho.jsp.cfg.JspConfig;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.jsp.cfg.JspTaglib;
import com.caucho.jsp.el.JspApplicationContextImpl;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.AbstractScanClass;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.make.AlwaysModified;
import com.caucho.make.DependencyContainer;
import com.caucho.management.server.HostMXBean;
import com.caucho.naming.Jndi;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.rewrite.DispatchRule;
import com.caucho.rewrite.IfSecure;
import com.caucho.rewrite.Not;
import com.caucho.rewrite.RedirectSecure;
import com.caucho.rewrite.RewriteFilter;
import com.caucho.rewrite.WelcomeFile;
import com.caucho.security.AbstractSingleSignon;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicLogin;
import com.caucho.security.ClusterSingleSignon;
import com.caucho.security.Login;
import com.caucho.security.MemorySingleSignon;
import com.caucho.security.RoleMapManager;
import com.caucho.security.SingleSignon;
import com.caucho.server.cache.AbstractProxyCache;
import com.caucho.server.cluster.Server;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.FilterManager;
import com.caucho.server.dispatch.FilterMapper;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationBuilder;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.ServletRegexp;
import com.caucho.server.dispatch.SubInvocation;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.dispatch.VersionInvocation;
import com.caucho.server.host.Host;
import com.caucho.server.log.AbstractAccessLog;
import com.caucho.server.log.AccessLog;
import com.caucho.server.resin.Resin;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.security.ConstraintManager;
import com.caucho.server.security.LoginConfig;
import com.caucho.server.security.PermitEmptyRolesConstraint;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.security.TransportConstraint;
import com.caucho.server.security.WebResourceCollection;
import com.caucho.server.session.SessionManager;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.AccessLogFilterChain;
import com.caucho.server.webapp.CacheMapping;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.ListenerConfig;
import com.caucho.server.webapp.LocaleEncodingMappingList;
import com.caucho.server.webapp.MimeMapping;
import com.caucho.server.webapp.MultipartForm;
import com.caucho.server.webapp.NamedDispatcherImpl;
import com.caucho.server.webapp.Ordering;
import com.caucho.server.webapp.PathMapping;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.RewriteRealPath;
import com.caucho.server.webapp.SecurityRole;
import com.caucho.server.webapp.ServletContextImpl;
import com.caucho.server.webapp.StatisticsFilterChain;
import com.caucho.server.webapp.WebAppAdmin;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.server.webapp.WebAppFilterChain;
import com.caucho.server.webapp.WebAppFragmentConfig;
import com.caucho.server.webapp.WebAppInjectExtension;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.server.webapp.WebServiceContextProxy;
import com.caucho.server.webapp.WelcomeFileList;
import com.caucho.server.webbeans.SessionContextContainer;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.InjectionException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterRegistration;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.UnavailableException;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configurable
public class WebApp
extends ServletContextImpl
implements Dependency,
EnvironmentBean,
SchemaBean,
InvocationBuilder,
EnvironmentDeployInstance,
ScanListener,
JspConfigDescriptor,
Serializable {
    private static final L10N L = new L10N(WebApp.class);
    private static final Logger log = Logger.getLogger(WebApp.class.getName());
    private static final int JSP_1 = 1;
    private static final char[] SERVLET_ANNOTATION = "javax.servlet.annotation.".toCharArray();
    private static EnvironmentLocal<AbstractAccessLog> _accessLogLocal = new EnvironmentLocal("caucho.server.access-log");
    private static EnvironmentLocal<WebApp> _appLocal = new EnvironmentLocal("caucho.application");
    private static String[] _classLoaderHackPackages = new String[]{"java.", "javax.servlet.", "javax.naming.", "javax.sql.", "javax.transaction."};
    private EnvironmentClassLoader _classLoader;
    private Server _server;
    private Host _host;
    private WebAppContainer _parent;
    private WebApp _oldWebApp;
    private long _oldWebAppExpireTime;
    private WebAppController _controller;
    private InjectManager _cdiManager;
    private InvocationDecoder _invocationDecoder;
    private String _moduleName = "default";
    private String _baseContextPath = "";
    private String _versionContextPath = "";
    private String _description = "";
    private String _servletVersion;
    private boolean _isDynamicDeploy;
    private boolean _isDisableCrossContext;
    private boolean _isCompileContext;
    private ArrayList<DeployGenerator<WebAppController>> _appGenerators = new ArrayList();
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private ServletManager _servletManager;
    private ServletMapper _servletMapper;
    private boolean _isStrictMapping;
    private boolean _servletAllowEL = false;
    private boolean _isAllowForwardAfterFlush = false;
    private FilterManager _filterManager;
    private FilterMapper _filterMapper;
    private FilterMapper _loginFilterMapper;
    private FilterMapper _includeFilterMapper;
    private FilterMapper _forwardFilterMapper;
    private FilterMapper _errorFilterMapper;
    private boolean _dispatchWrapsFilters;
    private SessionManager _sessionManager;
    private boolean _isInheritSession;
    private String _characterEncoding;
    private AbstractProxyCache _cache;
    private LruCache<String, FilterChainEntry> _filterChainCache = new LruCache(256);
    private UrlMap<CacheMapping> _cacheMappingMap = new UrlMap();
    private LruCache<String, RequestDispatcherImpl> _dispatcherCache;
    private Login _defaultLogin;
    private Login _login;
    private Authenticator _authenticator;
    private RoleMapManager _roleMapManager;
    private ConstraintManager _constraintManager;
    private boolean _isSecure;
    private ErrorPageManager _errorPageManager;
    private Throwable _configException;
    private RewriteDispatch _requestRewriteDispatch;
    private RewriteDispatch _includeRewriteDispatch;
    private RewriteDispatch _forwardRewriteDispatch;
    private LruCache<String, String> _realPathCache = new LruCache(1024);
    private RewriteRealPath _rewriteRealPath;
    private HashMap<String, String> _mimeMapping = new HashMap();
    private HashMap<String, String> _localeMapping = new HashMap();
    private ArrayList<ListenerConfig> _listeners = new ArrayList();
    private ArrayList<ServletContextListener> _webAppListeners = new ArrayList();
    private ArrayList<ServletContextAttributeListener> _attributeListeners = new ArrayList();
    private ArrayList<ServletRequestListener> _requestListeners = new ArrayList();
    private ServletRequestListener[] _requestListenerArray = new ServletRequestListener[0];
    private ArrayList<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList();
    private ServletRequestAttributeListener[] _requestAttributeListenerArray = new ServletRequestAttributeListener[0];
    private ArrayList<String> _welcomeFileList = new ArrayList();
    private ArrayList<Validator> _resourceValidators = new ArrayList();
    private DependencyContainer _invocationDependency;
    private AbstractAccessLog _accessLog;
    private Path _tempDir;
    private boolean _cookieHttpOnly;
    private int _jspState;
    private JspPropertyGroup _jsp;
    private JsfPropertyGroup _jsf;
    private ArrayList<JspTaglib> _taglibList;
    private JspApplicationContextImpl _jspApplicationContext;
    private HashMap<String, Object> _extensions = new HashMap();
    private MultipartForm _multipartForm;
    private ArrayList<String> _regexp;
    private boolean _isStatisticsEnabled;
    private long _shutdownWaitTime = 15000L;
    private long _activeWaitTime = 15000L;
    private long _idleTime = 0x6DDD00L;
    private final Lifecycle _lifecycle;
    private final AtomicInteger _requestCount = new AtomicInteger();
    private long _lastRequestTime = Alarm.getCurrentTime();
    private Pattern _cookieDomainPattern = null;
    private long _status500CountTotal;
    private long _status500LastTime;
    private boolean _metadataComplete = false;
    private List<String> _pendingClasses = new ArrayList<String>();
    private Ordering _absoluteOrdering;
    private List<WebAppFragmentConfig> _webFragments;
    private boolean _isApplyingWebFragments = false;

    WebApp(WebAppController controller) {
        this._controller = controller;
        this._classLoader = EnvironmentClassLoader.create(controller.getParentClassLoader(), "web-app:" + this.getId());
        this._server = controller.getWebManager();
        if (this._server == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)this.getClass().getSimpleName(), Server.class.getSimpleName()));
        }
        this._host = controller.getHost();
        if (this._host == null) {
            throw new IllegalStateException(L.l("{0} requires an active {1}", (Object)this.getClass().getSimpleName(), Host.class.getSimpleName()));
        }
        this._invocationDecoder = this._server.getInvocationDecoder();
        this.setVersionContextPath(controller.getContextPath());
        this._moduleName = this._baseContextPath = controller.getContextPath();
        if ("".equals(this._moduleName)) {
            this._moduleName = "ROOT";
        } else if (this._moduleName.startsWith("/")) {
            this._moduleName = this._moduleName.substring(1);
        }
        this.setParent(controller.getContainer());
        this._lifecycle = this.getId().startsWith("error/") ? new Lifecycle(log, this.toString(), Level.FINER) : new Lifecycle(log, this.toString(), Level.INFO);
        this.initConstructor();
    }

    private void initConstructor() {
        try {
            JspServlet.initStatic();
            this._classLoader.addParentPriorityPackages(_classLoaderHackPackages);
            _appLocal.set(this, this._classLoader);
            Path rootDirectory = this.getRootDirectory();
            Vfs.setPwd(rootDirectory, this._classLoader);
            WorkDir.setLocalWorkDir(rootDirectory.lookup("WEB-INF/work"), this._classLoader);
            EjbManager.setScanAll();
            EjbModule.replace(this.getModuleName(), this._classLoader);
            EjbModule.setAppName(this.getModuleName(), this._classLoader);
            this._servletManager = new ServletManager();
            this._servletMapper = new ServletMapper(this);
            this._servletMapper.setServletManager(this._servletManager);
            this._filterManager = new FilterManager();
            this._filterMapper = new FilterMapper();
            this._filterMapper.setServletContext(this);
            this._filterMapper.setFilterManager(this._filterManager);
            this._loginFilterMapper = new FilterMapper();
            this._loginFilterMapper.setServletContext(this);
            this._loginFilterMapper.setFilterManager(this._filterManager);
            this._includeFilterMapper = new FilterMapper();
            this._includeFilterMapper.setServletContext(this);
            this._includeFilterMapper.setFilterManager(this._filterManager);
            this._forwardFilterMapper = new FilterMapper();
            this._forwardFilterMapper.setServletContext(this);
            this._forwardFilterMapper.setFilterManager(this._filterManager);
            this._errorFilterMapper = new FilterMapper();
            this._errorFilterMapper.setServletContext(this);
            this._errorFilterMapper.setFilterManager(this._filterManager);
            this._constraintManager = new ConstraintManager();
            this._invocationDependency = new DependencyContainer();
            this._invocationDependency.add(this);
            if (this._controller.getRepository() != null) {
                String tag = this._controller.getId();
                String tagValue = this._controller.getRepository().getTagContentHash(tag);
                this._invocationDependency.add(new RepositoryDependency(tag, tagValue));
                if (this._controller.getVersionDependency() != null) {
                    this._invocationDependency.add(this._controller.getVersionDependency());
                }
            }
            this._invocationDependency.add(this._controller);
            this._cdiManager = InjectManager.create(this._classLoader);
            this._cdiManager.addPath(this.getRootDirectory().lookup("WEB-INF/beans.xml"));
            this._cdiManager.addExtension(new WebAppInjectExtension(this._cdiManager, this));
            this._jspApplicationContext = new JspApplicationContextImpl(this);
            this._jspApplicationContext.addELResolver(this._cdiManager.getELResolver());
            if (!CauchoSystem.isTesting()) {
                if (rootDirectory.equals(CauchoSystem.getResinHome())) {
                    throw new ConfigException(L.l("web-app root-directory '{0}' can not be the same as resin.home\n", rootDirectory.getURL()));
                }
                if (this._parent != null && rootDirectory.equals(this._parent.getRootDirectory())) {
                    throw new ConfigException(L.l("web-app root-directory '{0}' can not be the same as the host root-directory\n", rootDirectory.getURL()));
                }
            }
        }
        catch (Throwable e) {
            this.setConfigException(e);
        }
    }

    @Override
    public void preConfigInit() {
    }

    public void setParent(WebAppContainer parent) {
        this._parent = parent;
        if (parent == null) {
            return;
        }
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    public WebAppContainer getParent() {
        return this._parent;
    }

    public Host getHost() {
        return this._host;
    }

    public static WebApp getLocal() {
        return WebApp.getCurrent();
    }

    public static WebApp getCurrent() {
        return _appLocal.get();
    }

    public Server getServer() {
        return this._server;
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
        EjbModule.replace(this.getModuleName(), this._classLoader);
    }

    public InvocationDecoder getInvocationDecoder() {
        if (this._invocationDecoder != null) {
            return this._invocationDecoder;
        }
        if (this._server != null) {
            this._invocationDecoder = this._server.getInvocationDecoder();
        }
        if (this._invocationDecoder == null && this._server == null) {
            this._invocationDecoder = Server.getCurrent().getInvocationDecoder();
        }
        return this._invocationDecoder;
    }

    public InjectManager getBeanManager() {
        return this._cdiManager;
    }

    public void setId(String id) {
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        throw new IllegalStateException();
    }

    public EnvironmentClassLoader getEnvironmentClassLoader() {
        return this._classLoader;
    }

    @Configurable
    public void setRedeployMode(DeployMode mode) {
        if (this._controller != null) {
            this._controller.setRedeployMode(mode);
        }
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/webapp/resin-web-xml.rnc";
    }

    @Configurable
    public void setStatisticsEnable(boolean isEnable) {
        this._isStatisticsEnabled = isEnable;
    }

    public void setConfigNode(Node node) {
        String ns = node.getNamespaceURI();
        if (ns == null || ns.equals("")) {
            this._jspState = 1;
        }
    }

    @Override
    public Path getRootDirectory() {
        return this._controller.getRootDirectory();
    }

    public DependencyContainer getInvocationDependency() {
        return this._invocationDependency;
    }

    public void setRegexp(ArrayList<String> regexp) {
        this._regexp = regexp;
    }

    public ArrayList<String> getRegexp() {
        return this._regexp;
    }

    public void setDocumentDirectory(Path appDir) {
        throw new ConfigException(L.l("Use <root-directory> instead of <document-directory>, because <document-directory> has been removed for Resin 4.0"));
    }

    @Configurable
    public void setRootDirectory(Path appDir) {
    }

    public void setAppDir(Path appDir) {
        this.setRootDirectory(appDir);
    }

    public ObjectName getObjectName() {
        return this._controller.getObjectName();
    }

    public String getWarName() {
        return this._controller.getWarName();
    }

    @Override
    public String getContextPath() {
        if (this.isVersionAlias()) {
            return this._baseContextPath;
        }
        return this._versionContextPath;
    }

    private void setVersionContextPath(String contextPath) {
        this._versionContextPath = contextPath;
        if (this.getServletContextName() == null) {
            this.setDisplayName(contextPath);
        }
    }

    private String getVersionContextPath() {
        return this._versionContextPath;
    }

    @Configurable
    public void setVersion(String version) {
        this._servletVersion = version;
    }

    public String getVersion() {
        return this._servletVersion;
    }

    public void setSchemaLocation(String location) {
    }

    public boolean isMetadataComplete() {
        return this._metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this._metadataComplete = metadataComplete;
    }

    @Configurable
    public void setDistributable(boolean isDistributable) {
    }

    public String getURL() {
        if (this._parent != null) {
            return this._parent.getURL() + this.getContextPath();
        }
        return this.getContextPath();
    }

    public String getId() {
        return this._controller.getId();
    }

    public String getHostName() {
        return this._host.getHostName();
    }

    public HostMXBean getHostAdmin() {
        return this._host.getAdmin();
    }

    public String getDescription() {
        return this._description;
    }

    @Configurable
    public void setDescription(String description) {
        this._description = description;
    }

    @Configurable
    public void setIcon(Icon icon) {
    }

    @Configurable
    public void setAllowServletEL(boolean allow) {
        this._servletAllowEL = allow;
    }

    @Configurable
    public boolean isAllowForwardAfterFlush() {
        return this._isAllowForwardAfterFlush;
    }

    public void setAllowForwardAfterFlush(boolean allowForwardAfterFlush) {
        this._isAllowForwardAfterFlush = allowForwardAfterFlush;
    }

    @Configurable
    public void setDisableCrossContext(boolean isDisable) {
        this._isDisableCrossContext = isDisable;
    }

    public void setCompileContext(boolean isCompile) {
        this._isCompileContext = isCompile;
    }

    public boolean isCompileContext() {
        return this._isCompileContext;
    }

    public boolean isVersionAlias() {
        return this._controller.isVersionAlias();
    }

    public void setOldWebApp(WebApp oldWebApp, long expireTime) {
        this._oldWebApp = oldWebApp;
        this._oldWebAppExpireTime = expireTime;
    }

    public Ordering createAbsoluteOrdering() {
        if (this._absoluteOrdering == null) {
            this._absoluteOrdering = new Ordering();
        }
        return this._absoluteOrdering;
    }

    @Configurable
    public Ordering createOrdering() {
        log.finer(L.l("'{0}' ordering tag should not be used inside web application descriptor.", this));
        return new Ordering();
    }

    public ServletConfigImpl createServlet() throws ServletException {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setWebApp(this);
        config.setServletContext(this);
        config.setServletMapper(this._servletMapper);
        config.setAllowEL(this._servletAllowEL);
        return config;
    }

    @Configurable
    public void addServlet(ServletConfigImpl config) throws ServletException {
        config.setServletContext(this);
        this._servletManager.addServlet(config, this._isApplyingWebFragments);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> servletClass) throws ServletException {
        try {
            return (T)((Servlet)this._cdiManager.createTransientObject(servletClass));
        }
        catch (InjectionException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addServlet(WebServlet webServlet, String servletClassName) throws ServletException {
        ServletMapping mapping = this.createServletMapping();
        mapping.setServletClass(servletClassName);
        String name = webServlet.name();
        if (name == null || "".equals(name)) {
            name = servletClassName;
        }
        mapping.setServletName(name);
        if (webServlet.value().length > 0 && webServlet.urlPatterns().length == 0) {
            for (String string : webServlet.value()) {
                mapping.addURLPattern(string);
            }
        } else if (webServlet.urlPatterns().length > 0 && webServlet.value().length == 0) {
            for (String string : webServlet.urlPatterns()) {
                mapping.addURLPattern(string);
            }
        } else {
            throw new ConfigException(L.l("Annotation @WebServlet at '{0}' must specify either value or urlPatterns", servletClassName));
        }
        for (String string : webServlet.initParams()) {
            mapping.setInitParam(string.name(), string.value());
        }
        mapping.setLoadOnStartup(webServlet.loadOnStartup());
        mapping.setAsyncSupported(webServlet.asyncSupported());
        this.addServletMapping(mapping);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.addServlet(servletName, className, null, null);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.addServlet(servletName, servletClass.getName(), servletClass, null);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        Class<?> cl = servlet.getClass();
        return this.addServlet(servletName, cl.getName(), cl, servlet);
    }

    private ServletRegistration.Dynamic addServlet(String servletName, String servletClassName, Class<? extends Servlet> servletClass, Servlet servlet) {
        if (!this.isInitializing()) {
            throw new IllegalStateException(L.l("addServlet may only be called during initialization"));
        }
        try {
            ServletConfigImpl config = (ServletConfigImpl)this.getServletRegistration(servletName);
            if (config == null) {
                config = this.createServlet();
                config.setServletName(servletName);
                config.setServletClass(servletClassName);
                config.setServletClass(servletClass);
                config.setServlet(servlet);
                this.addServlet(config);
            } else {
                if (config.getClassName() == null) {
                    config.setServletClass(servletClassName);
                }
                if (config.getServletClass() == null) {
                    config.setServletClass(servletClass);
                }
                if (config.getServlet() == null) {
                    config.setServlet(servlet);
                }
            }
            return config;
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        return this._servletManager.getServlet(servletName);
    }

    @Override
    public Map<String, ServletRegistration> getServletRegistrations() {
        HashMap<String, ServletConfigImpl> configMap = this._servletManager.getServlets();
        HashMap<String, ServletConfigImpl> result = new HashMap<String, ServletConfigImpl>(configMap);
        return Collections.unmodifiableMap(result);
    }

    private void addServletSecurity(Class<? extends Servlet> servletClass, ServletSecurity security) {
        ServletSecurityElement securityElement = new ServletSecurityElement(security);
        this._servletManager.addSecurityElement(servletClass, securityElement);
    }

    private void initSecurityConstraints() {
        HashMap<String, ServletConfigImpl> servlets = this._servletManager.getServlets();
        for (Map.Entry entry : servlets.entrySet()) {
            ServletSecurityElement securityElement = ((ServletConfigImpl)entry.getValue()).getSecurityElement();
            if (securityElement == null) continue;
            ServletSecurity.EmptyRoleSemantic rootRoleSemantic = securityElement.getEmptyRoleSemantic();
            Set<String> patterns = this._servletMapper.getUrlPatterns((String)entry.getKey());
            Collection constraints = securityElement.getHttpMethodConstraints();
            if (constraints != null) {
                for (HttpMethodConstraintElement httpMethodConstraintElement : securityElement.getHttpMethodConstraints()) {
                    ServletSecurity.EmptyRoleSemantic emptyRoleSemantic = httpMethodConstraintElement.getEmptyRoleSemantic();
                    ServletSecurity.TransportGuarantee transportGuarantee = httpMethodConstraintElement.getTransportGuarantee();
                    String[] roles = httpMethodConstraintElement.getRolesAllowed();
                    SecurityConstraint constraint = new SecurityConstraint();
                    constraint.setFallthrough(false);
                    if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY) {
                        constraint.addConstraint(new PermitEmptyRolesConstraint(false));
                    } else if (roles.length == 0 && transportGuarantee == ServletSecurity.TransportGuarantee.NONE) {
                        constraint.addConstraint(new PermitEmptyRolesConstraint(true));
                    } else {
                        for (String role : roles) {
                            constraint.addRoleName(role);
                        }
                        if (transportGuarantee == ServletSecurity.TransportGuarantee.CONFIDENTIAL) {
                            constraint.addConstraint(new TransportConstraint("CONFIDENTIAL"));
                        }
                    }
                    WebResourceCollection resources = new WebResourceCollection();
                    resources.addHttpMethod(httpMethodConstraintElement.getMethodName());
                    for (String pattern : patterns) {
                        resources.addURLPattern(pattern);
                        constraint.addURLPattern(pattern);
                    }
                    constraint.addWebResourceCollection(resources);
                    this._constraintManager.addConstraint(constraint);
                }
            }
            ServletSecurity.EmptyRoleSemantic emptyRoleSemantic = securityElement.getEmptyRoleSemantic();
            ServletSecurity.TransportGuarantee transportGuarantee = securityElement.getTransportGuarantee();
            String[] roles = securityElement.getRolesAllowed();
            SecurityConstraint constraint = new SecurityConstraint();
            if (emptyRoleSemantic == ServletSecurity.EmptyRoleSemantic.DENY) {
                constraint.addConstraint(new PermitEmptyRolesConstraint(false));
            } else if (roles.length == 0 && transportGuarantee == ServletSecurity.TransportGuarantee.NONE) {
                constraint.addConstraint(new PermitEmptyRolesConstraint(true));
            } else {
                for (String role : roles) {
                    constraint.addRoleName(role);
                }
                if (transportGuarantee == ServletSecurity.TransportGuarantee.CONFIDENTIAL) {
                    constraint.addConstraint(new TransportConstraint("CONFIDENTIAL"));
                }
            }
            for (String pattern : patterns) {
                constraint.addURLPattern(pattern);
            }
            this._constraintManager.addConstraint(constraint);
        }
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> filterClass) throws ServletException {
        try {
            return (T)((Filter)this._cdiManager.createTransientObject(filterClass));
        }
        catch (InjectionException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFilter(WebFilter webFilter, String filterClassName) throws Exception {
        String url;
        int len$;
        String[] arr$;
        FilterMapping.URLPattern urlPattern;
        FilterMapping config = new FilterMapping();
        config.setFilterManager(this._filterManager);
        config.setFilterClass(filterClassName);
        String filterName = webFilter.filterName();
        if ("".equals(filterName)) {
            filterName = filterClassName;
        }
        config.setFilterName(filterName);
        boolean isMapping = false;
        if (webFilter.value().length > 0) {
            void var9_12;
            urlPattern = config.createUrlPattern();
            arr$ = webFilter.value();
            len$ = arr$.length;
            boolean bl = false;
            while (var9_12 < len$) {
                url = arr$[var9_12];
                urlPattern.addText(url);
                ++var9_12;
            }
            urlPattern.init();
            isMapping = true;
        }
        if (webFilter.urlPatterns().length > 0) {
            void var9_14;
            urlPattern = config.createUrlPattern();
            arr$ = webFilter.urlPatterns();
            len$ = arr$.length;
            boolean bl = false;
            while (var9_14 < len$) {
                url = arr$[var9_14];
                urlPattern.addText(url);
                ++var9_14;
            }
            urlPattern.init();
            isMapping = true;
        }
        if (webFilter.servletNames().length > 0) {
            for (String string : webFilter.servletNames()) {
                config.addServletName(string);
            }
            isMapping = true;
        }
        if (!isMapping) {
            throw new ConfigException(L.l("Annotation @WebFilter at '{0}' must specify either value, urlPatterns or servletNames", filterClassName));
        }
        for (String string : webFilter.initParams()) {
            config.setInitParam(string.name(), string.value());
        }
        for (String string : webFilter.dispatcherTypes()) {
            config.addDispatcher((DispatcherType)string);
        }
        config.setAsyncSupported(webFilter.asyncSupported());
        this.addFilterMapping(config);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.addFilter(filterName, className, null, null);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.addFilter(filterName, filterClass.getName(), filterClass, null);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        Class<?> cl = filter.getClass();
        return this.addFilter(filterName, cl.getName(), cl, filter);
    }

    private FilterRegistration.Dynamic addFilter(String filterName, String className, Class<? extends Filter> filterClass, Filter filter) {
        if (!this.isInitializing()) {
            throw new IllegalStateException();
        }
        try {
            FilterConfigImpl config = new FilterConfigImpl();
            config.setWebApp(this);
            config.setServletContext(this);
            config.setFilterName(filterName);
            config.setFilterClass(className);
            if (filterClass != null) {
                config.setFilterClass(filterClass);
            }
            if (filter != null) {
                config.setFilter(filter);
            }
            this.addFilter(config);
            return config;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    @Configurable
    public void setStrictMapping(boolean isStrict) throws ServletException {
        this._isStrictMapping = isStrict;
    }

    public boolean getStrictMapping() {
        return this._isStrictMapping;
    }

    @Configurable
    public void setLazyServletValidate(boolean isLazy) {
        this._servletManager.setLazyValidate(isLazy);
    }

    public ServletMapping createServletMapping() {
        ServletMapping servletMapping = new ServletMapping();
        if (this._isApplyingWebFragments) {
            servletMapping.setInFragmentMode();
        }
        servletMapping.setWebApp(this);
        servletMapping.setServletContext(this);
        servletMapping.setServletMapper(this._servletMapper);
        servletMapping.setStrictMapping(this.getStrictMapping());
        return servletMapping;
    }

    @Configurable
    public void addServletMapping(ServletMapping servletMapping) throws ServletException {
        servletMapping.setServletContext(this);
        servletMapping.init(this._servletMapper);
    }

    @Configurable
    public void addServletRegexp(ServletRegexp servletRegexp) throws ServletException, ClassNotFoundException {
        ServletMapping mapping = new ServletMapping();
        mapping.addURLRegexp(servletRegexp.getURLRegexp());
        mapping.setServletName(servletRegexp.getServletName());
        mapping.setServletClass(servletRegexp.getServletClass());
        mapping.setServletContext(this);
        servletRegexp.getBuilderProgram().configure(mapping);
        mapping.setStrictMapping(this.getStrictMapping());
        mapping.init(this._servletMapper);
    }

    @Configurable
    public void addFilter(FilterConfigImpl config) {
        config.setServletContext(this);
        config.setFilterManager(this._filterManager);
        config.setWebApp(this);
        this._filterManager.addFilter(config);
    }

    @Configurable
    public void addFilterMapping(FilterMapping filterMapping) throws ServletException {
        filterMapping.setServletContext(this);
        this._filterManager.addFilterMapping(filterMapping);
        if (filterMapping.isRequest()) {
            this._filterMapper.addFilterMapping(filterMapping);
            this._loginFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isInclude()) {
            this._includeFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isForward()) {
            this._forwardFilterMapper.addFilterMapping(filterMapping);
        }
        if (filterMapping.isError()) {
            this._errorFilterMapper.addFilterMapping(filterMapping);
        }
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        return this._filterManager.getFilter(filterName);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        HashMap<String, FilterConfigImpl> configMap = this._filterManager.getFilters();
        HashMap<String, FilterConfigImpl> result = new HashMap<String, FilterConfigImpl>(configMap);
        return Collections.unmodifiableMap(result);
    }

    public void addPersistenceContextRef(PersistenceContextRefConfig persistenceContextRefConfig) throws ServletException {
        log.fine("WebApp adding persistence context ref: " + persistenceContextRefConfig.getPersistenceContextRefName());
        String unitName = persistenceContextRefConfig.getPersistenceUnitName();
        log.fine("WebApp looking up entity manager: " + AmberContainer.getPersistenceContextJndiPrefix() + unitName);
        Object obj = Jndi.lookup(AmberContainer.getPersistenceContextJndiPrefix() + unitName);
        log.fine("WebApp found entity manager: " + obj);
        String contextRefName = persistenceContextRefConfig.getPersistenceContextRefName();
        try {
            Jndi.bindDeep("java:comp/env/" + contextRefName, obj);
        }
        catch (NamingException e) {
            throw ConfigException.create(e);
        }
    }

    @Configurable
    public void setDispatchWrapsFilters(boolean wrap) {
        this._dispatchWrapsFilters = wrap;
    }

    public boolean getDispatchWrapsFilters() {
        return this._dispatchWrapsFilters;
    }

    public void setDirectoryServlet(String className) throws Exception {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletName("directory");
        if (className.equals("none")) {
            config.setServletClass("com.caucho.servlets.ErrorStatusServlet");
        } else {
            config.setServletClass(className);
        }
        this.addServlet(config);
    }

    @Configurable
    public void addWelcomeFileList(WelcomeFileList list) {
        ArrayList<String> fileList = list.getWelcomeFileList();
        this._welcomeFileList = new ArrayList<String>(fileList);
    }

    @Configurable
    public LocaleEncodingMappingList createLocaleEncodingMappingList() {
        return new LocaleEncodingMappingList(this);
    }

    public void setInheritSession(boolean isInheritSession) {
        this._isInheritSession = isInheritSession;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public SessionManager createSessionConfig() throws Exception {
        if (this._isInheritSession) {
            return new SessionManager(this);
        }
        SessionManager manager = this.getSessionManager();
        return manager;
    }

    @Configurable
    public void addSessionConfig(SessionManager manager) throws ConfigException {
        if (this._isInheritSession) {
            manager.close();
        }
    }

    @Configurable
    public void setCookieHttpOnly(boolean isHttpOnly) {
        this._cookieHttpOnly = isHttpOnly;
    }

    public boolean getCookieHttpOnly() {
        return this._cookieHttpOnly;
    }

    public InitParam createContextParam() {
        InitParam initParam = new InitParam();
        initParam.setAllowEL(this._servletAllowEL);
        return initParam;
    }

    @Configurable
    public void addContextParam(InitParam initParam) {
        HashMap<String, String> map = initParam.getParameters();
        for (String key : map.keySet()) {
            String value = map.get(key);
            this.setInitParam(key, value);
        }
    }

    @Configurable
    public void addErrorPage(ErrorPage errorPage) {
        this.getErrorPageManager().addErrorPage(errorPage);
    }

    public AccessLog createAccessLog() {
        return new AccessLog();
    }

    @Configurable
    public void setAccessLog(AbstractAccessLog log) {
        this.add(log);
    }

    @Configurable
    public void add(AbstractAccessLog log) {
        this._accessLog = log;
        _accessLogLocal.set(log);
    }

    @Configurable
    public void addMimeMapping(MimeMapping mimeMapping) {
        this._mimeMapping.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
    }

    public void putLocaleEncoding(String locale, String encoding) {
        this._localeMapping.put(locale.toLowerCase(), encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        String key = locale.toString();
        String encoding = this._localeMapping.get(key.toLowerCase());
        if (encoding != null) {
            return encoding;
        }
        if (locale.getVariant() != null && (encoding = this._localeMapping.get((key = locale.getLanguage() + '_' + locale.getCountry()).toLowerCase())) != null) {
            return encoding;
        }
        if (locale.getCountry() != null && (encoding = this._localeMapping.get((key = locale.getLanguage()).toLowerCase())) != null) {
            return encoding;
        }
        return Encoding.getMimeName(locale);
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.setLogin(loginConfig.getLogin());
    }

    public void setLogin(Login login) {
        this._login = login;
    }

    public RoleMapManager getRoleMapManager() {
        return this._roleMapManager;
    }

    public void add(RewriteFilter filter) {
        if (filter.isRequest()) {
            if (this._requestRewriteDispatch == null) {
                this._requestRewriteDispatch = new RewriteDispatch(this);
            }
            this._requestRewriteDispatch.addAction(filter);
        }
    }

    public void add(DispatchRule rule) {
        if (rule.isRequest()) {
            if (this._requestRewriteDispatch == null) {
                this._requestRewriteDispatch = new RewriteDispatch(this);
            }
            this._requestRewriteDispatch.addRule(rule);
        }
        if (rule.isForward()) {
            if (this._forwardRewriteDispatch == null) {
                this._forwardRewriteDispatch = new RewriteDispatch(this);
            }
            this._forwardRewriteDispatch.addRule(rule);
        }
        if (rule.isInclude()) {
            if (this._includeRewriteDispatch == null) {
                this._includeRewriteDispatch = new RewriteDispatch(this);
            }
            this._includeRewriteDispatch.addRule(rule);
        }
    }

    public RewriteDispatch createRewriteDispatch() {
        return new RewriteDispatch(this);
    }

    public void addRewriteDispatch(RewriteDispatch dispatch) {
        if (dispatch.isRequest()) {
            this._requestRewriteDispatch = dispatch;
        }
        if (dispatch.isInclude()) {
            this._includeRewriteDispatch = dispatch;
        }
        if (dispatch.isForward()) {
            this._forwardRewriteDispatch = dispatch;
        }
    }

    public RewriteRealPath createRewriteRealPath() {
        if (this._rewriteRealPath == null) {
            this._rewriteRealPath = new RewriteRealPath(this.getRootDirectory());
        }
        return this._rewriteRealPath;
    }

    public void addPathMapping(PathMapping pathMapping) throws Exception {
        String urlPattern = pathMapping.getUrlPattern();
        String urlRegexp = pathMapping.getUrlRegexp();
        String realPath = pathMapping.getRealPath();
        if (urlPattern != null) {
            this.createRewriteRealPath().addPathPattern(urlPattern, realPath);
        } else if (urlRegexp != null) {
            this.createRewriteRealPath().addPathRegexp(urlRegexp, realPath);
        } else {
            throw new NullPointerException();
        }
    }

    public void addSecurityConstraint(SecurityConstraint constraint) {
        this._constraintManager.addConstraint(constraint);
    }

    public void add(SecurityConstraint constraint) {
        this.addSecurityConstraint(constraint);
    }

    public void addSecurityRole(SecurityRole role) {
    }

    @Configurable
    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
        if (isSecure) {
            RedirectSecure redirect = new RedirectSecure();
            redirect.add(new Not(new IfSecure()));
            this.add(redirect);
        }
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> listenerClass) throws ServletException {
        try {
            return (T)((EventListener)this._cdiManager.createTransientObject(listenerClass));
        }
        catch (InjectionException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public void addListener(String className) {
        try {
            Class<?> listenerClass = Class.forName(className, false, this.getClassLoader());
            this.addListener((EventListener)((Object)listenerClass));
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        this.addListener(this._cdiManager.createTransientObject(listenerClass));
    }

    @Override
    public <T extends EventListener> void addListener(T listener) {
        this.addListenerObject(listener, true);
    }

    @Override
    @Configurable
    public void addListener(ListenerConfig listener) throws Exception {
        if (!this.hasListener(listener.getListenerClass())) {
            this._listeners.add(listener);
            if (this._lifecycle.isStarting() || this._lifecycle.isActive()) {
                this.addListenerObject(listener.createListenerObject(), true);
            }
        }
    }

    public boolean hasListener(Class listenerClass) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            ListenerConfig listener = this._listeners.get(i);
            if (!listenerClass.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    private void addListenerObject(Object listenerObj, boolean start) {
        if (listenerObj instanceof ServletContextListener) {
            ServletContextListener scListener = (ServletContextListener)listenerObj;
            this._webAppListeners.add(scListener);
            if (start) {
                ServletContextEvent event = new ServletContextEvent((ServletContext)this);
                try {
                    scListener.contextInitialized(event);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        if (listenerObj instanceof ServletContextAttributeListener) {
            this.addAttributeListener((ServletContextAttributeListener)listenerObj);
        }
        if (listenerObj instanceof ServletRequestListener) {
            this._requestListeners.add((ServletRequestListener)listenerObj);
            this._requestListenerArray = new ServletRequestListener[this._requestListeners.size()];
            this._requestListeners.toArray(this._requestListenerArray);
        }
        if (listenerObj instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listenerObj);
            this._requestAttributeListenerArray = new ServletRequestAttributeListener[this._requestAttributeListeners.size()];
            this._requestAttributeListeners.toArray(this._requestAttributeListenerArray);
        }
        if (listenerObj instanceof HttpSessionListener) {
            this.getSessionManager().addListener((HttpSessionListener)listenerObj);
        }
        if (listenerObj instanceof HttpSessionAttributeListener) {
            this.getSessionManager().addAttributeListener((HttpSessionAttributeListener)listenerObj);
        }
        if (listenerObj instanceof HttpSessionActivationListener) {
            this.getSessionManager().addActivationListener((HttpSessionActivationListener)listenerObj);
        }
    }

    public ServletRequestListener[] getRequestListeners() {
        return this._requestListenerArray;
    }

    public ServletRequestAttributeListener[] getRequestAttributeListeners() {
        return this._requestAttributeListenerArray;
    }

    public void addResourceRef(ResourceRef ref) {
        this._resourceValidators.add(ref);
    }

    @Configurable
    public MultipartForm createMultipartForm() {
        if (this._multipartForm == null) {
            this._multipartForm = new MultipartForm();
        }
        return this._multipartForm;
    }

    public boolean doMultipartForm() {
        return this._multipartForm != null && this._multipartForm.isEnable();
    }

    public long getFormUploadMax() {
        if (this._multipartForm != null) {
            return this._multipartForm.getUploadMax();
        }
        return -1L;
    }

    public AbstractAccessLog getAccessLog() {
        return this._accessLog;
    }

    public void setTempDir(Path path) {
        this._tempDir = path;
    }

    @Configurable
    public JspPropertyGroup createJsp() {
        if (this._jsp == null) {
            this._jsp = new JspPropertyGroup();
        }
        return this._jsp;
    }

    public JspPropertyGroup getJsp() {
        return this._jsp;
    }

    public JsfPropertyGroup createJsf() {
        if (this._jsf == null) {
            this._jsf = new JsfPropertyGroup();
        }
        return this._jsf;
    }

    @Configurable
    public JsfPropertyGroup getJsf() {
        return this._jsf;
    }

    public boolean isFacesServletConfigured() {
        return this._servletManager.isFacesServletConfigured();
    }

    public JspApplicationContextImpl getJspApplicationContext() {
        return this._jspApplicationContext;
    }

    public boolean hasPre23Config() {
        return this._jspState == 1;
    }

    @Configurable
    public void addTaglib(JspTaglib taglib) {
        if (this._taglibList == null) {
            this._taglibList = new ArrayList();
        }
        this._taglibList.add(taglib);
    }

    public ArrayList<JspTaglib> getTaglibList() {
        return this._taglibList;
    }

    public Collection<TaglibDescriptor> getTaglibs() {
        ArrayList<TaglibDescriptor> taglibs = new ArrayList<TaglibDescriptor>();
        for (int i = 0; this._taglibList != null && i < this._taglibList.size(); ++i) {
            taglibs.add(this._taglibList.get(i));
        }
        JspConfig jspConfig = (JspConfig)this._extensions.get("jsp-config");
        if (jspConfig != null) {
            ArrayList<JspTaglib> taglibList = jspConfig.getTaglibList();
            for (int i = 0; i < taglibList.size(); ++i) {
                taglibs.add(taglibList.get(i));
            }
        }
        return taglibs;
    }

    public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
        JspConfig jspConfig = (JspConfig)this._extensions.get("jsp-config");
        ArrayList<JspPropertyGroupDescriptor> propertyGroups = new ArrayList<JspPropertyGroupDescriptor>();
        if (jspConfig != null) {
            ArrayList<JspPropertyGroup> groups = jspConfig.getJspPropertyGroupList();
            for (JspPropertyGroup group : groups) {
                propertyGroups.add(group);
            }
        }
        return propertyGroups;
    }

    public JspConfig createJspConfig() {
        return new JspConfig(this);
    }

    public void addJspConfig(JspConfig config) {
        this._extensions.put("jsp-config", config);
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this;
    }

    public Object getExtension(String key) {
        return this._extensions.get(key);
    }

    public EjbRef createEjbRef() {
        if (this._controller != null && this._controller.getArchivePath() != null) {
            return new EjbRef(this._controller.getArchivePath());
        }
        return new EjbRef();
    }

    public EjbLocalRef createEjbLocalRef() {
        if (this._controller != null && this._controller.getArchivePath() != null) {
            return new EjbLocalRef(this._controller.getArchivePath());
        }
        return new EjbLocalRef();
    }

    public WebAppExpandDeployGenerator createWebAppDeploy() {
        return this._parent.createWebAppDeploy();
    }

    @Configurable
    public void addWebAppDeploy(WebAppExpandDeployGenerator deploy) throws Exception {
        String contextPath = this.getContextPath();
        String prefix = deploy.getURLPrefix();
        deploy.setURLPrefix(contextPath + prefix);
        deploy.setParent(this._controller);
        deploy.setParentClassLoader(this.getClassLoader());
        for (WebAppConfig configDefault : this._webAppDefaultList) {
            deploy.addWebAppDefault(configDefault);
        }
        Environment.addEnvironmentListener(deploy, this.getClassLoader());
        this._appGenerators.add(deploy);
    }

    @Configurable
    public void addWebAppDefault(WebAppConfig config) {
        this._webAppDefaultList.add(config);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    @Configurable
    public void addWebApp(WebAppConfig config) throws Exception {
        String contextPath = this.getContextPath();
        String prefix = config.getId();
        if (prefix == null || prefix.equals("") || prefix.equals("/")) {
            throw new ConfigException(L.l("'{0}' is an illegal sub web-app id.", prefix));
        }
        WebAppContainer container = this._parent;
        DeployContainer<WebAppController> appGenerator = this._parent.getWebAppGenerator();
        WebAppSingleDeployGenerator deploy = new WebAppSingleDeployGenerator(appGenerator, container, config);
        deploy.setURLPrefix(contextPath + prefix);
        deploy.setParentWebApp(this._controller);
        deploy.setParentClassLoader(this.getClassLoader());
        deploy.setContainer(container);
        for (WebAppConfig configDefault : this._webAppDefaultList) {
            deploy.addWebAppDefault(configDefault);
        }
        String appDir = config.getRootDirectory();
        if (appDir == null) {
            appDir = "./" + prefix;
        }
        Path root = PathBuilder.lookupPath(appDir, null, this.getRootDirectory());
        deploy.setRootDirectory(root);
        deploy.init();
        this._parent.addDeploy(deploy);
    }

    @Override
    public void setConfigException(Throwable e) {
        if (e != null) {
            Throwable e1;
            for (e1 = e; e1 != null && !(e1 instanceof ConfigException) && e1.getCause() != null && e1.getCause() != e1; e1 = e1.getCause()) {
            }
            if (e1 != null) {
                if (e1 instanceof ConfigException) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.WARNING, e1.toString(), e1);
                    } else {
                        log.warning(e1.getMessage());
                    }
                } else {
                    log.log(Level.WARNING, e1.toString(), e1);
                }
            }
        }
        if (this._configException == null) {
            this._configException = e;
        }
        if (e != null) {
            this._classLoader.addDependency(AlwaysModified.create());
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public boolean isIgnoreClientDisconnect() {
        return this.getServer().isIgnoreClientDisconnect();
    }

    @Configurable
    public void setShutdownWaitMax(Period wait) {
        this._shutdownWaitTime = wait.getPeriod();
        Resin resin = Resin.getLocal();
        if (resin != null && resin.getShutdownWaitMax() < this._shutdownWaitTime) {
            log.warning(L.l("web-app shutdown-wait-max '{0}' is longer than resin shutdown-wait-max '{1}'.", (Object)this._shutdownWaitTime, resin.getShutdownWaitMax()));
        }
    }

    @Configurable
    public void setActiveWaitTime(Period wait) {
        this._activeWaitTime = wait.getPeriod();
    }

    @Configurable
    public void setIdleTime(Period idle) {
        this._idleTime = idle.getPeriod();
    }

    public void addConfigFile(Path path) throws Exception {
        ResinImport rImport = new ResinImport();
        rImport.setPath(path);
        rImport.setOptional(true);
        rImport.setParent(this);
        rImport.init();
        log.config("<config-file> is deprecated.  Please use resin:import.");
    }

    public String getState() {
        return this._lifecycle.getStateName();
    }

    public boolean isInit() {
        return this._lifecycle.isInit() || this._configException != null;
    }

    public boolean isInitializing() {
        return this._lifecycle.isBeforeActive();
    }

    @Override
    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean isClosed() {
        return this._lifecycle.isDestroyed();
    }

    public static ServletRequest getThreadRequest() {
        ProtocolConnection serverRequest = TcpSocketLink.getCurrentRequest();
        if (serverRequest instanceof ServletRequest) {
            return (ServletRequest)serverRequest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostConstruct
    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        try {
            this._classLoader.setId("web-app:" + this.getId());
            this._invocationDependency.setCheckInterval(this.getEnvironmentClassLoader().getDependencyCheckInterval());
            if (this._tempDir == null) {
                this._tempDir = (Path)Environment.getLevelAttribute("caucho.temp-dir");
            }
            if (this._tempDir == null) {
                this._tempDir = this.getRootDirectory().lookup("WEB-INF/tmp");
                if (this.getRootDirectory().lookup("WEB-INF").isDirectory()) {
                    this._tempDir.mkdirs();
                }
            } else {
                this._tempDir.mkdirs();
            }
            this.setAttribute("javax.servlet.context.tempdir", new File(this._tempDir.getNativePath()));
            FilterChainBuilder securityBuilder = this._constraintManager.getFilterBuilder();
            if (securityBuilder != null) {
                this._filterMapper.addTopFilter(securityBuilder);
            }
            if (this._server != null) {
                this._cache = this._server.getProxyCache();
            }
            for (int i = 0; i < this._appGenerators.size(); ++i) {
                this._parent.addDeploy(this._appGenerators.get(i));
            }
            this._classLoader.setId("web-app:" + this.getId());
            this._cdiManager = InjectManager.getCurrent();
            this._cdiManager.update();
            SingleSignon singleSignon = AbstractSingleSignon.getCurrent();
            if (singleSignon == null && Server.getCurrent() != null) {
                if (this.getSessionManager().isUsePersistentStore()) {
                    ClusterSingleSignon clusterSignon = new ClusterSingleSignon("web-app");
                    singleSignon = clusterSignon;
                } else {
                    MemorySingleSignon memorySignon = new MemorySingleSignon();
                    memorySignon.init();
                    singleSignon = memorySignon;
                }
                AbstractSingleSignon.setCurrent(singleSignon);
            }
            try {
                Authenticator auth = this._cdiManager.getReference(Authenticator.class, new Annotation[0]);
                this.setAttribute("caucho.authenticator", auth);
            }
            catch (Exception e) {
                log.finest(e.toString());
            }
            try {
                if (this._login == null) {
                    this._login = this._cdiManager.getReference(Login.class, new Annotation[0]);
                }
                if (this._login == null) {
                    ManagedBeanImpl<BasicLogin> loginBean = this._cdiManager.createManagedBean(BasicLogin.class);
                    this._cdiManager.addBean(loginBean);
                    this._defaultLogin = this._cdiManager.getReference(Login.class, new Annotation[0]);
                    this._authenticator = this._cdiManager.getReference(Authenticator.class, new Annotation[0]);
                }
                this.setAttribute("caucho.login", this._login);
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            this._cdiManager.addBean(this._cdiManager.createManagedBean(WebServiceContextProxy.class));
            if (!this._metadataComplete) {
                this.initWebFragments();
            }
            WebAppController parent = null;
            if (this._controller != null) {
                parent = this._controller.getParent();
            }
            if (this._isInheritSession && parent != null && this._sessionManager != parent.getWebApp().getSessionManager()) {
                SessionManager sessionManager = this._sessionManager;
                this._sessionManager = parent.getWebApp().getSessionManager();
                if (sessionManager != null) {
                    sessionManager.close();
                }
            }
            if (this._server != null && this.getSessionManager() != null) {
                this.getSessionManager().init();
                if (this._sessionManager.getCookieDomainRegexp() != null) {
                    this._cookieDomainPattern = Pattern.compile(this._sessionManager.getCookieDomainRegexp());
                }
                this.addListenerObject(new WebAppSessionListener(), true);
            }
            this._roleMapManager = RoleMapManager.create();
            this._characterEncoding = CharacterEncoding.getLocalEncoding();
            WelcomeFile welcomeFile = new WelcomeFile(this._welcomeFileList);
            this.add(welcomeFile);
            if (!this._isCompileContext) {
                for (int i = 0; i < this._resourceValidators.size(); ++i) {
                    Validator validator = this._resourceValidators.get(i);
                    validator.validate();
                }
            }
            Object var8_10 = null;
            this._lifecycle.toInit();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this._lifecycle.toInit();
            throw throwable;
        }
    }

    public void initWebFragments() {
        this.loadWebFragments();
        List<WebAppFragmentConfig> fragments = this.sortWebFragments();
        this._isApplyingWebFragments = true;
        for (WebAppFragmentConfig fragment : fragments) {
            fragment.getBuilderProgram().configure(this);
        }
        this._isApplyingWebFragments = false;
        this._classLoader.addScanListener(this);
    }

    public boolean isApplyingWebFragments() {
        return this._isApplyingWebFragments;
    }

    public boolean isAllowInitParamOverride() {
        return this._servletVersion == null || !this._servletVersion.startsWith("3");
    }

    private void loadWebFragments() {
        block6: {
            if (this._webFragments == null) {
                this._webFragments = new ArrayList<WebAppFragmentConfig>();
            }
            try {
                Enumeration<URL> fragments = this._classLoader.getResources("META-INF/web-fragment.xml");
                Config config = new Config();
                config.setEL(this._servletAllowEL);
                if (log.isLoggable(Level.FINER) && fragments.hasMoreElements()) {
                    log.finer(L.l("{0} loading web-fragments", this));
                }
                while (fragments.hasMoreElements()) {
                    URL url = fragments.nextElement();
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, L.l("Loading web-fragment '{0}:{1}'.", (Object)this, url));
                    }
                    WebAppFragmentConfig fragmentConfig = new WebAppFragmentConfig();
                    config.configure((Object)fragmentConfig, Vfs.lookup(url.toString()));
                    this._webFragments.add(fragmentConfig);
                }
            }
            catch (IOException e) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.log(Level.FINE, L.l("'{0}' error '{1}' loading fragments.", (Object)this, e), e);
            }
        }
    }

    private List<WebAppFragmentConfig> sortWebFragments() {
        HashMap<String, WebAppFragmentConfig> namedFragments = new HashMap<String, WebAppFragmentConfig>();
        ArrayList<WebAppFragmentConfig> anonFragments = new ArrayList<WebAppFragmentConfig>();
        for (WebAppFragmentConfig fragment : this._webFragments) {
            if (fragment.getName() != null) {
                namedFragments.put(fragment.getName(), fragment);
                continue;
            }
            anonFragments.add(fragment);
        }
        if (this._absoluteOrdering != null) {
            return this.getWebFragments(null, this._absoluteOrdering, namedFragments, anonFragments);
        }
        HashMap<WebAppFragmentConfig, HashSet<WebAppFragmentConfig>> parentsMap = new HashMap<WebAppFragmentConfig, HashSet<WebAppFragmentConfig>>();
        for (WebAppFragmentConfig config : namedFragments.values()) {
            if (config.getOrdering() == null) continue;
            List<WebAppFragmentConfig> children = this.getWebFragments(config, config.getOrdering().getBefore(), namedFragments, anonFragments);
            List<WebAppFragmentConfig> parents = this.getWebFragments(config, config.getOrdering().getAfter(), namedFragments, anonFragments);
            if (children != null && parents != null) {
                for (WebAppFragmentConfig fragmentConfig : children) {
                    if (!parents.contains(fragmentConfig)) continue;
                    throw new ConfigException(L.l("web-fragment '{0}' specifies conflicting ordering in its before and after tags. Consider using <absolute-ordering> in web.xml", config));
                }
            }
            if (children != null) {
                for (WebAppFragmentConfig child : children) {
                    HashSet<WebAppFragmentConfig> parentSet = (HashSet<WebAppFragmentConfig>)parentsMap.get(child);
                    if (parentSet == null) {
                        parentSet = new HashSet<WebAppFragmentConfig>();
                    }
                    parentSet.add(config);
                    parentsMap.put(child, parentSet);
                }
            }
            if (parents == null) continue;
            HashSet<WebAppFragmentConfig> parentsSet = (HashSet<WebAppFragmentConfig>)parentsMap.get(config);
            if (parentsSet == null) {
                parentsSet = new HashSet<WebAppFragmentConfig>();
            }
            parentsSet.addAll(parents);
            parentsMap.put(config, parentsSet);
        }
        ArrayList<WebAppFragmentConfig> result = new ArrayList<WebAppFragmentConfig>();
        while (!parentsMap.isEmpty()) {
            int resultSize = 0;
            HashSet removeSet = new HashSet();
            Iterator entries = parentsMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    WebAppFragmentConfig config = (WebAppFragmentConfig)iterator.next();
                    if (result.contains(config)) {
                        iterator.remove();
                        continue;
                    }
                    if (parentsMap.get(config) != null && !((Set)parentsMap.get(config)).isEmpty()) continue;
                    result.add(config);
                    removeSet.remove(config);
                }
                if (!((Set)entry.getValue()).isEmpty()) continue;
                entries.remove();
            }
            for (WebAppFragmentConfig config : removeSet) {
                parentsMap.remove(config);
            }
            if (result.size() != resultSize) continue;
            throw new ConfigException(L.l("web-fragments at '{0}' appear to have circular dependency. Consider using <absolute-ordering> in web.xml.", this));
        }
        for (WebAppFragmentConfig config : namedFragments.values()) {
            if (result.contains(config)) continue;
            result.add(config);
        }
        if (anonFragments.size() > 0) {
            result.addAll(anonFragments);
        }
        return result;
    }

    private List<WebAppFragmentConfig> getWebFragments(WebAppFragmentConfig config, Ordering ordering, Map<String, WebAppFragmentConfig> namedFragments, List<WebAppFragmentConfig> anonFragments) {
        if (ordering == null) {
            return null;
        }
        HashMap<String, WebAppFragmentConfig> others = new HashMap<String, WebAppFragmentConfig>(namedFragments);
        if (config != null) {
            others.remove(config.getName());
        }
        ArrayList<WebAppFragmentConfig> result = new ArrayList<WebAppFragmentConfig>();
        int othersIdx = -1;
        for (Object key : ordering.getOrder()) {
            if (key instanceof String) {
                WebAppFragmentConfig fragmentConfig = (WebAppFragmentConfig)others.remove(key);
                result.add(fragmentConfig);
                continue;
            }
            if (!ordering.isOthers(key)) continue;
            othersIdx = result.size();
        }
        if (othersIdx > -1) {
            result.ensureCapacity(result.size() + others.size());
            result.addAll(othersIdx, others.values());
            result.addAll(anonFragments);
            anonFragments.clear();
        }
        return result;
    }

    private void callInitializers() throws Exception {
        for (ServletContainerInitializer init : this._cdiManager.loadLocalServices(ServletContainerInitializer.class)) {
            init.onStartup(null, (ServletContext)this);
        }
    }

    public void initAnnotated() throws Exception {
        ArrayList listeners = new ArrayList();
        ArrayList servlets = new ArrayList();
        ArrayList filters = new ArrayList();
        ArrayList<String> pendingClasses = new ArrayList<String>(this._pendingClasses);
        this._pendingClasses.clear();
        for (String string : pendingClasses) {
            Class<?> cl = this._classLoader.loadClass(string);
            if (ServletContextListener.class.isAssignableFrom(cl)) {
                listeners.add(cl);
                continue;
            }
            if (ServletContextAttributeListener.class.isAssignableFrom(cl)) {
                listeners.add(cl);
                continue;
            }
            if (ServletRequestListener.class.isAssignableFrom(cl)) {
                listeners.add(cl);
                continue;
            }
            if (ServletRequestAttributeListener.class.isAssignableFrom(cl)) {
                listeners.add(cl);
                continue;
            }
            if (HttpSessionListener.class.isAssignableFrom(cl)) {
                listeners.add(cl);
                continue;
            }
            if (HttpSessionAttributeListener.class.isAssignableFrom(cl)) {
                listeners.add(cl);
                continue;
            }
            if (Servlet.class.isAssignableFrom(cl)) {
                servlets.add(cl);
                continue;
            }
            if (!Filter.class.isAssignableFrom(cl)) continue;
            filters.add(cl);
        }
        for (Class clazz : listeners) {
            WebListener webListener = clazz.getAnnotation(WebListener.class);
            if (webListener == null) continue;
            ListenerConfig listener = new ListenerConfig();
            listener.setListenerClass(clazz);
            this.addListener(listener);
        }
        for (Class clazz : filters) {
            WebFilter webFilter = clazz.getAnnotation(WebFilter.class);
            if (webFilter == null) continue;
            this.addFilter(webFilter, clazz.getName());
        }
        for (Class clazz : servlets) {
            ServletSecurity servletSecurity;
            WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
            if (webServlet != null) {
                this.addServlet(webServlet, clazz.getName());
            }
            if ((servletSecurity = clazz.getAnnotation(ServletSecurity.class)) == null) continue;
            this.addServletSecurity(clazz, servletSecurity);
        }
    }

    public WebAppAdmin getAdmin() {
        return this._controller.getAdmin();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void start() {
        boolean isOkay;
        ClassLoader oldLoader;
        Thread thread;
        block27: {
            block26: {
                if (!this._lifecycle.isAfterInit()) {
                    throw new IllegalStateException(L.l("webApp must be initialized before starting.  Currently in state {0}.", this._lifecycle.getStateName()));
                }
                thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                isOkay = true;
                try {
                    try {
                        thread.setContextClassLoader(this._classLoader);
                        if (!this._lifecycle.toStarting()) {
                            Object var13_4 = null;
                            if (!isOkay) {
                                this._lifecycle.toError();
                            }
                            break block26;
                        }
                        isOkay = false;
                        if (this._accessLog == null) {
                            this._accessLog = _accessLogLocal.get();
                        }
                        long interval = this._classLoader.getDependencyCheckInterval();
                        this._invocationDependency.setCheckInterval(interval);
                        if (this._parent != null) {
                            this._invocationDependency.add(this._parent.getWebAppGenerator());
                        }
                        this._invocationDependency.clearModified();
                        this._classLoader.clearModified();
                        String serverId = null;
                        Server server = Server.getCurrent();
                        if (server != null) {
                            serverId = server.getServerId();
                        }
                        if (serverId != null) {
                            this.setAttribute("caucho.server-id", serverId);
                        }
                        this._classLoader.start();
                        if (this._configException == null) {
                            this._configException = Environment.getConfigException();
                        }
                        try {
                            if (this.getSessionManager() != null) {
                                this.getSessionManager().start();
                            }
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.toString(), e);
                        }
                        this._jspApplicationContext.addELResolver(new CandiElResolver());
                        this.callInitializers();
                        ServletContextEvent event = new ServletContextEvent((ServletContext)this);
                        for (ListenerConfig listener : this._listeners) {
                            try {
                                this.addListenerObject(listener.createListenerObject(), false);
                            }
                            catch (Exception e) {
                                throw ConfigException.create(e);
                            }
                        }
                        for (int i = 0; i < this._webAppListeners.size(); ++i) {
                            ListenerConfig listener;
                            listener = this._webAppListeners.get(i);
                            try {
                                listener.contextInitialized(event);
                                continue;
                            }
                            catch (Exception e) {
                                log.log(Level.WARNING, e.toString(), e);
                            }
                        }
                        this.initAnnotated();
                        try {
                            this._filterManager.init();
                            this._servletManager.init();
                            this.initSecurityConstraints();
                        }
                        catch (Exception e) {
                            this.setConfigException(e);
                            throw e;
                        }
                        this._host.setConfigETag(null);
                        this._lifecycle.toActive();
                        this.clearCache();
                        isOkay = true;
                        break block27;
                    }
                    catch (Exception e) {
                        throw ConfigException.create(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_6 = null;
                    if (!isOkay) {
                        this._lifecycle.toError();
                    }
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
            thread.setContextClassLoader(oldLoader);
            return;
        }
        Object var13_5 = null;
        if (!isOkay) {
            this._lifecycle.toError();
        }
        thread.setContextClassLoader(oldLoader);
    }

    @Override
    public boolean isModified() {
        if (this._lifecycle.isAfterStopping()) {
            return true;
        }
        return this._classLoader.isModified();
    }

    @Override
    public boolean isModifiedNow() {
        this._classLoader.isModifiedNow();
        this._invocationDependency.isModifiedNow();
        return this.isModified();
    }

    @Override
    public boolean logModified(Logger log) {
        if (this._lifecycle.isAfterStopping()) {
            log.fine(this + " modified after stopping");
            return true;
        }
        return this._classLoader.logModified(log);
    }

    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        if (this._idleTime < 0L) {
            return false;
        }
        return this._lastRequestTime + this._idleTime < Alarm.getCurrentTime();
    }

    @Override
    public ServletContext getContext(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException(L.l("getContext URI must not be null."));
        }
        if (!uri.startsWith("/")) {
            if (uri.equals("")) {
                uri = "/";
            } else {
                throw new IllegalArgumentException(L.l("getContext URI '{0}' must be absolute.", uri));
            }
        }
        try {
            if (this._isDisableCrossContext) {
                return uri.startsWith(this.getContextPath()) ? this : null;
            }
            if (this._parent != null) {
                return this._parent.findSubWebAppByURI(uri);
            }
            return this;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public String getServletPattern(String uri) {
        return this._servletMapper.getServletPattern(uri);
    }

    public ArrayList<String> getServletMappingPatterns() {
        return this._servletMapper.getURLPatterns();
    }

    public ArrayList<String> getServletIgnoreMappingPatterns() {
        return this._servletMapper.getIgnorePatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invocation buildInvocation(Invocation invocation) {
        Object chain;
        ClassLoader oldLoader;
        Thread thread;
        block21: {
            block20: {
                thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this.getClassLoader());
                chain = null;
                if (this._configException == null) break block20;
                chain = new ExceptionFilterChain(this._configException);
                invocation.setFilterChain((FilterChain)chain);
                invocation.setDependency(AlwaysModified.create());
                Invocation invocation2 = invocation;
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                return invocation2;
            }
            if (this._lifecycle.waitForActive(this._activeWaitTime)) break block21;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " returned 503 busy for '" + invocation.getRawURI() + "'");
            }
            int code = 503;
            chain = new ErrorFilterChain(code);
            invocation.setFilterChain((FilterChain)chain);
            invocation.setDependency(AlwaysModified.create());
            Invocation invocation3 = invocation;
            Object var10_11 = null;
            thread.setContextClassLoader(oldLoader);
            return invocation3;
        }
        try {
            Invocation oldInvocation;
            FilterChainEntry entry = null;
            String query = invocation.getQueryString();
            boolean isCache = true;
            if (query != null && query.indexOf("jsp_precompile") >= 0) {
                isCache = false;
            } else if (this._requestRewriteDispatch != null) {
                isCache = false;
            }
            if (isCache) {
                entry = this._filterChainCache.get(invocation.getContextURI());
            }
            if (entry != null && !entry.isModified()) {
                chain = entry.getFilterChain();
                invocation.setServletName(entry.getServletName());
                if (!entry.isAsyncSupported()) {
                    invocation.clearAsyncSupported();
                }
                invocation.setMultipartConfig(entry.getMultipartConfig());
            } else {
                chain = this._servletMapper.mapServlet(invocation);
                if (this._requestRewriteDispatch != null) {
                    FilterChain newChain = this._requestRewriteDispatch.map(DispatcherType.REQUEST, invocation.getContextURI(), invocation.getQueryString(), (FilterChain)chain);
                    chain = newChain;
                }
                this._filterMapper.buildDispatchChain(invocation, (FilterChain)chain);
                chain = invocation.getFilterChain();
                entry = new FilterChainEntry((FilterChain)chain, invocation);
                chain = entry.getFilterChain();
                if (isCache) {
                    this._filterChainCache.put(invocation.getContextURI(), entry);
                }
            }
            if (this._isStatisticsEnabled) {
                chain = new StatisticsFilterChain((FilterChain)chain, this);
            }
            WebAppFilterChain webAppChain = new WebAppFilterChain((FilterChain)chain, this);
            webAppChain.setSecurityRoleMap(invocation.getSecurityRoleMap());
            chain = webAppChain;
            if (this._cache != null) {
                chain = this._cache.createFilterChain((FilterChain)chain, this);
            }
            if (this.getAccessLog() != null) {
                chain = new AccessLogFilterChain((FilterChain)chain, this);
            }
            invocation.setFilterChain((FilterChain)chain);
            invocation.setPathInfo(entry.getPathInfo());
            invocation.setServletPath(entry.getServletPath());
            if (this._oldWebApp != null && Alarm.getCurrentTime() < this._oldWebAppExpireTime) {
                oldInvocation = new Invocation();
                oldInvocation.copyFrom(invocation);
                oldInvocation.setWebApp(this._oldWebApp);
                this._oldWebApp.buildInvocation(oldInvocation);
                invocation = new VersionInvocation(invocation, this, oldInvocation, oldInvocation.getWebApp(), this._oldWebAppExpireTime);
            }
            oldInvocation = invocation;
            Object var10_12 = null;
            thread.setContextClassLoader(oldLoader);
            return oldInvocation;
        }
        catch (Throwable e) {
            try {
                log.log(Level.WARNING, e.toString(), e);
                Object chain2 = new ExceptionFilterChain(e);
                chain2 = new WebAppFilterChain((FilterChain)chain2, this);
                invocation.setDependency(AlwaysModified.create());
                invocation.setFilterChain((FilterChain)chain2);
                Invocation invocation4 = invocation;
                Object var10_13 = null;
                thread.setContextClassLoader(oldLoader);
                return invocation4;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    public ServletMapper getServletMapper() {
        return this._servletMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        WebAppContainer parent;
        Server server = this.getServer();
        if (server != null) {
            server.clearCache();
        }
        if ((parent = this._parent) != null) {
            parent.clearCache();
        }
        LruCache<String, FilterChainEntry> lruCache = this._filterChainCache;
        synchronized (lruCache) {
            this._filterChainCache.clear();
            this._dispatcherCache = null;
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._includeFilterMapper);
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._forwardFilterMapper);
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._errorFilterMapper);
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._loginFilterMapper);
    }

    public void buildDispatchInvocation(Invocation invocation) throws ServletException {
        this.buildDispatchInvocation(invocation, this._filterMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchInvocation(Invocation invocation, FilterMapper filterMapper) throws ServletException {
        invocation.setWebApp(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        try {
            try {
                ExceptionFilterChain chain;
                if (this._configException != null) {
                    chain = new ExceptionFilterChain(this._configException);
                    invocation.setDependency(AlwaysModified.create());
                } else if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                    UnavailableException exn = new UnavailableException(L.l("'{0}' is not currently available.", this.getContextPath()));
                    chain = new ExceptionFilterChain(exn);
                    invocation.setDependency(AlwaysModified.create());
                } else {
                    chain = this._servletMapper.mapServlet(invocation);
                    if (this._includeRewriteDispatch != null && filterMapper == this._includeFilterMapper) {
                        chain = this._includeRewriteDispatch.map(DispatcherType.INCLUDE, invocation.getContextURI(), invocation.getQueryString(), chain);
                    } else if (this._forwardRewriteDispatch != null && filterMapper == this._forwardFilterMapper) {
                        chain = this._forwardRewriteDispatch.map(DispatcherType.FORWARD, invocation.getContextURI(), invocation.getQueryString(), chain);
                    }
                    filterMapper.buildDispatchChain(invocation, chain);
                    chain = invocation.getFilterChain();
                    if (this._cache != null && filterMapper == this._includeFilterMapper) {
                        chain = this._cache.createFilterChain(chain, this);
                    }
                }
                invocation.setFilterChain(chain);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                ExceptionFilterChain chain = new ExceptionFilterChain(e);
                invocation.setFilterChain(chain);
                Object var8_10 = null;
                thread.setContextClassLoader(oldLoader);
            }
            Object var8_9 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    @Override
    public RequestDispatcherImpl getRequestDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url '{0}' must be absolute", url));
        }
        RequestDispatcherImpl disp = this.getDispatcherCache().get(url);
        if (disp != null && !disp.isModified()) {
            return disp;
        }
        SubInvocation includeInvocation = new SubInvocation();
        SubInvocation forwardInvocation = new SubInvocation();
        SubInvocation errorInvocation = new SubInvocation();
        SubInvocation dispatchInvocation = new SubInvocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = this.escapeURL(this.getContextPath() + url);
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            decoder.splitQuery(dispatchInvocation, rawURI);
            boolean isSameWebApp = false;
            if (this._parent != null) {
                WebAppController subController = this._parent.getWebAppController(includeInvocation);
                this._parent.getWebAppController(forwardInvocation);
                this._parent.getWebAppController(errorInvocation);
                this._parent.getWebAppController(dispatchInvocation);
                if (subController != null && this._controller.getContextPath().equals(subController.getContextPath())) {
                    isSameWebApp = true;
                }
            }
            if (this._parent != null && !isSameWebApp) {
                this._parent.buildIncludeInvocation(includeInvocation);
                this._parent.buildForwardInvocation(forwardInvocation);
                this._parent.buildErrorInvocation(errorInvocation);
                this._parent.buildDispatchInvocation(dispatchInvocation);
            } else {
                if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                    throw new IllegalStateException(L.l("web-app '{0}' is restarting and is not yet ready to receive requests", this.getVersionContextPath()));
                }
                this.buildIncludeInvocation(includeInvocation);
                this.buildForwardInvocation(forwardInvocation);
                this.buildErrorInvocation(errorInvocation);
                this.buildDispatchInvocation(dispatchInvocation);
            }
            disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, dispatchInvocation, this);
            this.getDispatcherCache().put(url, disp);
            return disp;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public void accessLog(HttpServletRequest req, HttpServletResponse res) throws IOException {
        AbstractAccessLog log = this.getAccessLog();
        if (log != null) {
            log.log(req, res, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LruCache<String, RequestDispatcherImpl> getDispatcherCache() {
        LruCache<String, RequestDispatcherImpl> cache = this._dispatcherCache;
        if (cache != null) {
            return cache;
        }
        WebApp webApp = this;
        synchronized (webApp) {
            this._dispatcherCache = cache = new LruCache(1024);
            return cache;
        }
    }

    private String escapeURL(String url) {
        return url;
    }

    public RequestDispatcher getLoginDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url '{0}' must be absolute", url));
        }
        Invocation loginInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = this.getContextPath() + url;
        try {
            decoder.splitQuery(loginInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            if (!this._lifecycle.waitForActive(this._activeWaitTime)) {
                throw new IllegalStateException(L.l("'{0}' is restarting and it not yet ready to receive requests", this.getVersionContextPath()));
            }
            if (this._parent != null) {
                this._parent.buildInvocation(loginInvocation);
                this._parent.buildErrorInvocation(errorInvocation);
            } else {
                FilterChain chain = this._servletMapper.mapServlet(loginInvocation);
                this._filterMapper.buildDispatchChain(loginInvocation, chain);
                chain = this._servletMapper.mapServlet(errorInvocation);
                this._errorFilterMapper.buildDispatchChain(errorInvocation, chain);
            }
            RequestDispatcherImpl disp = new RequestDispatcherImpl(loginInvocation, loginInvocation, errorInvocation, loginInvocation, this);
            disp.setLogin(true);
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String servletName) {
        try {
            ServletInvocation invocation = null;
            FilterChain chain = this._servletManager.createServletChain(servletName, null, invocation);
            FilterChain includeChain = this._includeFilterMapper.buildFilterChain(chain, servletName);
            FilterChain forwardChain = this._forwardFilterMapper.buildFilterChain(chain, servletName);
            return new NamedDispatcherImpl(includeChain, forwardChain, null, this);
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    @Override
    public String getRealPath(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        String realPath = this._realPathCache.get(uri);
        if (realPath != null) {
            return realPath;
        }
        String fullURI = this.getContextPath() + "/" + uri;
        try {
            fullURI = this.getInvocationDecoder().normalizeUri(fullURI);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        WebApp app = (WebApp)this.getContext(fullURI);
        if (app == null) {
            return null;
        }
        String cp = app.getContextPath();
        String tail = fullURI.substring(cp.length());
        realPath = app.getRealPathImpl(tail);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("real-path " + uri + " -> " + realPath);
        }
        this._realPathCache.put(uri, realPath);
        return realPath;
    }

    public String getRealPathImpl(String uri) {
        return this.createRewriteRealPath().mapToRealPath(uri);
    }

    @Override
    public String getMimeType(String uri) {
        if (uri == null) {
            return null;
        }
        String fullURI = this.getContextPath() + "/" + uri;
        try {
            fullURI = this.getInvocationDecoder().normalizeUri(fullURI);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        WebApp webApp = (WebApp)this.getContext(fullURI);
        if (webApp == null) {
            return null;
        }
        int p = uri.lastIndexOf(46);
        if (p < 0) {
            return null;
        }
        return webApp.getMimeTypeImpl(uri.substring(p));
    }

    public String getMimeTypeImpl(String ext) {
        return this._mimeMapping.get(ext);
    }

    @Override
    public void log(String message, Throwable e) {
        if (e != null) {
            log.log(Level.WARNING, this + " " + message, e);
        } else {
            log.info(this + " " + message);
        }
    }

    public Login getLogin() {
        if (this._login != null) {
            return this._login;
        }
        return this._defaultLogin;
    }

    public Login getConfiguredLogin() {
        return this._login;
    }

    public Authenticator getAuthenticator() {
        Login login = this.getLogin();
        if (login != null) {
            return login.getAuthenticator();
        }
        return null;
    }

    public Authenticator getConfiguredAuthenticator() {
        Login login = this.getConfiguredLogin();
        if (login != null) {
            return login.getAuthenticator();
        }
        return this._authenticator;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this.getSessionManager();
    }

    public SessionManager getSessionManager() {
        if (this._sessionManager == null) {
            if (this._lifecycle.isStopped()) {
                throw new IllegalStateException(L.l("Resin is shutting down."));
            }
            if (this._isInheritSession && this._parent != null) {
                this._sessionManager = this._parent.getSessionManager();
            }
            if (this._sessionManager == null) {
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                try {
                    try {
                        thread.setContextClassLoader(this.getClassLoader());
                        this._sessionManager = new SessionManager(this);
                    }
                    catch (Throwable e) {
                        throw ConfigException.create(e);
                    }
                    Object var5_3 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    thread.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
        }
        return this._sessionManager;
    }

    public ErrorPageManager getErrorPageManager() {
        if (this._errorPageManager == null) {
            this._errorPageManager = new ErrorPageManager(this._server, this);
            this._errorPageManager.setParent(this._host.getErrorPageManager());
        }
        return this._errorPageManager;
    }

    final boolean enterWebApp() {
        this._requestCount.incrementAndGet();
        this._lastRequestTime = Alarm.getCurrentTime();
        return this._lifecycle.isActive();
    }

    final void exitWebApp() {
        this._requestCount.decrementAndGet();
    }

    public int getRequestCount() {
        return this._requestCount.get();
    }

    public void addCacheMapping(CacheMapping mapping) throws Exception {
        if (mapping.getUrlRegexp() != null) {
            this._cacheMappingMap.addRegexp(mapping.getUrlRegexp(), mapping);
        } else {
            this._cacheMappingMap.addMap(mapping.getUrlPattern(), mapping);
        }
    }

    public long getMaxAge(String uri) {
        CacheMapping map = this._cacheMappingMap.map(uri);
        if (map != null) {
            return map.getMaxAge();
        }
        return Long.MIN_VALUE;
    }

    public long getSMaxAge(String uri) {
        CacheMapping map = this._cacheMappingMap.map(uri);
        if (map != null) {
            return map.getSMaxAge();
        }
        return Long.MIN_VALUE;
    }

    public long getCacheMaxLength() {
        return this._cache.getMaxEntrySize();
    }

    public String[] getClassLoaderHackPackages() {
        return _classLoaderHackPackages;
    }

    public int getActiveSessionCount() {
        SessionManager manager = this.getSessionManager();
        if (manager != null) {
            return manager.getActiveSessionCount();
        }
        return 0;
    }

    public String generateCookieDomain(HttpServletRequest request) {
        String serverName = request.getServerName();
        if (this._cookieDomainPattern == null) {
            return this._sessionManager.getCookieDomain();
        }
        Matcher matcher = this._cookieDomainPattern.matcher(serverName);
        String domain = matcher.find() ? matcher.group() : null;
        return domain;
    }

    void updateStatistics(long time, int readBytes, int writeBytes, boolean isClientDisconnect) {
        this._controller.updateStatistics(time, readBytes, writeBytes, isClientDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Object listener;
            int i;
            thread.setContextClassLoader(this.getClassLoader());
            if (!this._lifecycle.toStopping()) {
                Object var11_3 = null;
                thread.setContextClassLoader(oldLoader);
                this._lifecycle.toStop();
                return;
            }
            long beginStop = Alarm.getCurrentTime();
            while (this._requestCount.get() > 0 && Alarm.getCurrentTime() < beginStop + this._shutdownWaitTime && !Alarm.isTest()) {
                try {
                    Thread.interrupted();
                    Thread.sleep(100L);
                }
                catch (Throwable e) {}
            }
            if (this._requestCount.get() > 0) {
                log.warning(L.l("{0} closing with {1} active requests.", (Object)this.toString(), this._requestCount));
            }
            ServletContextEvent event = new ServletContextEvent((ServletContext)this);
            SessionManager sessionManager = this._sessionManager;
            this._sessionManager = null;
            if (!(sessionManager == null || this._isInheritSession && this._controller.getParent() != null)) {
                sessionManager.close();
            }
            if (this._servletManager != null) {
                this._servletManager.destroy();
            }
            if (this._filterManager != null) {
                this._filterManager.destroy();
            }
            if (this._webAppListeners != null) {
                for (i = this._webAppListeners.size() - 1; i >= 0; --i) {
                    listener = this._webAppListeners.get(i);
                    try {
                        listener.contextDestroyed(event);
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            for (i = this._listeners.size() - 1; i >= 0; --i) {
                listener = this._listeners.get(i);
                try {
                    ((ListenerConfig)listener).destroy();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            try {
                this._classLoader.stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        catch (Throwable throwable) {
            Object var11_5 = null;
            thread.setContextClassLoader(oldLoader);
            this._lifecycle.toStop();
            throw throwable;
        }
        Object var11_4 = null;
        thread.setContextClassLoader(oldLoader);
        this._lifecycle.toStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        this.clearCache();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            for (int i = this._appGenerators.size() - 1; i >= 0; --i) {
                try {
                    DeployGenerator<WebAppController> deploy = this._appGenerators.get(i);
                    this._parent.removeWebAppDeploy(deploy);
                    deploy.destroy();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            AbstractAccessLog accessLog = this._accessLog;
            this._accessLog = null;
            if (accessLog != null) {
                try {
                    accessLog.flush();
                    accessLog.destroy();
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            Object var6_8 = null;
            thread.setContextClassLoader(oldLoader);
            this._classLoader.destroy();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            thread.setContextClassLoader(oldLoader);
            this._classLoader.destroy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatus500() {
        WebApp webApp = this;
        synchronized (webApp) {
            ++this._status500CountTotal;
            this._status500LastTime = Alarm.getExactTime();
        }
    }

    long getStatus500CountTotal() {
        return this._status500CountTotal;
    }

    long getStatus500LastTime() {
        return this._status500LastTime;
    }

    @Override
    public int getScanPriority() {
        return 2;
    }

    @Override
    public boolean isRootScannable(Path root, String packageRoot) {
        return true;
    }

    @Override
    public ScanClass scanClass(Path root, String packageRoot, String name, int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return new WebScanClass(name);
        }
        return null;
    }

    @Override
    public boolean isScanMatchAnnotation(CharBuffer string) {
        return string.startsWith("javax.servlet.annotation.");
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
        this._pendingClasses.add(className);
    }

    private Object writeReplace() {
        return new SingletonBindingHandle(WebApp.class, new Annotation[0]);
    }

    public String toString() {
        if (this._lifecycle == null) {
            return "WebApp[" + this.getId() + "]";
        }
        if (this._lifecycle.isActive()) {
            return "WebApp[" + this.getId() + "]";
        }
        return "WebApp[" + this.getId() + "," + (Object)((Object)this._lifecycle.getState()) + "]";
    }

    class WebScanClass
    extends AbstractScanClass {
        private String _className;
        private boolean _isValid;

        WebScanClass(String className) {
            this._className = className;
        }

        public void addClassAnnotation(char[] buffer, int offset, int length) {
            if (length < SERVLET_ANNOTATION.length) {
                return;
            }
            for (int i = SERVLET_ANNOTATION.length - 1; i >= 0; --i) {
                if (buffer[offset + i] == SERVLET_ANNOTATION[i]) continue;
                return;
            }
            this._isValid = true;
        }

        public void finishScan() {
            if (this._isValid) {
                WebApp.this._pendingClasses.add(this._className);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterChainEntry {
        FilterChain _filterChain;
        String _pathInfo;
        String _servletPath;
        String _servletName;
        HashMap<String, String> _securityRoleMap;
        final Dependency _dependency;
        boolean _isAsyncSupported;
        MultipartConfigElement _multipartConfig;

        FilterChainEntry(FilterChain filterChain, Invocation invocation) {
            this._filterChain = filterChain;
            this._pathInfo = invocation.getPathInfo();
            this._servletPath = invocation.getServletPath();
            this._servletName = invocation.getServletName();
            this._dependency = invocation.getDependency();
            this._isAsyncSupported = invocation.isAsyncSupported();
            this._multipartConfig = invocation.getMultipartConfig();
        }

        boolean isModified() {
            return this._dependency != null && this._dependency.isModified();
        }

        FilterChain getFilterChain() {
            return this._filterChain;
        }

        HashMap<String, String> getSecurityRoleMap() {
            return this._securityRoleMap;
        }

        void setSecurityRoleMap(HashMap<String, String> roleMap) {
            this._securityRoleMap = roleMap;
        }

        String getPathInfo() {
            return this._pathInfo;
        }

        String getServletPath() {
            return this._servletPath;
        }

        String getServletName() {
            return this._servletName;
        }

        boolean isAsyncSupported() {
            return this._isAsyncSupported;
        }

        public MultipartConfigElement getMultipartConfig() {
            return this._multipartConfig;
        }
    }

    static class WebAppSessionListener
    implements HttpSessionListener {
        WebAppSessionListener() {
        }

        public void sessionCreated(HttpSessionEvent se) {
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            HttpSession session = se.getSession();
            SessionContextContainer candiContainer = (SessionContextContainer)session.getAttribute("resin.candi.scope");
            if (candiContainer != null) {
                candiContainer.close();
            }
        }
    }
}

