/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class BeanMBean<T>
implements DynamicMBean {
    private static final L10N L = new L10N(BeanMBean.class);
    private static final Logger log = Logger.getLogger(BeanMBean.class.getName());
    private InjectManager _injectManager;
    private Bean<T> _bean;
    private MBeanInfo _info;
    private HashMap<String, Method> _attrMap = new HashMap();

    BeanMBean(InjectManager manager, Bean<T> bean, AnnotatedType<T> type) {
        try {
            this._injectManager = manager;
            this._bean = bean;
            MBeanAttributeInfo[] attrInfo = this.parseMethods(this._bean, type);
            this._info = new MBeanInfo(this._bean.getBeanClass().getName(), null, attrInfo, new MBeanConstructorInfo[0], new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private MBeanAttributeInfo[] parseMethods(Bean<T> bean, AnnotatedType<T> type) throws IntrospectionException {
        ArrayList<MBeanAttributeInfo> list = new ArrayList<MBeanAttributeInfo>();
        for (Method method : bean.getBeanClass().getMethods()) {
            String name = method.getName();
            if (method.getParameterTypes().length != 0 || !Modifier.isPublic(method.getModifiers()) || !name.startsWith("get")) continue;
            name = name.substring(3);
            MBeanAttributeInfo attr = new MBeanAttributeInfo(name, null, method, null);
            list.add(attr);
            this._attrMap.put(name, method);
        }
        MBeanAttributeInfo[] info = new MBeanAttributeInfo[list.size()];
        list.toArray(info);
        return info;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method method = this._attrMap.get(attribute);
        if (method == null) {
            throw new AttributeNotFoundException(L.l("'{0}' is an unknown attribute in {1}", (Object)attribute, this));
        }
        CreationalContext<T> env = this._injectManager.createCreationalContext(this._bean);
        Object value = this._injectManager.getReference(this._bean, this._bean.getBeanClass(), env);
        try {
            return method.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException((Exception)e.getCause());
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attr : attributes) {
            try {
                list.add(this.getAttribute(attr));
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this._info;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

