/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.CauchoDeployment;
import com.caucho.config.ContextDependent;
import com.caucho.jmx.Jmx;
import com.caucho.security.SecurityContext;
import com.caucho.security.SecurityContextException;
import com.caucho.server.util.ScheduledThreadPool;
import com.caucho.server.webbeans.ConversationContext;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionProxy;
import java.security.Principal;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CauchoDeployment
@Singleton
public class ResinCdiProducer {
    private static final Logger log = Logger.getLogger(ResinCdiProducer.class.getName());

    @Produces
    @Named(value="javax.enterprise.context.conversation")
    @RequestScoped
    public ConversationContext getConversation() {
        return new ConversationContext();
    }

    public void destroy(@Disposes @Named(value="javax.enterprise.context.conversation") ConversationContext conversation) {
        conversation.destroy();
    }

    @Produces
    @CauchoDeployment
    public MBeanServer getMBeanServer() {
        return Jmx.getGlobalMBeanServer();
    }

    @Produces
    @CauchoDeployment
    public TransactionManager getTransactionManager() {
        return TransactionManagerImpl.getInstance();
    }

    @Produces
    @CauchoDeployment
    public UserTransaction getUserTransaction() {
        return UserTransactionProxy.getInstance();
    }

    @Produces
    @CauchoDeployment
    public TransactionSynchronizationRegistry getSyncRegistry() {
        return TransactionManagerImpl.getInstance().getSyncRegistry();
    }

    @Produces
    @CauchoDeployment
    @ContextDependent
    public ScheduledExecutorService getScheduledExecutorService() {
        return ScheduledThreadPool.getLocal();
    }

    @Produces
    @CauchoDeployment
    @ContextDependent
    public Principal getPrincipal() {
        try {
            return SecurityContext.getUserPrincipal();
        }
        catch (SecurityContextException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public static Class<?> createResinValidatorProducer() {
        try {
            Class<?> cl = Class.forName("com.caucho.server.webbeans.ResinValidatorProducer");
            cl.getMethods();
            return cl;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }
}

