/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.ejb.inject.EjbGeneratedBean;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.inject.LazyExtension;
import com.caucho.inject.MBean;
import com.caucho.inject.Module;
import com.caucho.jms.JmsMessageListener;
import com.caucho.jmx.Jmx;
import com.caucho.naming.Jndi;
import com.caucho.remote.BamService;
import com.caucho.server.admin.AdminService;
import com.caucho.server.cluster.Server;
import com.caucho.server.webbeans.BeanMBean;
import com.caucho.server.webbeans.JndiBeanProxy;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ResinStandardPlugin
implements Extension {
    private static final L10N L = new L10N(ResinStandardPlugin.class);
    private static final Logger log = Logger.getLogger(ResinStandardPlugin.class.getName());
    private static final HashSet<Class<? extends Annotation>> _ejbAnnotations = new HashSet();
    private InjectManager _cdiManager;

    public ResinStandardPlugin(InjectManager manager) {
        this._cdiManager = manager;
    }

    public void processAfterBeanDiscovery(@Observes AfterBeanDiscovery event) {
    }

    @LazyExtension
    public void processAnnotatedType(@Observes ProcessAnnotatedType<?> event) {
        this.processAnnotatedTypeImpl(event);
    }

    private <T> void processAnnotatedTypeImpl(ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (annotatedType == null) {
            return;
        }
        boolean isXmlConfig = true;
        EjbManager ejbContainer = EjbManager.create(this._cdiManager.getClassLoader());
        if (isXmlConfig && (annotatedType.isAnnotationPresent(Stateful.class) || annotatedType.isAnnotationPresent(Stateless.class) || annotatedType.isAnnotationPresent(Singleton.class) || annotatedType.isAnnotationPresent(MessageDriven.class) || annotatedType.isAnnotationPresent(JmsMessageListener.class) || ejbContainer != null && ejbContainer.isConfiguredBean(annotatedType.getJavaClass())) && ejbContainer != null) {
            ejbContainer.createBean(annotatedType, null);
            event.veto();
        }
    }

    @LazyExtension
    public void processBean(@Observes ProcessBean<?> event) {
        this.processBeanImpl(event);
    }

    private <T> void processBeanImpl(ProcessBean<T> event) {
        Annotation service;
        Annotated annotated = event.getAnnotated();
        Bean bean = event.getBean();
        if (annotated == null) {
            return;
        }
        if (!(bean instanceof EjbGeneratedBean) && (annotated.isAnnotationPresent(Stateful.class) || annotated.isAnnotationPresent(Stateless.class) || annotated.isAnnotationPresent(Singleton.class) || annotated.isAnnotationPresent(MessageDriven.class) || annotated.isAnnotationPresent(JmsMessageListener.class))) {
            EjbManager ejbContainer = EjbManager.create();
            if (bean instanceof ManagedBeanImpl) {
                throw new IllegalStateException(String.valueOf(annotated));
            }
        }
        if (annotated.isAnnotationPresent(com.caucho.inject.Jndi.class)) {
            com.caucho.inject.Jndi jndi = (com.caucho.inject.Jndi)annotated.getAnnotation(com.caucho.inject.Jndi.class);
            String jndiName = jndi.value();
            if ("".equals(jndiName)) {
                jndiName = bean.getBeanClass().getSimpleName();
            }
            JndiBeanProxy proxy = new JndiBeanProxy(this._cdiManager, bean);
            if (log.isLoggable(Level.FINE)) {
                log.fine("bind to JNDI '" + jndiName + "' for " + bean);
            }
            try {
                Jndi.bindDeepShort(jndiName, proxy);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (annotated.isAnnotationPresent(MBean.class)) {
            MBean manage = (MBean)annotated.getAnnotation(MBean.class);
            String mbeanName = manage.value();
            if ("".equals(mbeanName)) {
                mbeanName = "type=" + bean.getBeanClass().getSimpleName();
            }
            AnnotatedType annType = (AnnotatedType)annotated;
            try {
                Jmx.register(new BeanMBean(this._cdiManager, bean, annType), mbeanName);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (annotated.isAnnotationPresent(BamService.class)) {
            service = (BamService)annotated.getAnnotation(BamService.class);
            HempBroker broker = HempBroker.getCurrent();
            broker.addStartupActor(event.getBean(), service.name(), service.threadMax());
        }
        if (annotated.isAnnotationPresent(AdminService.class)) {
            service = (AdminService)annotated.getAnnotation(AdminService.class);
            Server server = Server.getCurrent();
            if (server == null) {
                throw new ConfigException(L.l("@AdminService requires an active Resin Server."));
            }
            if (!server.isWatchdog()) {
                HempBroker broker = (HempBroker)server.getAdminBroker();
                broker.addStartupActor(event.getBean(), service.name(), service.threadMax());
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static {
        _ejbAnnotations.add(Stateful.class);
        _ejbAnnotations.add(Stateless.class);
        _ejbAnnotations.add(Singleton.class);
        _ejbAnnotations.add(MessageDriven.class);
        _ejbAnnotations.add(JmsMessageListener.class);
    }
}

