/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.URLUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Iterator;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryServlet
extends HttpServlet {
    WebApp _app;
    Path _context;
    private boolean _enable = true;

    public DirectoryServlet(Path context) {
        this._context = context;
    }

    public DirectoryServlet() {
        this(Vfs.lookup());
    }

    public void setEnable(boolean enable) {
        this._enable = enable;
    }

    public void init() {
        this._app = (WebApp)this.getServletContext();
        this._context = this._app.getRootDirectory();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String pathInfo;
        if (!this._enable) {
            res.sendError(404);
            return;
        }
        CauchoRequest cauchoReq = null;
        if (req instanceof CauchoRequest) {
            cauchoReq = (CauchoRequest)req;
        }
        String uri = req.getRequestURI();
        boolean redirect = false;
        String encoding = CharacterEncoding.getLocalEncoding();
        if (encoding == null) {
            res.setContentType("text/html");
        } else {
            res.setContentType("text/html; charset=" + encoding);
        }
        boolean isInclude = false;
        if (cauchoReq != null) {
            uri = cauchoReq.getPageURI();
            isInclude = !uri.equals(cauchoReq.getRequestURI());
        } else {
            uri = (String)req.getAttribute("javax.servlet.include.request_uri");
            if (uri != null) {
                isInclude = true;
            } else {
                uri = req.getRequestURI();
            }
        }
        StringBuilder cb = new StringBuilder();
        String servletPath = cauchoReq != null ? cauchoReq.getPageServletPath() : (isInclude ? (String)req.getAttribute("javax.servlet.include.servlet_path") : req.getServletPath());
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = cauchoReq != null ? cauchoReq.getPagePathInfo() : (isInclude ? (String)req.getAttribute("javax.servlet.include.path_info") : req.getPathInfo())) != null) {
            cb.append(pathInfo);
        }
        String relPath = cb.toString();
        String filename = this.getServletContext().getRealPath(relPath);
        Path path = this._context.lookupNative(filename);
        if (CauchoSystem.isWindows() && path.isWindowsInsecure()) {
            res.sendError(404);
            return;
        }
        if (uri.length() > 0 && uri.charAt(uri.length() - 1) != '/') {
            res.sendRedirect(uri + "/");
            return;
        }
        String rawpath = URLDecoder.decode(uri);
        PrintWriter pw = res.getWriter();
        if (rawpath.length() == 0 || rawpath.charAt(0) != '/') {
            rawpath = "/" + rawpath;
        }
        boolean endsSlash = rawpath.charAt(rawpath.length() - 1) == '/';
        String tail = "";
        if (!endsSlash) {
            int p = rawpath.lastIndexOf(47);
            tail = rawpath.substring(p + 1) + "/";
            rawpath = rawpath + "/";
        }
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>Directory of " + rawpath + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Directory of " + rawpath + "</h1>");
        pw.println("<ul>");
        Iterator<String> i = path.iterator();
        while (i.hasNext()) {
            String name = i.next();
            if (name.equalsIgnoreCase("web-inf") || name.equalsIgnoreCase("meta-inf")) continue;
            String enc = URLUtil.encodeURL(tail + name);
            pw.println("<li><a href='" + enc + "'>" + name + "</a>");
        }
        pw.println("</ul>");
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }
}

