/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.spy.SpyConnection;
import com.caucho.sql.spy.SpyDataSource;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class SpyPooledConnection
implements PooledConnection {
    protected static final Logger log = Logger.getLogger(SpyPooledConnection.class.getName());
    protected static final L10N L = new L10N(SpyPooledConnection.class);
    protected String _id;
    private SpyDataSource _spyDataSource = new SpyDataSource();
    private int _connCount;
    private PooledConnection _pconn;

    public SpyPooledConnection(PooledConnection conn, String id) {
        this._pconn = conn;
        this._id = id;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.removeConnectionEventListener(listener);
    }

    public Connection getConnection() throws SQLException {
        try {
            Connection conn = this._pconn.getConnection();
            String connId = null;
            if (log.isLoggable(Level.FINE)) {
                connId = this._spyDataSource.createConnectionId();
                log.fine(this._id + ":connect() -> " + connId + ":" + conn);
            }
            return new SpyConnection(conn, this._spyDataSource, connId);
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public void close() throws SQLException {
        try {
            this._pconn.close();
            log.fine(this._id + ":close()");
        }
        catch (SQLException e) {
            log.fine(this._id + ":exn-close(" + e + ")");
            throw e;
        }
    }

    public String toString() {
        return "SpyPooledConnection[id=" + this._id + ",conn=" + this._pconn + "]";
    }

    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

