/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpyPreparedStatement
extends SpyStatement
implements PreparedStatement {
    private static final Logger log = Logger.getLogger(SpyPreparedStatement.class.getName());
    protected static L10N L = new L10N(SpyPreparedStatement.class);
    private String _sql;
    protected PreparedStatement _pstmt;

    SpyPreparedStatement(String id, SpyConnection conn, PreparedStatement stmt, String sql) {
        super(id, conn, stmt);
        this._pstmt = stmt;
        this._sql = sql;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":executeQuery(" + this._sql + ")");
            }
            ResultSet rs = this._pstmt.executeQuery();
            return rs;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-executeQuery(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            int result = this._pstmt.executeUpdate();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":executeUpdate(" + this._sql + ") -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-executeUpdate(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean execute() throws SQLException {
        try {
            boolean result = this._pstmt.execute();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":execute(" + this._sql + ") -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-execute(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this._pstmt.addBatch();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":addBatch()");
            }
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-addBatch(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":clearParameters()");
            }
            this._pstmt.clearParameters();
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-clearParameters(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            ResultSetMetaData result = this._pstmt.getMetaData();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":getMetaData() -> " + result);
            }
            return result;
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-getMetaData(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this._pstmt.getParameterMetaData();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNull(" + parameterIndex + ",type=" + sqlType + ")");
            }
            this._pstmt.setNull(parameterIndex, sqlType);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNull(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNull(" + parameterIndex + ",type=" + sqlType + ",typeName=" + typeName + ")");
            }
            this._pstmt.setNull(parameterIndex, sqlType, typeName);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNull(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBoolean(int index, boolean value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBoolean(" + index + "," + value + ")");
            }
            this._pstmt.setBoolean(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBoolean(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setByte(int index, byte value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setByte(" + index + "," + value + ")");
            }
            this._pstmt.setByte(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setByte(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setShort(int index, short value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setShort(" + index + "," + value + ")");
            }
            this._pstmt.setShort(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setShort(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setInt(int index, int value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setInt(" + index + "," + value + ")");
            }
            this._pstmt.setInt(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setInt(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setLong(int index, long value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setLong(" + index + "," + value + ")");
            }
            this._pstmt.setLong(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setLong(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setFloat(int index, float value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setFloat(" + index + "," + value + ")");
            }
            this._pstmt.setFloat(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setFloat(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDouble(int index, double value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setDouble(" + index + "," + value + ")");
            }
            this._pstmt.setDouble(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setDouble(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBigDecimal(int index, BigDecimal value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBigDecimal(" + index + "," + value + ")");
            }
            this._pstmt.setBigDecimal(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBigDecimal(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setString(int index, String value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setString(" + index + "," + value + ")");
            }
            this._pstmt.setString(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setString(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBytes(int index, byte[] value) throws SQLException {
        try {
            if (value != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getId() + ":setBytes(" + index + ",len=" + value.length + ")");
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getId() + ":setBytes(" + index + ",null");
                }
            }
            this._pstmt.setBytes(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBytes(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDate(int index, Date value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setDate(" + index + "," + value + ")");
            }
            this._pstmt.setDate(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setDate(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setDate(int index, Date value, Calendar cal) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setDate(" + index + "," + value + ",cal=" + cal + ")");
            }
            this._pstmt.setDate(index, value, cal);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setDate(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTime(int index, Time value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setTime(" + index + "," + value + ")");
            }
            this._pstmt.setTime(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setTime(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTime(int index, Time value, Calendar cal) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setTime(" + index + "," + value + ",cal=" + cal + ")");
            }
            this._pstmt.setTime(index, value, cal);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setTime(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTimestamp(int index, Timestamp value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setTimestamp(" + index + "," + value + ")");
            }
            this._pstmt.setTimestamp(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setTimestamp(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTimestamp(int index, Timestamp value, Calendar cal) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setTimestamp(" + index + "," + value + ",cal=" + cal + ")");
            }
            this._pstmt.setTimestamp(index, value, cal);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setTimestamp(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setAsciiStream(int index, InputStream value, int length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setAsciiStream(" + index + "," + value + ",len=" + length + ")");
            }
            this._pstmt.setAsciiStream(index, value, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setAsciiStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setUnicodeStream(int index, InputStream value, int length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setUnicodeStream(" + index + "," + value + ",len=" + length + ")");
            }
            this._pstmt.setUnicodeStream(index, value, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setUnicodeStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBinaryStream(int index, InputStream value, int length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBinaryStream(" + index + "," + value + ",len=" + length + ")");
            }
            this._pstmt.setBinaryStream(index, value, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBinaryStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCharacterStream(int index, Reader value, int length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setCharacterStream(" + index + "," + value + ",len=" + length + ")");
            }
            this._pstmt.setCharacterStream(index, value, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setCharacterStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value, int type, int scale) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setObject(" + index + "," + value + ",type=" + type + ",scale=" + scale + ")");
            }
            this._pstmt.setObject(index, value, type, scale);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setObject(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value, int type) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setObject(" + index + "," + value + ",type=" + type + ")");
            }
            this._pstmt.setObject(index, value, type);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setObject(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setObject(int index, Object value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setObject(" + index + "," + value + ")");
            }
            this._pstmt.setObject(index, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setObject(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setRef(int index, Ref value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setRef(" + index + "," + value + ")");
            }
            this._pstmt.setRef(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setRef(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBlob(int index, Blob value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBlob(" + index + "," + value + ")");
            }
            this._pstmt.setBlob(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBlob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setClob(int index, Clob value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setClob(" + index + "," + value + ")");
            }
            this._pstmt.setClob(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setClob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setArray(int index, Array value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setArray(" + index + "," + value + ")");
            }
            this._pstmt.setArray(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setArray(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setURL(int index, URL value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setURL(" + index + "," + value + ")");
            }
            this._pstmt.setURL(index, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setURL(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setRowId(" + parameterIndex + "," + x + ")");
            }
            this._pstmt.setRowId(parameterIndex, x);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setRowId(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNString(" + parameterIndex + "," + value + ")");
            }
            this._pstmt.setNString(parameterIndex, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNString(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNCharacterStream(" + parameterIndex + "," + value + "," + length + ")");
            }
            this._pstmt.setNCharacterStream(parameterIndex, value, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNCharacterStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNClob(" + parameterIndex + "," + value + ")");
            }
            this._pstmt.setNClob(parameterIndex, value);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNClob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setClob(" + parameterIndex + "," + reader + "," + length + ")");
            }
            this._pstmt.setClob(parameterIndex, reader, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setClob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBlob(" + parameterIndex + "," + inputStream + "," + length + ")");
            }
            this._pstmt.setBlob(parameterIndex, inputStream, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBlob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNClob(" + parameterIndex + "," + reader + "," + length + ")");
            }
            this._pstmt.setNClob(parameterIndex, reader, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNClob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setSQLXML(" + parameterIndex + "," + xmlObject + ")");
            }
            this._pstmt.setSQLXML(parameterIndex, xmlObject);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setSQLXML(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setAsciiStream(" + parameterIndex + "," + x + "," + length + ")");
            }
            this._pstmt.setAsciiStream(parameterIndex, x, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setAsciiStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBinaryStream(" + parameterIndex + "," + x + "," + length + ")");
            }
            this._pstmt.setBinaryStream(parameterIndex, x, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBinaryStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setCharacterStream(" + parameterIndex + "," + reader + "," + length + ")");
            }
            this._pstmt.setCharacterStream(parameterIndex, reader, length);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setCharacterStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setAsciiStream(" + parameterIndex + "," + x + ")");
            }
            this._pstmt.setAsciiStream(parameterIndex, x);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setAsciiStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBinaryStream(" + parameterIndex + "," + x + ")");
            }
            this._pstmt.setBinaryStream(parameterIndex, x);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBinaryStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setCharacterStream(" + parameterIndex + "," + reader + ")");
            }
            this._pstmt.setCharacterStream(parameterIndex, reader);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setCharacterStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNCharacterStream(" + parameterIndex + "," + reader + ")");
            }
            this._pstmt.setNCharacterStream(parameterIndex, reader);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNCharacterStream(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setClob(" + parameterIndex + "," + reader + ")");
            }
            this._pstmt.setClob(parameterIndex, reader);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setClob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setBlob(" + parameterIndex + "," + inputStream + ")");
            }
            this._pstmt.setBlob(parameterIndex, inputStream);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setBlob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":setNClob(" + parameterIndex + "," + reader + ")");
            }
            this._pstmt.setNClob(parameterIndex, reader);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":exn-setNClob(" + e + ")");
            }
            throw SQLExceptionWrapper.create(e);
        }
    }
}

