/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tools.profiler;

import com.caucho.tools.profiler.Profiler;
import com.caucho.tools.profiler.ProfilerPoint;
import com.caucho.util.Alarm;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ThreadProfiler
implements Profiler {
    private static final Logger log = Logger.getLogger(ThreadProfiler.class.getName());
    private static ThreadLocal<ThreadProfiler> _current = new ThreadLocal();
    private final ArrayList<ProfilerPoint> _nodeStack = new ArrayList();
    private long[] _cumulativeTimeStack = new long[16];
    private boolean[] _unwindStack = new boolean[16];
    private long[] _startTimeStack = new long[16];

    ThreadProfiler() {
    }

    static ThreadProfiler current() {
        ThreadProfiler current = _current.get();
        if (current == null) {
            current = new ThreadProfiler();
            _current.set(current);
        }
        return current;
    }

    private long currentTimeNanoseconds() {
        return Alarm.getExactTimeNanoseconds();
    }

    void start(ProfilerPoint profilerPoint) {
        this.start(profilerPoint, false);
    }

    void start(ProfilerPoint guaranteedParent, ProfilerPoint profilerPoint) {
        int stackLen = this._nodeStack.size();
        boolean isParentFound = false;
        for (int i = 0; i < stackLen; ++i) {
            if (this._nodeStack.get(i) != guaranteedParent) continue;
            isParentFound = true;
            break;
        }
        if (!isParentFound) {
            this.start(guaranteedParent, true);
        }
        this.start(profilerPoint, false);
    }

    private void start(ProfilerPoint node, boolean isUnwind) {
        int stackLen = this._nodeStack.size();
        int topOfStack = stackLen - 1;
        if (stackLen == 0) {
            Object parentNode = null;
        } else {
            ProfilerPoint parentNode = this._nodeStack.get(topOfStack);
            long parentStartTime = this._startTimeStack[topOfStack];
            long parentTime = this.currentTimeNanoseconds() - parentStartTime;
            int n = topOfStack;
            this._cumulativeTimeStack[n] = this._cumulativeTimeStack[n] + parentTime;
        }
        int stackCapacity = this._startTimeStack.length;
        int newStackCapacity = stackLen + 2;
        if (newStackCapacity > stackCapacity) {
            long[] newStartTimeStack = new long[stackCapacity * 3 / 2 + 1];
            System.arraycopy(this._startTimeStack, 0, newStartTimeStack, 0, stackCapacity);
            this._startTimeStack = newStartTimeStack;
            long[] newCumulativeTimeStack = new long[stackCapacity * 3 / 2 + 1];
            System.arraycopy(this._cumulativeTimeStack, 0, newCumulativeTimeStack, 0, stackCapacity);
            this._cumulativeTimeStack = newCumulativeTimeStack;
            boolean[] newUnwindStack = new boolean[stackCapacity * 3 / 2 + 1];
            System.arraycopy(this._unwindStack, 0, newUnwindStack, 0, stackCapacity);
            this._unwindStack = newUnwindStack;
        }
        long currentTime = this.currentTimeNanoseconds();
        this._nodeStack.add(node);
        this._unwindStack[stackLen] = isUnwind;
        this._startTimeStack[stackLen] = currentTime;
        this._cumulativeTimeStack[stackLen] = 0L;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + stackLen + "] start " + node + " isUnwind=" + isUnwind);
            log.log(Level.FINEST, "", new Exception());
        }
    }

    public void finish() {
        int removeIndex = this._nodeStack.size() - 1;
        ProfilerPoint node = this._nodeStack.remove(removeIndex);
        long startTime = this._startTimeStack[removeIndex];
        long currentTime = this.currentTimeNanoseconds();
        long time = currentTime - startTime;
        long totalTime = this._cumulativeTimeStack[removeIndex] + time;
        node.update(totalTime);
        int parentIndex = removeIndex - 1;
        if (parentIndex >= 0) {
            this._startTimeStack[parentIndex] = this.currentTimeNanoseconds();
            boolean isUnwind = this._unwindStack[parentIndex];
            if (log.isLoggable(Level.FINEST)) {
                log.finest("[" + removeIndex + "] finish " + node + " isUnwind=" + isUnwind);
            }
            if (isUnwind) {
                this.finish();
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + removeIndex + "] finish " + node);
        }
    }

    public String toString() {
        return "Profiler[" + Thread.currentThread().getName() + "]";
    }
}

