/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.transaction.ManagedPoolItem;
import com.caucho.util.L10N;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ThreadConnectionManager {
    private static final L10N L = new L10N(ThreadConnectionManager.class);
    private static final Logger log = Logger.getLogger(ThreadConnectionManager.class.getName());
    private static final ThreadLocal<ThreadConnectionManager> _threadManager = new ThreadLocal();
    private ArrayList<SoftReference<ManagedPoolItem>> _activeConnections = new ArrayList();

    public static ThreadConnectionManager getThreadManager() {
        return _threadManager.get();
    }

    public static void setThreadManager(ThreadConnectionManager manager) {
        _threadManager.set(manager);
    }

    public static ThreadConnectionManager createThreadManager() {
        ThreadConnectionManager cm = _threadManager.get();
        if (cm == null) {
            cm = new ThreadConnectionManager();
            _threadManager.set(cm);
        }
        return cm;
    }

    public static void addConnection(ManagedPoolItem conn) {
        ThreadConnectionManager.createThreadManager().add(conn);
    }

    public static void removeConnection(ManagedPoolItem conn) {
        ThreadConnectionManager.createThreadManager().remove(conn);
    }

    private void add(ManagedPoolItem conn) {
        this._activeConnections.add(new SoftReference<ManagedPoolItem>(conn));
    }

    private void remove(ManagedPoolItem conn) {
        for (int i = this._activeConnections.size() - 1; i >= 0; --i) {
            ManagedPoolItem aConn = this._activeConnections.get(i).get();
            if (aConn != null && aConn != conn) continue;
            this._activeConnections.remove(i);
        }
    }
}

