/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.config.inject.SingletonBindingHandle;
import com.caucho.config.types.Period;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionSynchronizationRegistryImpl;
import com.caucho.transaction.XidImpl;
import com.caucho.transaction.xalog.AbstractXALogManager;
import com.caucho.transaction.xalog.AbstractXALogStream;
import com.caucho.util.Alarm;
import com.caucho.util.Crc64;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionManagerImpl
implements TransactionManager,
Serializable,
ClassLoaderListener {
    private static final long serialVersionUID = 1L;
    private static L10N L = new L10N(TransactionManagerImpl.class);
    private static Logger log = Logger.getLogger(TransactionManagerImpl.class.getName());
    private static TransactionManagerImpl _tm = new TransactionManagerImpl();
    private int _serverId;
    private long _randomId = RandomUtil.getRandomLong();
    private AtomicLong _sequence = new AtomicLong(Alarm.getCurrentTime());
    private AbstractXALogManager _xaLogManager;
    private TransactionSynchronizationRegistry _syncRegistry = new TransactionSynchronizationRegistryImpl(this);
    private ThreadLocal<TransactionImpl> _threadTransaction = new ThreadLocal();
    private ArrayList<WeakReference<TransactionImpl>> _transactionList = new ArrayList();
    private long _timeout = -1L;

    public static TransactionManagerImpl getInstance() {
        return _tm;
    }

    public static TransactionManagerImpl getLocal() {
        return _tm;
    }

    public void setTimeout(Period timeout) {
        this._timeout = timeout.getPeriod();
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setXALogManager(AbstractXALogManager xaLogManager) {
        this._xaLogManager = xaLogManager;
    }

    public TransactionSynchronizationRegistry getSyncRegistry() {
        return this._syncRegistry;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getCurrent().begin();
    }

    XidImpl createXID() {
        return new XidImpl(this.getServerId(), this._randomId, this._sequence.incrementAndGet());
    }

    AbstractXALogStream getXALogStream() {
        if (this._xaLogManager != null) {
            return this._xaLogManager.getStream();
        }
        return null;
    }

    private int getServerId() {
        if (this._serverId == 0) {
            String server = (String)Environment.getAttribute("caucho.server-id");
            this._serverId = server == null ? 1 : (int)Crc64.generate(server);
        }
        return this._serverId;
    }

    public TransactionImpl getTransaction() {
        TransactionImpl trans = this._threadTransaction.get();
        if (trans == null || trans.getStatus() == 6 || trans.getStatus() == 5 || trans.isSuspended()) {
            return null;
        }
        return trans;
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl trans = this._threadTransaction.get();
        if (trans == null || !trans.hasResources() && (trans.getStatus() == 6 || trans.getStatus() == 5)) {
            return null;
        }
        this._threadTransaction.set(null);
        trans.suspend();
        return trans;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, SystemException {
        Transaction old = this._threadTransaction.get();
        if (old != null && old.getStatus() != 6) {
            throw new SystemException(L.l("can't resume transaction with active transaction {0}", String.valueOf(old)));
        }
        TransactionImpl impl = (TransactionImpl)tobj;
        impl.resume();
        this._threadTransaction.set(impl);
    }

    public void setRollbackOnly() throws SystemException {
        this.getCurrent().setRollbackOnly();
    }

    public void setRollbackOnly(Exception e) {
        this.getCurrent().setRollbackOnly(e);
    }

    public int getStatus() throws SystemException {
        return this.getCurrent().getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getCurrent().setTransactionTimeout(seconds);
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.getCurrent().commit();
    }

    public void rollback() {
        this.getCurrent().rollback();
    }

    public TransactionImpl getCurrent() {
        TransactionImpl trans = this._threadTransaction.get();
        if (trans == null || trans.isDead()) {
            trans = new TransactionImpl(this);
            this._threadTransaction.set(trans);
            this.addTransaction(trans);
        }
        return trans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransaction(TransactionImpl trans) {
        ArrayList<WeakReference<TransactionImpl>> arrayList = this._transactionList;
        synchronized (arrayList) {
            for (int i = this._transactionList.size() - 1; i >= 0; --i) {
                WeakReference<TransactionImpl> ref = this._transactionList.get(i);
                if (ref.get() != null) continue;
                this._transactionList.remove(i);
            }
            this._transactionList.add(new WeakReference<TransactionImpl>(trans));
        }
    }

    public void recover(XAResource xaRes) throws XAException {
        Xid[] xids = null;
        try {
            xids = xaRes.recover(0x1800000);
        }
        catch (XAException e) {
            int code = e.errorCode;
            System.out.println("E: " + e + " " + e.errorCode + " " + e.getMessage());
            if (e.getMessage() == null || e.getMessage().isEmpty()) {
                XAException e1 = new XAException(L.l("Error during recovery (code=" + code + ")", e));
                e1.errorCode = code;
                throw e1;
            }
            throw e;
        }
        if (xids == null) {
            return;
        }
        for (int i = 0; i < xids.length; ++i) {
            byte[] global = xids[i].getGlobalTransactionId();
            if (global.length != 28) continue;
            XidImpl xidImpl = new XidImpl(xids[i].getGlobalTransactionId());
            if (this._xaLogManager != null && this._xaLogManager.hasCommittedXid(xidImpl)) {
                log.fine(L.l("XAResource {0} commit xid {1}", (Object)xaRes, xidImpl));
                try {
                    xaRes.commit(xidImpl, false);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                continue;
            }
            log.fine(L.l("XAResource {0} forget xid {1}", (Object)xaRes, xidImpl));
            try {
                xaRes.forget(xidImpl);
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void flush() {
        if (this._xaLogManager != null) {
            this._xaLogManager.flush();
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLoaderDestroy(DynamicClassLoader loader) {
        AbstractXALogManager xaLogManager = this._xaLogManager;
        this._xaLogManager = null;
        if (xaLogManager != null) {
            xaLogManager.close();
        }
        this._serverId = 0;
        ArrayList<TransactionImpl> xaList = new ArrayList<TransactionImpl>();
        ArrayList<WeakReference<TransactionImpl>> arrayList = this._transactionList;
        synchronized (arrayList) {
            for (int i = this._transactionList.size() - 1; i >= 0; --i) {
                WeakReference<TransactionImpl> ref = this._transactionList.get(i);
                TransactionImpl xa = (TransactionImpl)ref.get();
                if (xa == null) continue;
                xaList.add(xa);
            }
        }
        for (TransactionImpl xa : xaList) {
            try {
                xa.rollback();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void testClear() {
        this._serverId = 0;
        this._timeout = -1L;
        AbstractXALogManager logManager = this._xaLogManager;
        this._xaLogManager = null;
        this._sequence.set(Alarm.getCurrentTime());
        if (logManager != null) {
            logManager.close();
        }
    }

    private Object writeReplace() {
        return new SingletonBindingHandle(TransactionManager.class, new Annotation[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

