/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.transaction.BeginResource;
import com.caucho.transaction.CloseResource;
import com.caucho.transaction.ManagedPoolItem;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserPoolItem;
import com.caucho.transaction.UserTransactionSuspendState;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class UserTransactionImpl
implements UserTransaction {
    private static final Logger log = Logger.getLogger(UserTransactionImpl.class.getName());
    private static final L10N L = new L10N(UserTransactionImpl.class);
    private TransactionManagerImpl _transactionManager;
    private ArrayList<UserPoolItem> _resources = new ArrayList();
    private ArrayList<ManagedPoolItem> _poolItems = new ArrayList();
    private ArrayList<BeginResource> _beginResources = new ArrayList();
    private ArrayList<CloseResource> _closeResources = new ArrayList();
    private boolean _isInContext;
    private boolean _isTransactionActive;

    public UserTransactionImpl(TransactionManagerImpl tm) {
        this._transactionManager = tm;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this._transactionManager.setTransactionTimeout(seconds);
    }

    public int getStatus() throws SystemException {
        return this._transactionManager.getStatus();
    }

    public boolean isInContext() {
        return this._isInContext;
    }

    public void setInContext(boolean isInContext) {
        this._isInContext = isInContext;
    }

    void enlistResource(UserPoolItem resource) throws SystemException, RollbackException {
        if (this._resources.contains(resource)) {
            return;
        }
        TransactionImpl xa = this._transactionManager.getTransaction();
        if (xa != null && xa.isActive()) {
            ManagedPoolItem poolItem = resource.getXAPoolItem();
            this.enlistPoolItem(xa, poolItem);
        }
        this._resources.add(resource);
    }

    private void enlistPoolItem(Transaction xa, ManagedPoolItem poolItem) throws SystemException, RollbackException {
        TransactionImpl xaImpl;
        if (poolItem == null) {
            return;
        }
        if (!poolItem.supportsTransaction()) {
            return;
        }
        if (this._poolItems.contains(poolItem)) {
            return;
        }
        poolItem.setTransaction(this);
        if (xa instanceof TransactionImpl && (xaImpl = (TransactionImpl)xa).allowLocalTransactionOptimization()) {
            poolItem.enableLocalTransactionOptimization(true);
        }
        if (poolItem.getXid() == null) {
            xa.enlistResource((XAResource)poolItem);
        }
        this._poolItems.add(poolItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delistPoolItem(ManagedPoolItem poolItem, int flags) throws SystemException, RollbackException {
        TransactionImpl xa = this._transactionManager.getTransaction();
        try {
            if (xa != null) {
                xa.delistResource(poolItem, flags);
            }
            Object var5_4 = null;
            this._poolItems.remove(poolItem);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._poolItems.remove(poolItem);
            throw throwable;
        }
    }

    void delistResource(UserPoolItem resource) {
        this._resources.remove(resource);
    }

    public void enlistBeginResource(BeginResource resource) {
        this._beginResources.add(resource);
        try {
            TransactionImpl xa = this._transactionManager.getTransaction();
            if (xa != null) {
                resource.begin(xa);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void enlistCloseResource(CloseResource resource) {
        this._closeResources.add(resource);
    }

    UserPoolItem allocate(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (!this._isTransactionActive) {
            return null;
        }
        ArrayList<ManagedPoolItem> poolItems = this._poolItems;
        int length = poolItems.size();
        for (int i = 0; i < length; ++i) {
            ManagedPoolItem poolItem = poolItems.get(i);
            UserPoolItem item = poolItem.allocateXA(mcf, subject, info);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    ManagedPoolItem findJoin(ManagedPoolItem item) {
        if (!this._isTransactionActive) {
            return null;
        }
        ArrayList<ManagedPoolItem> poolItems = this._poolItems;
        int length = poolItems.size();
        for (int i = 0; i < length; ++i) {
            ManagedPoolItem poolItem = poolItems.get(i);
            if (!poolItem.isJoin(item)) continue;
            return poolItem;
        }
        return null;
    }

    public Xid getXid() throws SystemException, RollbackException {
        TransactionImpl xa = this._transactionManager.getTransaction();
        if (xa != null) {
            return xa.getXid();
        }
        return null;
    }

    public int getEnlistedResourceCount() throws SystemException, RollbackException {
        TransactionImpl xa = this._transactionManager.getTransaction();
        if (xa != null) {
            return xa.getEnlistedResourceCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws NotSupportedException, SystemException {
        block17: {
            IllegalStateException e12;
            if (this._isTransactionActive) {
                throw new NotSupportedException(L.l("UserTransaction.begin() is not allowed because an active transaction already exists.  This may be caused by either a missing commit/rollback or a nested begin().  Nested transactions are not supported."));
            }
            this._transactionManager.begin();
            this._isTransactionActive = true;
            boolean isOkay = false;
            try {
                int i;
                TransactionImpl xa = this._transactionManager.getTransaction();
                xa.setUserTransaction(this);
                this._poolItems.clear();
                int length = this._resources.size();
                for (i = 0; i < length; ++i) {
                    ManagedPoolItem poolItem;
                    UserPoolItem userPoolItem = this._resources.get(i);
                    for (int j = this._poolItems.size() - 1; j >= 0 && !(poolItem = this._poolItems.get(j)).share(userPoolItem); --j) {
                    }
                    ManagedPoolItem xaPoolItem = userPoolItem.getXAPoolItem();
                    if (this._poolItems.contains(xaPoolItem)) continue;
                    this._poolItems.add(xaPoolItem);
                }
                for (i = 0; i < this._poolItems.size(); ++i) {
                    ManagedPoolItem poolItem = this._poolItems.get(i);
                    poolItem.enableLocalTransactionOptimization(this._poolItems.size() == 1);
                    try {
                        xa.enlistResource(poolItem);
                        continue;
                    }
                    catch (Exception e) {
                        String message = L.l("Failed to begin UserTransaction due to: {0}", e);
                        log.log(Level.SEVERE, message, e);
                        throw new SystemException(message);
                    }
                }
                for (i = 0; i < this._beginResources.size(); ++i) {
                    try {
                        BeginResource resource = this._beginResources.get(i);
                        resource.begin(xa);
                        continue;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
                isOkay = true;
                Object var9_11 = null;
                if (isOkay) break block17;
                e12 = new IllegalStateException(L.l("Rolling back transaction from failed begin."));
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!isOkay) {
                    IllegalStateException e12 = new IllegalStateException(L.l("Rolling back transaction from failed begin."));
                    e12.fillInStackTrace();
                    log.log(Level.WARNING, e12.toString(), e12);
                    this._isTransactionActive = false;
                    ArrayList<ManagedPoolItem> recoveryList = new ArrayList<ManagedPoolItem>(this._poolItems);
                    this._poolItems.clear();
                    this._resources.clear();
                    for (int i = 0; i < recoveryList.size(); ++i) {
                        try {
                            ManagedPoolItem item = recoveryList.get(i);
                            item.abortConnection();
                            item.destroy();
                            continue;
                        }
                        catch (Throwable e) {
                            log.log(Level.FINE, e.toString(), e);
                        }
                    }
                    this._transactionManager.rollback();
                }
                throw throwable;
            }
            e12.fillInStackTrace();
            log.log(Level.WARNING, e12.toString(), e12);
            this._isTransactionActive = false;
            ArrayList<ManagedPoolItem> recoveryList = new ArrayList<ManagedPoolItem>(this._poolItems);
            this._poolItems.clear();
            this._resources.clear();
            for (int i = 0; i < recoveryList.size(); ++i) {
                try {
                    ManagedPoolItem item = recoveryList.get(i);
                    item.abortConnection();
                    item.destroy();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            this._transactionManager.rollback();
            {
            }
        }
    }

    public UserTransactionSuspendState userSuspend() {
        if (!this._isTransactionActive) {
            throw new IllegalStateException(L.l("UserTransaction.suspend may only be called in a transaction, but no transaction is active."));
        }
        this._isTransactionActive = false;
        UserTransactionSuspendState state = new UserTransactionSuspendState(this._poolItems);
        this._poolItems.clear();
        return state;
    }

    public void userResume(UserTransactionSuspendState state) {
        if (this._isTransactionActive) {
            throw new IllegalStateException(L.l("UserTransaction.resume may only be called outside of a transaction, because the resumed transaction must not conflict with an active transaction."));
        }
        this._isTransactionActive = true;
        this._poolItems.addAll(state.getPoolItems());
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this._transactionManager.setRollbackOnly();
    }

    public void setRollbackOnly(Exception e) throws IllegalStateException {
        this._transactionManager.setRollbackOnly(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            if (!this._isTransactionActive) {
                throw new IllegalStateException("UserTransaction.commit() requires an active transaction.  Either the UserTransaction.begin() is missing or the transaction has already been committed or rolled back.");
            }
            this._transactionManager.commit();
            Object var2_1 = null;
            this._poolItems.clear();
            this._isTransactionActive = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._poolItems.clear();
            this._isTransactionActive = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this._transactionManager.rollback();
            Object var2_1 = null;
            this._isTransactionActive = false;
            this._poolItems.clear();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._isTransactionActive = false;
            this._poolItems.clear();
            throw throwable;
        }
    }

    public void abortTransaction() throws IllegalStateException {
        IllegalStateException exn = null;
        this._isInContext = false;
        boolean isTransactionActive = this._isTransactionActive;
        this._isTransactionActive = false;
        if (!isTransactionActive && this._poolItems.size() > 0) {
            IllegalStateException e = new IllegalStateException("Internal error: user transaction pool broken because poolItems exist, but no transaction is active.");
            log.log(Level.WARNING, e.toString(), e);
        }
        this._poolItems.clear();
        if (isTransactionActive) {
            try {
                exn = new IllegalStateException(L.l("Transactions must have a commit() or rollback() in a finally block."));
                log.warning("Rolling back dangling transaction.  All transactions must have a commit() or rollback() in a finally block.");
                this._transactionManager.rollback();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString());
            }
        }
        this._beginResources.clear();
        while (this._closeResources.size() > 0) {
            try {
                CloseResource resource = this._closeResources.remove(this._closeResources.size() - 1);
                resource.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        boolean hasWarning = false;
        while (this._resources.size() > 0) {
            UserPoolItem userPoolItem = this._resources.remove(this._resources.size() - 1);
            if (!userPoolItem.isCloseDanglingConnections()) continue;
            if (!hasWarning) {
                hasWarning = true;
                log.warning("Closing dangling connections.  All connections must have a close() in a finally block.");
            }
            try {
                IllegalStateException stackTrace = userPoolItem.getAllocationStackTrace();
                if (stackTrace != null) {
                    log.log(Level.WARNING, stackTrace.getMessage(), stackTrace);
                } else {
                    userPoolItem.setSaveAllocationStackTrace(true);
                }
                if (exn == null) {
                    exn = new IllegalStateException(L.l("Connection {0} was not closed. Connections must have a close() in a finally block.", userPoolItem.getUserConnection()));
                }
                userPoolItem.abortConnection();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        this._poolItems.clear();
        try {
            this._transactionManager.setTransactionTimeout(0);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (exn != null) {
            throw exn;
        }
    }
}

