/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.transaction;

import com.caucho.config.inject.SingletonBindingHandle;
import com.caucho.transaction.BeginResource;
import com.caucho.transaction.CloseResource;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class UserTransactionProxy
implements UserTransaction,
TransactionManager,
Serializable {
    private static final Logger log = Logger.getLogger(UserTransactionProxy.class.getName());
    private static final L10N L = new L10N(UserTransactionProxy.class);
    private static final UserTransactionProxy _proxy = new UserTransactionProxy();
    private static final ThreadLocal<UserTransactionImpl> _threadTransaction = new ThreadLocal();

    private UserTransactionProxy() {
    }

    public static UserTransactionProxy getInstance() {
        return _proxy;
    }

    public static UserTransactionProxy getCurrent() {
        return _proxy;
    }

    public UserTransactionImpl getUserTransaction() {
        UserTransactionImpl xa = _threadTransaction.get();
        if (xa == null) {
            xa = new UserTransactionImpl(TransactionManagerImpl.getLocal());
            _threadTransaction.set(xa);
        }
        xa.setInContext(true);
        return xa;
    }

    public UserTransactionImpl getCurrentUserTransactionImpl() {
        return _threadTransaction.get();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getUserTransaction().setTransactionTimeout(seconds);
    }

    public int getStatus() throws SystemException {
        return this.getUserTransaction().getStatus();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getUserTransaction().begin();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getUserTransaction().setRollbackOnly();
    }

    public void setRollbackOnly(Exception e) throws IllegalStateException {
        this.getUserTransaction().setRollbackOnly(e);
    }

    public void commit() throws IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        this.getUserTransaction().commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getUserTransaction().rollback();
    }

    public void enlistBeginResource(BeginResource resource) throws IllegalStateException {
        this.getUserTransaction().enlistBeginResource(resource);
    }

    public void enlistCloseResource(CloseResource resource) throws IllegalStateException {
        this.getUserTransaction().enlistCloseResource(resource);
    }

    public void abortTransaction() throws IllegalStateException {
        UserTransactionImpl xa = _threadTransaction.get();
        if (xa == null) {
            return;
        }
        xa.abortTransaction();
    }

    public void recover(XAResource xaRes) throws XAException {
        TransactionManagerImpl.getLocal().recover(xaRes);
    }

    public Transaction getTransaction() throws SystemException {
        return TransactionManagerImpl.getLocal().getTransaction();
    }

    public Transaction suspend() throws SystemException {
        return TransactionManagerImpl.getLocal().suspend();
    }

    public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
        TransactionManagerImpl.getLocal().resume(transaction);
    }

    private Object writeReplace() {
        return new SingletonBindingHandle(UserTransaction.class, new Annotation[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

