/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.TimeInterval;
import com.caucho.util.TimeIntervalElement;
import com.caucho.util.TimeIntervalEntry;
import com.caucho.util.TimeIntervalScheduler;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSoftScheduler<E extends TimeIntervalEntry>
implements TimeIntervalScheduler<E> {
    private long _clockTic;
    private final Map<TimeInterval, ConcurrentLinkedQueue<Reference<E>>> _map = new ConcurrentHashMap<TimeInterval, ConcurrentLinkedQueue<Reference<E>>>();
    private final Random _speader = new Random(37L);
    private TimeIntervalScheduler.ScheduleType _scheduleType = TimeIntervalScheduler.ScheduleType.WEAK;

    public AbstractSoftScheduler(long clockTic) {
        this._clockTic = clockTic;
    }

    public AbstractSoftScheduler(long clockTic, TimeIntervalScheduler.ScheduleType scheduleType) {
        this._clockTic = clockTic;
        this._scheduleType = scheduleType;
    }

    private AbstractSoftScheduler() {
    }

    @Override
    public final void schedule(E entry) {
        this.schedule(entry, Alarm.getCurrentTime());
    }

    @Override
    public final void schedule(E entry, long time) {
        TimeInterval schedule = this.getSchedulerInterval(time);
        ConcurrentLinkedQueue<Reference<Reference<E>>> entries = this._map.get(schedule);
        if (entries == null) {
            entries = new ConcurrentLinkedQueue();
        }
        entries.add(this.createReference(entry));
    }

    @Override
    public final void schedule(E entry, TimeInterval timeInterval) {
        long scheduleFor = timeInterval.startTime() + (long)this._speader.nextInt((int)timeInterval.duration());
        this.schedule(entry, scheduleFor);
    }

    @Override
    public final TimeInterval getSchedulerInterval(long time) {
        long now = Alarm.getCurrentTime();
        long rNow = now % this._clockTic;
        long starts = now - rNow;
        long stops = now + this._clockTic;
        return new TimeIntervalElement(starts, stops);
    }

    @Override
    public final TimeInterval getSchedulerInterval(long time, long interavalDuration) {
        long now = Alarm.getCurrentTime();
        long rNow = now % interavalDuration;
        long starts = now - rNow;
        long stops = now + interavalDuration;
        return new TimeIntervalElement(starts, stops);
    }

    public int size() {
        return this._map.size();
    }

    public int scheduleSize(long time) {
        TimeInterval schedule = this.getSchedulerInterval(time);
        ConcurrentLinkedQueue<Reference<E>> queue = this._map.get(schedule);
        return queue != null ? queue.size() : 0;
    }

    private Reference<E> createReference(E entry) {
        switch (this._scheduleType) {
            case SOFT: {
                return new SoftReference<E>(entry);
            }
        }
        return new WeakReference<E>(entry);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

