/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class Base64 {
    private static final int[] _decode;
    private static final char[] _encode;

    public static void encode(CharBuffer cb, long data) {
        cb.append(Base64.encode(data >> 60));
        cb.append(Base64.encode(data >> 54));
        cb.append(Base64.encode(data >> 48));
        cb.append(Base64.encode(data >> 42));
        cb.append(Base64.encode(data >> 36));
        cb.append(Base64.encode(data >> 30));
        cb.append(Base64.encode(data >> 24));
        cb.append(Base64.encode(data >> 18));
        cb.append(Base64.encode(data >> 12));
        cb.append(Base64.encode(data >> 6));
        cb.append(Base64.encode(data));
    }

    public static void encode(StringBuilder sb, long data) {
        sb.append(Base64.encode(data >> 60));
        sb.append(Base64.encode(data >> 54));
        sb.append(Base64.encode(data >> 48));
        sb.append(Base64.encode(data >> 42));
        sb.append(Base64.encode(data >> 36));
        sb.append(Base64.encode(data >> 30));
        sb.append(Base64.encode(data >> 24));
        sb.append(Base64.encode(data >> 18));
        sb.append(Base64.encode(data >> 12));
        sb.append(Base64.encode(data >> 6));
        sb.append(Base64.encode(data));
    }

    public static void encode24(CharBuffer cb, int data) {
        cb.append(Base64.encode(data >> 18));
        cb.append(Base64.encode(data >> 12));
        cb.append(Base64.encode(data >> 6));
        cb.append(Base64.encode(data));
    }

    public static String encode(byte[] buffer) {
        StringBuilder sb = new StringBuilder();
        Base64.encode(sb, buffer, 0, buffer.length);
        return sb.toString();
    }

    public static void encode(CharBuffer cb, byte[] buffer, int offset, int length) {
        int data;
        while (length >= 3) {
            data = (buffer[offset] & 0xFF) << 16;
            data += (buffer[offset + 1] & 0xFF) << 8;
            cb.append(Base64.encode((data += buffer[offset + 2] & 0xFF) >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            offset += 3;
            length -= 3;
        }
        if (length == 2) {
            int b1 = buffer[offset] & 0xFF;
            int b2 = buffer[offset + 1] & 0xFF;
            int data2 = (b1 << 16) + (b2 << 8);
            cb.append(Base64.encode(data2 >> 18));
            cb.append(Base64.encode(data2 >> 12));
            cb.append(Base64.encode(data2 >> 6));
            cb.append('=');
        } else if (length == 1) {
            data = (buffer[offset] & 0xFF) << 16;
            cb.append(Base64.encode(data >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append('=');
            cb.append('=');
        }
    }

    public static void encode(StringBuilder cb, byte[] buffer, int offset, int length) {
        int data;
        while (length >= 3) {
            data = (buffer[offset] & 0xFF) << 16;
            data += (buffer[offset + 1] & 0xFF) << 8;
            cb.append(Base64.encode((data += buffer[offset + 2] & 0xFF) >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            offset += 3;
            length -= 3;
        }
        if (length == 2) {
            int b1 = buffer[offset] & 0xFF;
            int b2 = buffer[offset + 1] & 0xFF;
            int data2 = (b1 << 16) + (b2 << 8);
            cb.append(Base64.encode(data2 >> 18));
            cb.append(Base64.encode(data2 >> 12));
            cb.append(Base64.encode(data2 >> 6));
            cb.append('=');
        } else if (length == 1) {
            data = (buffer[offset] & 0xFF) << 16;
            cb.append(Base64.encode(data >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append('=');
            cb.append('=');
        }
    }

    public static void oldEncode(CharBuffer cb, byte[] buffer, int offset, int length) {
        int data;
        while (length >= 3) {
            data = (buffer[offset] & 0xFF) << 16;
            data += (buffer[offset + 1] & 0xFF) << 8;
            cb.append(Base64.encode((data += buffer[offset + 2] & 0xFF) >> 18));
            cb.append(Base64.encode(data >> 12));
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            offset += 3;
            length -= 3;
        }
        if (length == 2) {
            int b1 = buffer[offset] & 0xFF;
            int b2 = buffer[offset + 1] & 0xFF;
            int data2 = (b1 << 8) + b2;
            cb.append(Base64.encode(data2 >> 12));
            cb.append(Base64.encode(data2 >> 6));
            cb.append(Base64.encode(data2));
            cb.append('=');
        } else if (length == 1) {
            data = buffer[offset] & 0xFF;
            cb.append(Base64.encode(data >> 6));
            cb.append(Base64.encode(data));
            cb.append('=');
            cb.append('=');
        }
    }

    public static char encode(long d) {
        return _encode[(int)(d & 0x3FL)];
    }

    public static int decode(int d) {
        return _decode[d];
    }

    public static String encode(String value) {
        try {
            StringWriter sw = new StringWriter();
            Base64.encode(sw, new ByteArrayInputStream(value.getBytes("iso-8859-1")));
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should not be possible: " + e);
        }
    }

    public static String encodeFromByteArray(byte[] value) {
        try {
            StringWriter sw = new StringWriter();
            Base64.encode(sw, new ByteArrayInputStream(value));
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should not be possible " + e);
        }
    }

    public static String encodeFromByteArray(byte[] value, int offset, int length) {
        try {
            StringWriter sw = new StringWriter();
            Base64.encode(sw, new ByteArrayInputStream(value, offset, length));
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should not be possible " + e);
        }
    }

    public static void encode(Writer w, InputStream i) throws IOException {
        long chunk;
        int value2;
        int value1;
        while (true) {
            value1 = i.read();
            value2 = i.read();
            int value3 = i.read();
            if (value3 < 0) break;
            chunk = value1 & 0xFF;
            chunk = (chunk << 8) + (long)(value2 & 0xFF);
            chunk = (chunk << 8) + (long)(value3 & 0xFF);
            w.write(Base64.encode(chunk >> 18));
            w.write(Base64.encode(chunk >> 12));
            w.write(Base64.encode(chunk >> 6));
            w.write(Base64.encode(chunk));
        }
        if (value2 >= 0) {
            chunk = value1 & 0xFF;
            chunk = (chunk << 8) + (long)(value2 & 0xFF);
            w.write(Base64.encode((chunk <<= 8) >> 18));
            w.write(Base64.encode(chunk >> 12));
            w.write(Base64.encode(chunk >> 6));
            w.write(61);
        } else if (value1 >= 0) {
            chunk = value1 & 0xFF;
            w.write(Base64.encode((chunk <<= 16) >> 18));
            w.write(Base64.encode(chunk >> 12));
            w.write(61);
            w.write(61);
        }
        w.flush();
    }

    public static String decode(String value) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64.decode(new StringReader(value), baos);
            return new String(baos.toByteArray(), "iso-8859-1");
        }
        catch (IOException e) {
            throw new RuntimeException("this should not be possible: " + e);
        }
    }

    public static byte[] decodeToByteArray(String value) {
        try {
            if (value == null) {
                return new byte[0];
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64.decode(new StringReader(value), baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("this should not be possible: " + e);
        }
    }

    private static int readNonWhitespace(Reader r) throws IOException {
        int ret;
        block3: while (true) {
            ret = r.read();
            switch (ret) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: 
                case 240: 
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: 
                case 255: {
                    continue block3;
                }
            }
            break;
        }
        return ret;
    }

    public static void decode(Reader r, OutputStream os) throws IOException {
        while (true) {
            int ch0 = Base64.readNonWhitespace(r);
            int ch1 = r.read();
            int ch2 = r.read();
            int ch3 = r.read();
            if (ch1 < 0) break;
            if (ch2 < 0) {
                ch2 = 61;
            }
            if (ch3 < 0) {
                ch3 = 61;
            }
            int chunk = (_decode[ch0] << 18) + (_decode[ch1] << 12) + (_decode[ch2] << 6) + _decode[ch3];
            os.write((byte)(chunk >> 16 & 0xFF));
            if (ch2 != 61 && ch2 != -1) {
                os.write((byte)(chunk >> 8 & 0xFF));
            }
            if (ch3 == 61 || ch3 == -1) break;
            os.write((byte)(chunk & 0xFF));
        }
        os.flush();
    }

    public static void decodeIgnoreWhitespace(Reader r, OutputStream os) throws IOException {
        while (true) {
            int ch0 = Base64.readNonWhitespace(r);
            int ch1 = Base64.readNonWhitespace(r);
            int ch2 = Base64.readNonWhitespace(r);
            int ch3 = Base64.readNonWhitespace(r);
            if (ch1 < 0) break;
            if (ch2 < 0) {
                ch2 = 61;
            }
            if (ch3 < 0) {
                ch3 = 61;
            }
            int chunk = (_decode[ch0] << 18) + (_decode[ch1] << 12) + (_decode[ch2] << 6) + _decode[ch3];
            os.write((byte)(chunk >> 16 & 0xFF));
            if (ch2 != 61 && ch2 != -1) {
                os.write((byte)(chunk >> 8 & 0xFF));
            }
            if (ch3 == 61 || ch3 == -1) break;
            os.write((byte)(chunk & 0xFF));
        }
        os.flush();
    }

    static {
        int ch;
        int i;
        _decode = new int[256];
        for (i = 65; i <= 90; ++i) {
            Base64._decode[i] = i - 65;
        }
        for (i = 97; i <= 122; ++i) {
            Base64._decode[i] = i - 97 + 26;
        }
        for (i = 48; i <= 57; ++i) {
            Base64._decode[i] = i - 48 + 52;
        }
        Base64._decode[43] = 62;
        Base64._decode[47] = 63;
        Base64._decode[61] = 0;
        _encode = new char[64];
        for (ch = 65; ch <= 90; ++ch) {
            Base64._encode[ch - 65] = (char)ch;
        }
        for (ch = 97; ch <= 122; ++ch) {
            Base64._encode[ch - 97 + 26] = (char)ch;
        }
        for (ch = 48; ch <= 57; ++ch) {
            Base64._encode[ch - 48 + 52] = (char)ch;
        }
        Base64._encode[62] = 43;
        Base64._encode[63] = 47;
    }
}

