/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class HashKey {
    private final byte[] _hash;

    public HashKey(byte[] hash) {
        if (hash == null) {
            throw new NullPointerException();
        }
        this._hash = hash;
    }

    public byte[] getHash() {
        return this._hash;
    }

    public static String toString(byte[] hash) {
        return HashKey.toString(hash, hash.length);
    }

    public static String toString(byte[] hash, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int d1 = hash[i] >> 4 & 0xF;
            int d2 = hash[i] & 0xF;
            if (d1 < 10) {
                sb.append((char)(48 + d1));
            } else {
                sb.append((char)(97 + d1 - 10));
            }
            if (d2 < 10) {
                sb.append((char)(48 + d2));
                continue;
            }
            sb.append((char)(97 + d2 - 10));
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 37;
        byte[] buf = this._hash;
        int len = buf.length;
        for (int i = 0; i < len; ++i) {
            hash = 65521 * hash + buf[i];
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashKey)) {
            return false;
        }
        HashKey key = (HashKey)o;
        byte[] hashA = this._hash;
        int len = hashA.length;
        byte[] hashB = key._hash;
        if (len != hashB.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (hashA[i] == hashB[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(HashKey key) {
        if (key == null) {
            return 1;
        }
        byte[] hashA = this._hash;
        byte[] hashB = key._hash;
        int len = hashA.length;
        for (int i = 0; i < len; ++i) {
            int delta = hashA[i] - hashB[i];
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + HashKey.toString(this._hash, 4) + "]";
    }
}

