/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.inject.Module;
import com.caucho.loader.Environment;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class JniTroubleshoot {
    private static final Logger log = Logger.getLogger(JniTroubleshoot.class.getName());
    private static final L10N L = new L10N(JniTroubleshoot.class);
    private static final HashSet<String> _loggedLibraries = new HashSet();
    private String _className;
    private String _libraryName;
    private Throwable _cause;
    private boolean _isValid;

    public JniTroubleshoot(Class<?> cl, String libraryName) {
        this._className = cl.getName();
        this._libraryName = libraryName;
        this._isValid = true;
    }

    public JniTroubleshoot(Class<?> cl, String libraryName, Throwable cause) {
        this._className = cl.getName();
        this._libraryName = libraryName;
        this._cause = cause;
        this._isValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        if (!this._isValid && Environment.isLoggingInitialized()) {
            boolean isLogged = false;
            HashSet<String> hashSet = _loggedLibraries;
            synchronized (hashSet) {
                isLogged = _loggedLibraries.contains(this._libraryName);
                if (!isLogged) {
                    _loggedLibraries.add(this._libraryName);
                }
            }
            if (!isLogged) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, this.getMessage(), this._cause);
                } else {
                    log.warning(this.getMessage());
                }
            }
        }
    }

    public String getMessage() {
        Path lib = this.getLib();
        if (!lib.exists()) {
            if (this.isMacOSX()) {
                return L.l("Unable to find native library '{0}' for {1}. Resin expects to find this library in:\n  (Mac OS X) {2}\nOn Mac OS X, run ./configure; make; make install.\nThe JVM exception was: {3}\n", this._libraryName, this._className, lib.getNativePath(), this._cause);
            }
            if (this.isWin()) {
                return L.l("Unable to find native library '{0}' for {1}. Resin expects to find this library in:\n  (Windows) {2}\nOn Windows, check your installation for the DLL above.\nThe JVM exception was: {3}\n", this._libraryName, this._className, lib.getNativePath(), this._cause);
            }
            return L.l("Unable to find native library '{0}' for {1}. Resin expects to find this library in:\n  (Unix) {2}\nOn Unix, run ./configure; make; make install.\n\nThe JVM exception was: {3}\n", this._libraryName, this._className, lib.getNativePath(), this._cause);
        }
        return L.l("Found library '{0}' as '{1}', but the load failed. The JVM exception was: {2}\n", this._libraryName, lib.getNativePath(), this._cause);
    }

    public void checkIsValid() {
        if (!this._isValid) {
            throw new IllegalStateException(this.getMessage(), this._cause);
        }
    }

    public boolean isEnabled() {
        this.log();
        return this._isValid;
    }

    private boolean is64() {
        return "64".equals(System.getProperty("sun.arch.data.model"));
    }

    private boolean isMacOSX() {
        return System.getProperty("os.name").equals("Mac OS X");
    }

    private boolean isWin() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private Path getLibexec() {
        Path resinHome = CauchoSystem.getResinHome();
        if (this.isWin()) {
            if (this.is64()) {
                return resinHome.lookup("win64");
            }
            return resinHome.lookup("win32");
        }
        if (this.is64()) {
            return resinHome.lookup("libexec64");
        }
        return resinHome.lookup("libexec");
    }

    private Path getLib() {
        Path libexec = this.getLibexec();
        if (this.isMacOSX()) {
            return libexec.lookup("lib" + this._libraryName + ".jnilib");
        }
        if (this.isWin()) {
            return libexec.lookup(this._libraryName + ".dll");
        }
        return libexec.lookup("lib" + this._libraryName + ".so");
    }
}

