/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class ThreadDump {
    private static Logger log = Logger.getLogger(ThreadDump.class.getName());
    private static final ThreadDump _threadDump = new ThreadDump();
    private final AtomicLong _lastDump = new AtomicLong();

    private ThreadDump() {
    }

    public static void dumpThreads() {
        long timeout = 3600000L;
        _threadDump.threadDump(timeout);
    }

    private void threadDump(long timeout) {
        long now = Alarm.getCurrentTime();
        long lastDump = this._lastDump.get();
        if (lastDump + timeout < now && this._lastDump.compareAndSet(lastDump, now)) {
            this.threadDumpImpl();
        }
    }

    private void threadDumpImpl() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] ids = threadBean.getAllThreadIds();
        ThreadInfo[] info = threadBean.getThreadInfo(ids, 32);
        StringBuilder sb = new StringBuilder();
        sb.append("Thread Dump:\n");
        Arrays.sort(info, new ThreadCompare());
        this.buildThreads(sb, info, Thread.State.RUNNABLE, false);
        this.buildThreads(sb, info, Thread.State.RUNNABLE, true);
        this.buildThreads(sb, info, Thread.State.BLOCKED, false);
        this.buildThreads(sb, info, Thread.State.WAITING, false);
        this.buildThreads(sb, info, Thread.State.TIMED_WAITING, false);
        this.buildThreads(sb, info, null, false);
        System.out.println("DUMP2:\n " + sb);
        log.info(sb.toString());
    }

    private void buildThreads(StringBuilder sb, ThreadInfo[] infoArray, Thread.State matchState, boolean isNative) {
        for (ThreadInfo info : infoArray) {
            if (info == null) continue;
            Thread.State state = info.getThreadState();
            if (matchState == Thread.State.RUNNABLE && isNative != info.isInNative()) continue;
            if (state == matchState) {
                this.buildThread(sb, info);
                continue;
            }
            if (state != null || matchState == Thread.State.RUNNABLE || matchState == Thread.State.BLOCKED || matchState == Thread.State.WAITING || matchState == Thread.State.TIMED_WAITING) continue;
            this.buildThread(sb, info);
        }
    }

    private void buildThread(StringBuilder sb, ThreadInfo info) {
        String lockName;
        sb.append("\n\"");
        sb.append(info.getThreadName());
        sb.append("\" id=" + info.getThreadId());
        sb.append(" " + (Object)((Object)info.getThreadState()));
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if ((lockName = info.getLockName()) != null) {
            sb.append("\n    waiting on ");
            sb.append(lockName);
            if (info.getLockOwnerName() != null) {
                sb.append("\n    owned by \"");
                sb.append(info.getLockOwnerName());
                sb.append("\"");
            }
        }
        sb.append("\n");
        StackTraceElement[] stackList = info.getStackTrace();
        if (stackList == null) {
            return;
        }
        for (StackTraceElement stack : stackList) {
            sb.append("  at ");
            sb.append(stack.getClassName());
            sb.append(".");
            sb.append(stack.getMethodName());
            if (stack.getFileName() != null) {
                sb.append(" (");
                sb.append(stack.getFileName());
                if (stack.getLineNumber() > 0) {
                    sb.append(":");
                    sb.append(stack.getLineNumber());
                }
                sb.append(")");
            }
            if (stack.isNativeMethod()) {
                sb.append(" (native)");
            }
            sb.append("\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThreadCompare
    implements Comparator<ThreadInfo> {
        ThreadCompare() {
        }

        @Override
        public int compare(ThreadInfo a, ThreadInfo b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.getThreadState() != b.getThreadState()) {
                return a.getThreadState().ordinal() - b.getThreadState().ordinal();
            }
            if (a.isInNative() && !b.isInNative()) {
                return 1;
            }
            if (b.isInNative() && !a.isInNative()) {
                return -1;
            }
            return a.getThreadName().compareTo(b.getThreadName());
        }
    }
}

